/*
	gd - graphics driver for the Comtal and the Grinnel

	The CRC graphics package

	Carl Crawford
	Purdue University
	W. Lafayette, IN 47907

	September 1981


	Cleaned up to support the new improved Grinnell
	Malcolm Slaney
	October 1983
*/

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <netinet/in.h>

#define L       (512 / sizeof(short))
#define M       (16384 / L)

#define	COMTAL		0
#define	GRINNELL	1

#define	IMAGE		0
#define	OVERLAY		1

#define	Grinnell	"/dev/Gr/"
#define	Comtal		"/dev/ct"
#define	Overlay		"gov"

char	OutputDevice[BUFSIZ];
char    buf[512],bb[512],*bf,*cf;
unsigned short ibuf[L*M],kbuf[L*M];
unsigned short *pp,*qq;

int	Device = COMTAL;			/* Comtal or Grinnell */
int	Mode = OVERLAY;				/* Overlay or Image Plane */
int	Number = 0;				/* Device Number */

int     blank;          /* 1=don't blank device */

FILE	*fdi, *fdo, *fd;/* file descriptors */
FILE	*ifd, *popen();
char    *ifn;           /* input file name */
char    *pname;         /* program name */
char	fill[256*8];	/* speed buffer for comtal image and grinnel */
char	*cp,*po;	/* character pointers */
int	net = 1;	/* 1 send output across network */
char	host[10] = "arpa"; /* last resort host */
int	ks;
int	nleft, nread;

char	*table[] = {
		"if",
		0
	};

main(argc,argv)
	int     argc;
	char    **argv;
{
	register i,j;
	int k;
	char    c;

	/* parse command line */

	pname = *argv;
	while(argv++ , --argc){
		if(argv[0][0] == '-')while(c = *++*argv)switch(c){

			case 'b':       /* blank */
				blank = 1;
				break;
			case 'G':       /* Grinnell */
				Device = GRINNELL;;
				break;
			case 'c':
			case 'C':	/* Comtal */
				Device = COMTAL;
				break;
			case 'i':
				Mode = IMAGE;
				break;
			case 'o':
				Mode = OVERLAY;
				break;
			case '0':	/* device 0 */
			case '1':
			case '2':
			case '3':
			case '4':
				Number = c;
				break;
			case 'm':	/* override machine */
				strcpy(host,*argv+1);
				net = 1;
				goto noption;
			default:
				fprintf(stderr,"bad flag: -%c\n",c);
				exit(1);
			}
		else
			switch(comm(*argv)){

			case 1:
				ifn = *argv + 3;
				break;
		}
noption:
	;
	}

	/* find out where to send output to */

	if((ifd = fopen((Device == COMTAL ? "/usr/lib/graphics/gd.site.Ct" :
					    "/usr/lib/graphics/gd.site.Gr"),
					    "r")) != NULL) {
		fgets(host,10,ifd);
		fclose(ifd);
		host[strlen(host)-1] = 0;
		if(strcmp(host,"local") == 0){
			net = 0;
		}else{
			net = 1;
		}
	}

	if(ifn){
		if((fd = fopen(ifn,"r")) == NULL)
			err("can't open: ",ifn);
	}else{
		fd = stdin;
	}

	/* send to remote machine if necessary */

	if(net){
		short s;
		sprintf(buf,"exec %s %s %s /usr/lib/graphics/gd -%s%s%c%s",
			Device == GRINNELL ? "/usr/ucb/rsh" : "/usr/ecn/ns",
			host,
			Device == GRINNELL ? "" : "-S",
			Device == GRINNELL ? "G" : "C",
			Mode == IMAGE ? "i" : "o",
			Number ? Number : '0',
			blank ? "b" : "");
			
		if((fdo = popen(buf,"w")) == NULL){
			fprintf(stderr,"can't execute pipe to '%s'\n",
				Device == GRINNELL ? "rsh" : "ns");
			exit(1);
		}
		gdread(fileno(fd), ibuf, sizeof(short)*L*M);
		s = 1;
		if (Mode == OVERLAY && htons(s) != s
		    && strcmp(host, "dipl") == 0) {
			unsigned short *sp;
			int i;
			for (i = L*M, sp = ibuf ; i > 0 ; i--, sp++)
				*sp = htons(*sp);
		}
		write(fileno(fdo), ibuf, sizeof(short)*L*M);
		if(pclose(fdo)){
			fprintf(stderr,"%s:/usr/lib/graphics/ngd died\n",host);
			exit(1);
		}
		exit(0);
	}

	/*  use local devices */

	/* find name of machine */
	bzero(host, sizeof(host));
	gethostname(host, sizeof(host)-1);

	sprintf(OutputDevice,"%s%s%c",
		Device == GRINNELL ? Grinnell : Comtal,
		Mode == OVERLAY ? Overlay : "",
		Number ? Number : '0');

	if (Mode == OVERLAY){
		if(blank)if((fdi = fopen(OutputDevice,"r")) == NULL){
			fprintf(stderr,"can't open: %s:%s\n",host,OutputDevice);
			exit(1);
		}
		if((fdo = fopen(OutputDevice,"w")) == NULL){
			fprintf(stderr,"can't open: %s:%s\n",host,OutputDevice);
			exit(1);
		}
		gdread(fileno(fd), ibuf, sizeof(short)*M*L);
		if (blank) {
			gdread(fileno(fdi), kbuf, sizeof(short)*M*L);
			for(j = 0, pp = ibuf, qq = kbuf ; j < M * L ; j++)
				*pp++ |= *qq++;
		}
		write(fileno(fdo), ibuf, sizeof(ibuf));
	}
	else {
		if(Device == COMTAL && !Number){
			if((fdi = fopen("/dev/ct/tc","r")) == NULL){
				fprintf(stderr,"can't open: %s!/dev/ct/tc\n",
					host);
				exit(1);
			}
			fread(buf,sizeof(char),512,fdi);
			fclose(fdi);
			Number = ((buf[4]>>1)&3)+'0';
			sprintf(OutputDevice,"%s%s%c",
				Device == GRINNELL ? Grinnell : Comtal,
				Mode == OVERLAY ? Overlay : "",
				Number ? Number : '0');
		}
		if(blank)if((fdi = fopen(OutputDevice,"r")) == NULL){
			fprintf(stderr,"can't open: %s!%s\n",host,OutputDevice);
			exit(1);
		}
		if((fdo = fopen(OutputDevice,"w")) == NULL){
			fprintf(stderr,"can't open: %s!%s\n",host,OutputDevice);
			exit(1);
		}
		for(i=0,cp=fill;i<256;i++){
			if(i & 0200) *cp++ = 255; else *cp++ = 0;
			if(i & 0100) *cp++ = 255; else *cp++ = 0;
			if(i & 0040) *cp++ = 255; else *cp++ = 0;
			if(i & 0020) *cp++ = 255; else *cp++ = 0;
			if(i & 0010) *cp++ = 255; else *cp++ = 0;
			if(i & 0004) *cp++ = 255; else *cp++ = 0;
			if(i & 0002) *cp++ = 255; else *cp++ = 0;
			if(i & 0001) *cp++ = 255; else *cp++ = 0;
		}
		for(k = 0 ; k < 512 ; k++){
			bf = buf;
			if(fread(ibuf,sizeof(short),32,fd) != 32)
				err("unexpected EOF","");
			for( j = 0,cp = (char *)ibuf ; j < 32 ; j++){
				po = fill + ((0377 &(int)*(cp+1)) << 3);
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				po = fill + ((0377 &(int)*cp) << 3);
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				*bf++ = *po++;
				cp += 2;
			}
			if(blank){
				fread(bb,sizeof(char),512,fdi);
				for(j=0,bf=buf,cf=bb;j<512;j++)*bf++ |= *cf++;
			}
			fwrite(buf,sizeof(char),512,fdo);
		}
		if(blank)
			fclose(fdi);
		fclose(fdo);
	}
}

comm(s)
	char	*s;
{
	register	int	i,j,r;

	for(i=0;table[i];i++){
		for(j=0;(r=table[i][j]) == s[j] && r;j++);
		if(r == 0 && s[j] == '=' && s[j+1] )return(i+1);
	}
	fprintf(stderr,"bad option: %s\n",s);
	exit(1);
}

err(s1,s2)
	char    *s1,*s2;
{
	fprintf(stderr,"%s: %s%s\n",pname,s1,s2);
	exit(1);
}

gdread(fd, buf, nleft)
int fd;
char *buf;
int nleft;
{
	int nread;
	for ( ; nleft > 0 ; ) {
		nread = read(fd, buf, nleft);
		if (nread <= 0) 
			err("unexpected EOF","");
		buf += nread;
		nleft -= nread;
	}
}
