/*
	symbol - plot strings

	The CRC graphics package

	Carl Crawford
	Purdue University
	W. Lafayette, IN 47907

*/

#include	"crc.h"

symbol(x,y,height,str,angle)
	float x,y,angle;
	float height;
	char *str;
{
	int f,vis;
	int charfont();
	float xx,yy,t1,t2,ca,sa,d2r;
	static	float	oangle,oheight;
	static	int	first	= 1;	/* ==1 if first call	*/
	int	dollar;
	char    cc;

	if(DEV == TEK && DEVN == 2 && index(str,'$') == 0) {
	    register	int	i;
	    plot(x,y,3);
	    if(oangle != angle || first) {
		plotp(ESC);	/* Graphic text rotation	*/
		plotp('M');
		plotp('R');
		tint((int) angle); tint(0);
		oangle = angle;
		}
	    if(oheight != height || first) {
		plotp(ESC);	/* Graphic test size		*/
		plotp('M');
		plotp('C');
		tint((int)(190*height));
		tint((int)(265*height));
		tint((int)( 75*height));
		oheight = height;
		}
	    first = 0;
	    plotp(ESC);	/* Output graphic string	*/
	    plotp('L');
	    plotp('T');
	    tint(strlen(str));
	    for(i=0; str[i]; i++)
		plotp(str[i]);
	    return;
	    }

	d2r = 4.0 * atan(1.0) / 180.0;
	dollar = 0;
	angle *= d2r;
	sa = sin(angle);
	ca = cos(angle);
	plot(x,y,3);

	while(cc = *str){
		if(cc == '$' && dollar == 0){
			dollar = 1;
			str++;
		}
		else{
			if(dollar == 1){
				dollar = 0;
				cc += 0200;
			}

/*				/* kludge bad font defintition for '.' */
/*			if(cc == '.' && DEV <= MBIT)
/*				cc = ',';
 */
			do{
				f = charfont(cc,height,&xx,&yy,&vis);
				t1 = ca * xx - sa * yy;
				t2 = sa * xx + ca *yy;
				plot(t1+x,t2+y,3-vis);
			}
			while(f);
			x += t1;
			y += t2;
			str++;
		}
	}
}

/*   Charfont is a program that looks up the end points  of  line
segments  for  plotting  characters.   Each  time  'charfont'  is
called, it returns the relative coordinates, which when added  to
the  current  location yields the final end point for a line seg-
ment.  The initial point of the line segment is the current loca-
tion.   Whether the line segment is to be visible or not is indi-
cated by the returned value in "visflg". */

short  *pntcoord;	/* pointer to coordinates */
int	initflg;	/* 1=open font file */
struct  {		/* header structure */
	short  height;
	short  coordsz;
	short  pntr1st[256];
}fontcom;

charfont(symbol,height,x,y,visflg)
	char  symbol;
	float  height, *x, *y;
	int  *visflg;
{
	int  i;
	static short *pntr;
	static float  scale;
	register int  temp;

	if(initflg == 0)
		fontinit(BINARY_FONT_FILE);

	/* find coordinate of first point */

	if (pntr == 0) {
		if ( (i=fontcom.pntr1st[symbol&0377]) == -1) {

			/* assume space if can't find it */

			if ( (i=fontcom.pntr1st[' ']) == -1) {

				/* set if no space */

				*x = 0.0;
				*y = 0.0;
				*visflg = 0;
				return(0);
			}
		}
		pntr = pntcoord+i;
		scale = height/fontcom.height;
	}
	temp = *pntr++;
	
	/* get X coordiante */

	*x = ((temp>>7)&077)*scale;
	if (temp&0020000)*x = (-(*x));

	/* get Y coordinate */

	*y = (temp&077)*scale;
	if (temp&0100)*y = (-(*y));

	/* get visib flag */

	*visflg = (temp&040000)&&01;

	/* check for last coordinate */

	if (temp < 0) {
		pntr = 0;
		return(0);
	}
	return(1);
}

/*  The font file used by 'fontinit' to read  in  the  data  for
	'charfont' has the following format:

short  height     Default character height.
short  size       Bytes of core required to hold coordinates.
short  pnt[256]   Indexes to 1st coordinate of each symbol.
short  crd[size]  Coordinates of symbols

Where each crd[i] has the following format:

  EVSXXXXXXSYYYYYY
  III     IIIIIIII
  III     I   I----- Y coordinate (sign magnitude format)
  IIIIIIIII
  II   I----- X coordinate (sign magnitude format)
  II----- Line segment visible flag (0=invisible, 1=visible)
  I----- 1=more coordinates; 0=last coordinate

*/

fontinit(file)
char  *file;
{
	FILE  *fd;	/* input file desciptor */
	char  *malloc();

	if((fd = fopen(file,"r")) == NULL)
		_err ("unable to open character font file ", file);

	/* assume that structure of font file is correct */
	fread(&fontcom,sizeof(fontcom),1,fd);
	if((pntcoord=(short *) malloc(fontcom.coordsz)) == NULL)
		_err ("can't allocate space for fonts","");
	fread(pntcoord,fontcom.coordsz,1,fd);
	initflg = 1;
	fclose(fd);
}

tint(i)
	int i;
{
	int negative,lo,hi1,hi2;
	negative = 1;
	if(i < 0){
		i = -i;
		negative = 0;
		}
	lo = (i % 16) + 32;
	if(negative)lo += 16;
	i /= 16;
	hi1 = (i % 64) + 64;
	i /= 64;
	hi2 = (i % 64) + 64;
	if(hi2 == 64){
		if(hi1 == 64){
			plotp(lo);
			return;
			}
		plotp(hi1); plotp(lo);
		return;
		}
	plotp(hi2); plotp(hi1); plotp(lo);
}
