/*
	scale_ - F77 version of 'scale'

	The CRC graphics package

	Carl Crawford 
	Purdue University
	West Lafayette, IN 47901

	October 1981

	Didn't call 'scale' because of name conflicts in
	F77's libraries.
*/

#include	"crc.h"

scale_(a,n)
float	*a;
long	int	*n;
{
	float ai,fmax,fmin;
	register int i;

	fmax = fmin = *a;
	for(i=0;i<*n;i++){
		ai=a[i];
		if(ai > fmax) fmax = ai;
		if(ai < fmin) fmin = ai;
	}
	a[*n] = fmin;
	a[1 + *n] = fmax;
}
