/*
	number_ - F77 interface to 'number'

	The CRC graphics package

	Carl Crawford 
	Purdue University
	West Lafayette, IN 47901

	October 1981
*/

#include	"crc.h"
#ifndef vax
#  include	<ctype.h>
#endif /* vax */

number_(x,y,height,angle,format,num,formatl)
float	*x,*y,*height,*angle;
char	*format;
union {
	short	s;
	int	i;
	long	l;
	float	f;
	double	d;
}	*num;
long	int	formatl;
{
#ifdef vax
	number(*x,*y,*height,*angle,format,*num);
#else  /* vax */
/*
 * On machines with big endian byte order we need to know how many bytes
 * num is pointing to, so we scan the format string to figure to this
 * out as best possible.  N.B. This is a kludge!!!
 */
	register char *p;
	int longint;

	longint = 0;
	for (p = format; p < format + formatl; p++) {
		if (*p != '%') {
			continue;
		}
		p++;
		while (*p == '#' || *p == '-' || *p == '+' || *p == ' ') {
			p++;
		}
		while (isdigit(*p)) {
			p++;
		}
		if (*p == '.') {
			p++;
			while (isdigit(*p)) {
				p++;
			}
		}
		if (*p == 'l' || *p == 'L') {
			longint = 1;
			p++;
		}
		if (*p == 'd' || *p == 'D' || *p == 'o' || *p =='O' ||
		    *p == 'x' || *p == 'X' || *p == 'u' || *p =='U' ) {
			if (longint) {
				/* We were passed a FORTRAN INTEGER*4 value */
				number(*x, *y, *height, *angle, format, num->l);
			} else {
				/* We were passed a FORTRAN INTEGER value */
				number(*x, *y, *height, *angle, format, num->i);
			}
			return;
		}
		if (*p == 'f' || *p == 'F' || *p == 'e' || *p =='E' ||
		    *p == 'g' || *p == 'G' ) {
			/* We were passed a FORTRAN REAL or DOUBLE PRECISION
			 * value, assume it was a REAL value. */
			number(*x, *y, *height, *angle, format, num->f);
			return;
		}
	}
	/* scan of format string failed so we'll assume we were passed
	 * a FORTRAN REAL value. */
	number(*x, *y, *height, *angle, format, num->f);
#endif /* vax */
}
