/*
	dline - draw dashed line

	The CRC graphics package

	Carl Crawford 
	Purdue University
	West Lafayette, IN 47901

	October 1981
*/

#include	"crc.h"

dline(x,y,n,dsh,gap,m,lx,ly)
float 	*x,*y,*dsh,*gap,lx,ly;
int	n,m;
{
	float	xn,yn,xn1,yn1,dx,dy,len,lenl;
	float	at,nx,ny,xs,ys;
	int	i,lp,dshgap,sp;

	if(m == 0){
		line(x,y,n,0,lx,ly); 
		return;
	}
	lenl = dsh[0];	
	dshgap = 0;
	sp = 0;
	lp = 0;
	xn = x[n];	
	xn1 = x[n+1];
	yn = y[n];	
	yn1 = y[n+1];
	_schk(xn,xn1);
	_schk(yn,yn1);
	xn1 = lx / (xn1 - xn);
	yn1 = ly / (yn1 - yn);

	plot((x[0]-xn)*xn1,(y[0]-yn)*yn1,3);
	for(i=1;i<n;i++){
		dx = (x[i] - x[i-1]) * xn1;
		dy = (y[i] - y[i-1]) * yn1;
		len = sqrt( (dx*dx) + (dy*dy));
		if(len <= lenl){
			plot((x[i]-xn)*xn1,(y[i]-yn)*yn1,2+dshgap);
			if(sp){
				x[i-1] = xs;
				y[i-1] = ys;
				sp = 0;
			}
			if((lenl -= len) == 0.)
				if(++dshgap == 1){
					lenl = gap[lp];
				}
			else{
				dshgap = 0;
				if(++lp == m)lp =0;
				lenl = dsh[lp];
			}
		}
		else{
			at = atan2(dy,dx);
			nx = cos(at)*lenl;
			ny = sin(at)*lenl;
			plot((x[i-1]-xn)*xn1+nx,(y[i-1]-yn)*yn1+ny,2+dshgap);
			if(++dshgap  == 1){
				lenl = gap[lp];
			}
			else{
				dshgap = 0;
				if(++lp == m) lp = 0;
				lenl = dsh[lp];
			}
			if(sp == 0){
				xs = x[i-1];
				ys = y[i-1];
				sp = 1;
			}
			x[i-1] += (nx/xn1);
			y[i-1] += (ny/yn1);
			i--;
		}
	}
}
