/*
 *	C Example 1 - Compute and plot a sinc(r) function.
 *
 *	Compile with 
 *		cc ex1.c -lm -o ex1
 *
 *	Run with
 *		ex1
 *
 *	Look at the data by typing the command
 *		od -f data
 */

#include	<stdio.h>
#include	<math.h>
#define	N	64

float	z[N][N];

main(){
	int	i, j;
	double	x, y, r;
	FILE	*output;

	output = fopen("data","w");	/* Open the output file */
	if (!output){			/* And make sure the open succeeded */
		fprintf(stderr,"Can't open data file for output.\n");
		exit(1);
	}

	for (i=0;i<N;i++){		/* Increment the x-direction */
		x = i - N/2;
		for (j=0;j<N;j++){	/* Increment the y-direction */
			y = j - N/2;
			r = sqrt(x*x+y*y);
			if ( r < .0001)
				z[i][j] = 1.0;
			else
				z[i][j] = sin(r)/r;
		}
	}

					/* Write the data out in binary
					 * format.
					 */
	fwrite(z,sizeof(z[0][0]),N*N,output);
}
