c
c	Plot3d Fortran Example - Compute and plot a semi-Gaussian function
c
c	Compile with
c		f77 ex.3 -lU77 -o ex3
c
c	Run with
c		ex3
c
c
c				Set the different damping constants
c				of the Gaussian function. 
	sigx1	= 7.0
	sigx2	= 15.0
	sigy	= 5.0
c				Open the z file.
	open(unit=2,file="z",status="unknown",form="formatted")
c				The damping constant is different for 
c				negative and positive values of x while 
c				it is constant along the y axis.
c				Compute the function.
	do 30 j=1 , 32
	    yfact	= exp( - ( abs(j-7.0) / sigy ) ** 2 )
c				Compute the first half of the Gaussian function.
	    do 10 i=1 , 32
		tmp	= exp( - ( abs(i-33.0) / sigx1 ) ** 2 ) * yfact
		write(2,*)tmp
10	    continue
c				Compute the second half of the Gaussian
c				function with a different damping constant.
	    do 20 i=33 , 64
		tmp	= exp( - ( abs(i-33.0) / sigx2 ) ** 2 ) * yfact
		write(2,*)tmp
20	    continue
30	continue
c				Close the z file.
	close(2)
	stop
	end
