This file will contain news about the  graphics  package,  qplot,
gp,  and gplp. It will be updated when a change is made or when a
bug is found.  Information added to this file can also be  mailed
to  you  if  you  mail uid: crc a note indicating that you desire
updates mailed to you.

June 1987
Kent DeLaCroix and Marian Hensler attempted to update the CRC
manual pages in as much as removal of references to Versatec,
ARPA machine and the Tektronix 4010.  Attempted to clean up 
the presentation of the commands to be consistant within the
document.  No effort to correct code or verify options all work.

October 2, 1981
Changed the network interface  so  that  errors  related  to  the
network  are  returned  to  the  user.  This was done by changing
calls to 'ns' from:

        ns host -s command
to:
        ns host -S command  .

October 2, 1981
Cleaned up the code  in  'symbol'.  This  was  done  because  the
original  code  was  written by someone else under version 6 UNIX
and as a result was not portable.

September 25, 1981
Cleaned  up  the  way  the  software  handles   interrupts.    In
particular,  after a call to 'plot(0,0,999)' the interrupt status
is restored to how it was before the call to 'plots'.   When  the
software  detects  an  error,  the daemons (gd, gplp, gd) will be
notified with a SIGTERM.

September 17, 1981
Fixed 'gd' so that the '-b' option  works  with  the  '-G'  flag.
Thus,  over  layed  graphics  images  can  be  obtained  with the
Grinnel.

September 17, 1981
Added code to 'hpd'  so  that  the  plotter  times  out  after  3
minutes.  This  should  correct  the  problem  of  people leaving
programs in the background after hanging up the  plotter.  The  3
minutes  might  have  to  be  increased  if the plotter time outs
during normal plot functions.

September 17, 1981
Added  code  to  HP   driver,   /u/lib/graphics/hpd,   to   catch
interrupts.   After  one  is  caught,  the pen is returned to its
stall.

September 17, 1981
Added '-L' option to Qplot to invert the '-l' flag. The '-L' flag
is  set by default. Also fixed parser so that the '-Gg' and '-Gc'
flag sequences will  generate  outputs  on  the  Comtal  graphics
overlay   #0   and   the   Comtal   image   currently  displayed,
respectively. Also added a reference card in  the  graphics  help
directory.  It is called 'reference' and it contains a summary of
all the commands for Qplot and the  syntaxes  of  the  subroutine
calls.

September 16, 1981
Added documentation files for 'hpd' and 'gd'. They are the driver
programs for the HP plotter and the Comtal/Grinnel, respectively.
The user should notice that the '-mHOST' options  are  useful  in
overriding  the  default  site  of  the  plotter  and the display
devices. The 'options' option in 'plots' or the 'op='  option  in
Qplot  can  be  used to set any of the options for the respective
driver program.

September 16, 1981
It seems that the code installed to catch interrupts  only  works
some  of  the time. It also appears that in order to have it work
all the time would take a large hack  in  the  way  the  graphics
package  does i/o through fake pipes and daemons. Unless there is
big need to have it fixed, it will be left alone.

September 15, 1981
Added code to catch signals in Hp  or  Tektronix  plotting  mode.
After  they  are caught, the terminal is reset as if a normal end
was achieved or the Hp is put to rest.

September 15, 1981
The option "op=str" was  added  to  Qplot.  The  string  will  be
appended  to  the  call to the driver programs Gp, Gplp, Hpd, and
Gd. This provides a method to change any of the options  for  the
respective driver.

September 15, 1981
Added another field to 'plots'.  The  new  call  to  'plots'  is:
plots(dev,blank,str).   The  'str' field is used only if the 0100
bit of dev is set.  Str is appended to the call to  'hpd',  'gp',
'gplp',  and 'gd'.  Thus, this option provides a method to change
any option in the deamon.

September 14, 1981
Added 'dev' 11 to plots. This device supports the  Retro-Graphics
RG-512  graphics  board  for the ADM-3A. Also, the option '-T' is
the Qplot option which will drive this device.

September 14, 1981
Modified /u/lib/graphics/hpd so that  it  supports  the  network.
There  is  now one of these on each machine. The default plotters
are set up in /u/lib/graphics/hpd.site.

September 14, 1981
Internal changes made to 'plots' and 'plot' so  that  the  HP  is
always  driven  through  /u/lib/graphics/hpd and the Tektronix is
written to through a dup'ed standard output port.  These  changes
will  allow  for future expansion of the HP drivers and cleans up
the buffering problem with interactive Tektronix use.

September 13, 1981
Changed Gp so that the default site name is read  from  the  file
/u/lib/graphics/gp.site. All machines send output to the Versatec
on the A machine except for ARPA which sends output  directly  to
the ARPA versatec.

September 13, 1981
Changed Gplp so that the default site name is read from the  file
/u/lib/graphics/gplp.site. The file has the form "-XX<cr>", where
XX is a valid Opr printer name.

September 11, 1981
The HP driver was changed so that it  waits  for  the  last  plot
buffer  to  finish  plotting  before  exits.  this should fix the
problem of the plotter hanging if a large number of graphics jobs
are  set  to it. 'plots' was modified so that it always writes to
/u/lib/hpd instead of  writing  to  the  plotter  directly.  this
change  will lead to a HOST concept in a few weeks. more later on
this.

September 10, 1981
The 'number' subroutine was fixed so that it will now work on the
Vax'es.  It  was  fixed  by  incorporating  the  system  code for
'sprintf' directly into 'number'. The subroutine  now  works  the
same  as 'printf' which means that multiple numbers can be passed
in the call to 'number'. Like:

        number(0.0,0.0,0.5,0.0,"%d = %d",num1,num2);

September 10, 1981
Qplot was changed in the way it generates the x axis for you.  If
you  specify  both  the  'xmin='  and 'xmax=' options, then these
values will appear on the axis. Qplot will not play with the xmax
value so that truncation errors will not occur on the tick marks.
If the '-r' flag is  also  set,  then  the  x  vector  will  have
floating  point  data  in.   Lastly, if the file from 's=file' is
used, then the xmin and xmax values will be used as if they  were
entered in with 'xmax=' and 'xmin='

August 28, 1981
The wrong version of 'gp' was  installed  on  VE  and  VM.   This
prevented  the  Versatec  from  being run across the network. The
correct version of 'gp' is now on the machines.

July 15, 1981
The name conflicts on the Vax due to the interfacing  of  F77  to
the C version of 'scale' have been fixed.

June 29, 1981
Logarithmic axes have been added to QPLOT. The  new  options  are
'logx='  and  'logy='. The valid values are +/-1, +/-2, and +/-3.
Negative values are the same as postive values  except  that  the
logarithm  of  the  respective  data  vector  is taken before the
plotting begins. With value '1' no tic marks are plotted.   Value
'2'  has  a  few  tic  marks  and value '3' has all the tic marks
present.  If QPLOT takes the logarithm for  you,  an  error  will
occur if any of the data is less than or equal to zero.

June 11, 1981
The graphics library /u/lib/libG.a was  changed  to  reflect  the
updating  the  drivers  for  the  HP  plotter  and  the Tektronix
terminals. These changes were necessitated because  the  original
divers,  written  by Peter Hallenbeck, contained code unnecessary
for this graphics package. This excess code was stripped out  and
then  the  new  subroutines were merged into the source files for
the rest of the package. These changes will speed up plotting  on
the  above  mentioned  devices  and reduce the times spent on the
load phase of a graphics compile.

May 11, 1981
The routine 'plots' was changed so that if you are writting to  a
file and the 'blank' flag is non-zero, then the file will be read
into the internal buffer before new plotting is done.  This  will
cause  the new graphics to overlay the contents of the file. As a
result of this change if there is a call to 'fname' it must occur
before the call to 'plots'.

April 30, 1981
Two new options were added to QPLOT. They  are  'tl='  and  'bl='
which respectively put labels at the top and bottom of the graph.

April 17, 1981
Two new options were added to QPLOT. The first is  a  '-l'  flag.
This  option  will  cause  QPLOT  to  prompt the user on standard
output for the axis labels not specified by the 'xl='  and  'yp='
options. The user should enter the label on standard input. It is
terminated by a new-line character. It should be noted that  this
option  used  to  be  in  QPLOT  but  was deleted for a number of
reasons. The main one  was  that  it  would  not  work  with  the
Tektronix.  The problems have been fixed and the option will work
with all the graphics devices.

The second new option is the 'speed=' option.  This  will  invoke
the  '-h'  flag  (plot  on  the  HP  plotter)  and change the pen
velocity to the number specified.  The number can be in the range
from  1  to 36 cm/sec. Where 1 is the slowest speed.  The default
is 36.

April 16, 1981
Many internal changes were made  to  the  subroutines  that  only
drive  the  Tektronix and the HP plotter. These changes reflected
the dropping of the variable 'pstat' from each  subroutine  call.
The  'pstat'  array  has  been  made  to be global after its name
changed to '_pstat'.  This modification will speed plotting times
by about ten percent when using these two devices.

The routine 'alpha' is now fully supported. This subroutine  will
put the HP or Tektronix into an alphanumeric state instead of the
default plot state. This routine is useful  when  user  input  is
required in the middle of a plotting program. The syntax for this
subroutine is:

        FROM F77:
                call alpha

        FROM C:
                alpha()


April 15, 1981
The sources  for  the  graphics  package  have  been  moved  from
/v/crc/src  to /v/crc/graphics. There are sub-directories for the
executable programs (src), the library (lib), the charfont  files
(charfont), and the documentation (doc).

March 12, 1981
Thanks to Pete Loeppert a program has been added  to  change  the
velocity  of  the  pen movement on the HP plotter. The program is
called 'speed'. The syntax is:

        From C:
                int vel

                speed(vel);

        From F77:
                integer vel

                call speed(vel)

Where 'vel' is the velocity in cm/sec. The valid range for  'vel'
is [1,36]. The default value is 36 cm/sec.

March 10, 1981
New flags 'A, B, D, F, M, R, S, X' have been added to Qplot. They
do  the inverse of the flags 'a, b, d, f, m, r, s', respectively.
I. e., '-F' will cause Qplot not to frame the plot. These options
are  useful  in  conjunction  with  the  .qplotrc  file  and  the
QPLOTARGS environment  parameter.   Also  the  options  'digits',
'xdigits',  and  'ydigits'  have been shortened to 'dig', 'xdig',
and 'ydig', respectively. The old options still will work.

March 4, 1981
Qplot was modified so that if 'begin'  is  less  than  zero,  the
value of 'begin' actually used will be obtained by the product of
'count' and the absolute value of 'begin'.

February 27,1981
Several new options have been added to GP. The option  '-a'  will
cause  the  output  to  be generated on the 'alternate' Versatec.
Currenlty there are two Versatecs on the ECN. The  first  one  is
connected  to  the A machine and is physically located in EE 339.
The other one is connected to the ARPA machine and is in EE  179.
The default Versatec is the one connected to the A machine except
for when Gp is run from  the  ARPA  machine  and  then  the  ARPA
Versatec  is  used.   The  option  '-a' will override the default
location and force the output to the 'other'  Versatec.  Gp  will
print  out a message indicating the location of the output unless
the '-s' message is used to surpress the message.  On  ARPA,  the
old  'gp'  and the network version of 'gp' called 'ngp' have been
merged into one  program.   The  new  version  is  almost  upward
compatable  with  the old version.  When running Gp on ARPA, file
names "0", "1", and  "2"  will  be  interpreted  to  mean  Comtal
graphics  overlay  0,  1, and 2, respectively. The old version of
'gp' defaulted to graphics overlay 0 if no files  were  specifed.
In  this  version at least one overlay must be specified. Also in
the old version  muliple  overlays  could  be  printed  if  their
repsective  numbers  were  concatenated into one file name.  This
version wants the device numbers to be seperated  with  at  least
one  space.   Finally,  the  default size on the ARPA Versatec is
2:1. Larger output, 4:1, can be obtained with  the  '-f'  option.
The  '-h'  option,  2:1  scaling,  has  been  included for upward
compatabilty.

February 27,1981
The concept of major and minor device numbers are  introduced  in
this  note.   The graphics package supports many different output
devices. Some devices can have output directed to one of  several
different  display  fields.  This is the case for the Comtal. The
documenation for the initialization subroutine 'plots'  lists  22
different  numbers  for  the  variable 'dev'. The variable can be
broken down into a major device number 'DEV' and a  minor  device
number  'DEVN'.  Dev can be obtained by adding DEV to eight times
DEVN. The current table for DEV is:

DEV     DEVICE
0       File output, Versatec, and Printronix
1       Comtal graphics overlay and Grinnel
2       Comtal image display
3       Tektronix
4       HP plotter

The DEVN field indicates which of the devices indicated  for  DEV
is  selected  or  which  of the Comtal images are used.  Also the
concept of the network is used  in  DEVN.  Some  of  the  devices
assume  that  the  output  unit  is connected locally to the host
machine. If there isn't that specific device on the machine,  the
graphics  program  will  output an error. Through the DEVN field,
one can indicate that an output  device  on  a  specific  network
machine  be  used.  Currenty only the HP and the Comtal use these
options. The table for 'dev' is then given by:

Major and minor device tables

DEV     DEVN    dev     OUTPUT
0       0       0       file or standard output
        1       8       Versatec through gp (I)
        2       16      Printronix through gplp (I) and opr (I)

1       0       1       Comtal graphics overlay 0 on local machine
        1       9       Comtal graphics overlay 1 on local machine
        2       17      Comtal graphics overlay 2 on local machine
        3       25      Grinnel on local machine
        4       33      Comtal graphics overlay 0 on ARPA machine
        5       41      Comtal graphics overlay 1 on ARPA machine
        6       49      Comtal graphics overlay 2 on ARPA machine
        7       57      Grinnel on ARPA machine


2       0       2       Comtal image displayed on local machine
        1       10      Comtal image  0 on local machine
        2       18      Comtal image  1 on local machine
        3       26      Comtal image  2 on local machine
        4       34      Comtal image displayed on ARPA machine
        5       42      Comtal image  0 on ARPA machine
        6       50      Comtal image  1 on ARPA machine
        7       58      Comtal image  2 on ARPA machine

3       0       3       Tektronix through standard output

4       0       4       HP on /dev/plt0 on local machine
        1       12      HP on /dev/plt0 on the A machine

February 27,1981
A bug in the parser in Qplot was fixed. This  bug  prevented  the
setting  of strings (i.e. 'el=' or 'yl=') in the file '.qplotrc'.
In order to fix this bug two limitations were placed on the file.
The first is there can be a maximum of 19 lines in the file.  The
second is that file can only  contain  up  to  approximately  256
characters.   If  these  conditions  prove to be too restrictive,
they will be relaxed.  Also a slight change was made so that if a
'ps'  is  done while Qplot is running, 'qplot' will appear in the
output status and not 'QPLOT'.

February 25,1981
The drivers for the Comtal were stripped out of 'plot' and placed
in  a program called 'gd' (Graphics Display) on the ARPA machine.
This allows for the Comtal to  be  accessable  from  any  network
machine.   In 'plots', the original specifications for 'dev' will
cause the package to assume that  there  is  a  Comtal  connected
locally  to the machine. These are the device numbers that should
be used when running on the ARPA machine. New device numbers  33,
41,  and  49  are the same as 1, 9, and 17 except that the Comtal
graphic overlays on the ARPA machine are used regardless  of  the
host  machine.   The  analogous numbers for the Comtal images are
34,  42,  50,  and  58  corresponding  to  2,  10,  18,  and  26,
respectively.  The  Grinnel  on  the ARPA machine can be accessed
with 'dev' set to 25 if ARPA is the host machine or  57  for  any
other machine.

February 19,1981
The parse routines internal to QPLOT were changed  to  allow  for
default  mechanisms  for  option  input.  The  changes should not
affect existing shell files that use QPLOT.  There  are  two  new
ways  to set options. The first is to create a file '.qplotrc' in
your HOME directory (see environ (5)).   In  it,  one  can  place
options  and  flags  that  QPLOT  will  use before it parses your
command line.  The syntax is one command or flag string per line.
As  an example, consider the case where the user wishes to always
obtain output on the Versatec and the plot be  framed.  Also  the
length  of  the  axes are desired to be 6 units and the number of
digits in the axes anotation set to 4.  The  correct  format  for
the file '.qplotrc' will be:

-vf
len=6
digits=4

The second way to change the options is to set the shell variable
'QPLOTARGS'  to  a  string  containing options in the same format
that you would enter  them  on  a  command  line.   The  variable
'QPLOTARGS'  must  be  exported  with:  'export  QPLOTARGS'.  The
options set in  the  previous  example  can  be  set  using  this
procedure as follows.

        $QPLOTARGS='-vf len=6 digits=4'
        $export QPLOTARGS

The single quotes are needed to  tell  the  shell  that  all  the
options  belong  to one string. If you need to set up labels with
the 'xl=', 'yl=',  or  'el='  options,  surround  the  respective
option with double quotes. An example:

        $QPLOTARGS='-vf "xl=this is the x axis label"'

There is no way to get a double quote into the label field.

Qplot will parse the file '.qplotrc' first if it exists. Then  it
will  parse  'QPLOTARGS' if it exists.  Finally, QPLOT will parse
the command line.

January 7, 1981
The bug that precluded writing out to standard output  after  the
call  to  'plots' has been fixed. It is still illegal to write to
standard output if 'fname("-") is used.

January 5, 1981
Two new devices were added to 'plots'. Device numbers  8  and  16
will respectively write directly to the Versatec on the A machine
through gp and to the default  line  printer  through  gplp.  The
default  line printer can be changed by using 'site("-XX")' or in
F77 'call site("-XX")' before the call to  plots.  The  field  XX
indicates  a valid printer as specified by opr (I).

January 5, 1981
The '-l' flag has been deleted from qplot. Use the  xl=  and  yl=
options instead.

January 4, 1981
The HP plotter can now be run across the  network.  When  calling
the subroutine 'plots', setting DEV=4 will indicate that there is
a plotter connected to /dev/plt0. DEV=12  will  run  the  plotter
connected  to  /dev/plt0  on  the A machine. Qplot was changed so
that  hosts  without  plotters  (VE,  VM,  ARPA,  B,   FU)   will
automatically run on A's plotter.

The default output device for ARPA when using qplot  was  changed
back to gov0.

January 3, 1981
Many changes to qplot were made so that it will run on  the  Vax.
Not all the changes were upward compatable. Most of these reflect
vast improvements for qplot. The changes are:

The option -p was changed to indicate that the output go directly
to  the  line printer. This is now the default output device. The
default printer site can be changed with site=XX, where XX  is  a
valid  id for a printronix printer. See opr for more information.
The -p option can still be used with the 'g=file' option.

A -v option was added  to  tell  qplot  to  output  the  graphics
directly to the Versatec on the A machine.

The dash and gap lengths for a dashed lines can be changed  using
the  'dash=' and 'gap=' options. The default for each is .1. Both
options invoke the -d flag.

The scale  file  format  was  changed  to  a  single  ascii  line
containing four numbers. The order being: xmin xmax ymin ymax.

Finally, the byte declaration field was changed. This change  was
necessary  because  the  old names reflected the size of the data
types in bytes and not the type of data.  The new names reflect C
notation.   The  current  byte  declarations  are  (the  item  in
parenthesis is the old declaration that still will work):

c       unsigned 'char'. (1)
cs      signed 'char'. (1s)
s       short 'int'. (did not exist)
i       'int'. (2)
l       'long int'. (l)
f       'float'. (4)
d       'double'. (8)

December 12, 1980
The HP plotter initializer program was changed so that it doesn't
use  raw  mode.  This should correct the problem of buffers being
lost when the system is loaded.

November 6, 1980
The scaling routines for the Hp plotter were fixed so that the  x
and y dimensions are equal.

November 1, 1980
A bug in 'qplot' was fixed so  that  now  the  'el'  and  'scfac'
options can be used together.

October 1, 1980
Gplp was modified so that it will print only up to the  last  non
empty plot character. This should speed things up a great deal.

September 18, 1980
Gp was fixed to reflect the relocation of the Versatec from the B
to the A machine.

September 3, 1980
A slight modification was made to 'plot' to speed up  the  vector
drawing capabilities in the 'bit map' mode. The change should not
cause any troubles. The routine 'axis' was  changed  so  that  if
'ticdis'  is  zero  an error message will be printed and plotting
terminated.  Also a bug in 'qplot' was  fixed.  This  fix  allows
'xtic'  or  'ytic'  to  be  changed  and  allow correctly for the
integer truncation in the axes annotations.

September 2, 1980
Some people have indicated that they have trouble when trying  to
get  user  input  when  in the 'Tektronix graphics mode'. This is
because once  plotting  has  started  the  device  remains  in  a
graphics  mode.  When  the user is prompted for input, the echoed
characters are interpreted to be  graphics  information  and  not
alphanumeric  information.   There  are  two  ways  to avoid this
problem.  The first method is just  to  obtain  user  information
before  the call to 'plots' is made. The second method is to call
the yet undocumented program 'alpha' to enter alphanumeric  mode.
The  graphic  mode  will be reentered automatically with the next
graphics subroutine call.

July 24,1980
Gplp now works from every network machine.  The  Printronix  line
printer used is dependent on the machine gplp is run on.

May 28,1980
Axis has been slightly  modified  in  the  way  it  apppends  the
exponent  to  the label if there is one. The 'x' has been changed
to a 'X'. The extra space after the exponent is  removed  if  the
exponent  is  less  than 10. The exponent is placed in the string
using the ${ and $} operations so that the  whole  label  can  be
repositioned  with  a  series of ${'s or $['s at the beginning of
the label. Soon the digits variable will reflect into  the  label
postion for the y axis label.

May 16, 1980
Some new options for qplot have been added.  The  options  "xtic"
and  "ytic"  will change the distance between tic marks for the x
and y axis, respectively. The default value for each is 1.0.  The
option  "tic"  will change both the "xtic" and the "ytic" values.
The "len" option changes both the "xlen" and "ylen"  values.  The
number  of  significant  digits for the x axis and the y axis can
now be changed independently with  the  "xdigits"  and  "ydigits"
options.  Online  symbols  are available using the '-m' flag. The
symbol can be changed using the "sym" option. The  default  value
is  four.  Every  j'th point will have an online symbol using the
"j" option. The default value is one. If j is negative, then only
the  symbols  will  be plotted without the interconnecting lines.
The "j" and  "sym"  options  will  invoke  the  '-m'  flag.  More
information on online symbols can be obtained by using:

        help graphics/sline 3

The dash line option was changed so that the same pattern appears
on  the  Hp  and  Tek  as  in an internal file plot. The dash gap
sequence was slightly modified.

April 17, 1980
The fix for  the  bum  malloc  in  F77's  library  caused  double
defintions  for  the linker. The system malloc was fixed so there
is no need for the extra copy  of  malloc  in  libG.   Everything
seems to be okay now.

April 16, 1980
There was a bug in the f77 library's version of malloc.  For  now
there  is  a  copy  of the C malloc in the graphics library. Also
'plots' was corrected to reflect the correct  error  status  from
malloc.  These changes should allow the graphics package to print
out a message when it can't allocate buffers it needs.

April 16, 1980
The 'where' subroutine was corrected  so  that  it  reflects  the
description  in  the  documentaion. In the past if the origin was
reset, 'where' did not return the correct pen location.

April 15, 1980:
Fname was changed so that if the file name is "-", then the final
graphics  will  be  written  out  to the standard output. This is
useful for piping the output into 'gp -i' or 'gplp -i'.   Also  a
slight  bug  was  found in 'fname'. Fname only keeps a pointer to
the file name, not a copy of the complete string. If the name  is
on  the  stack  when  fname  is called, then the file opened when
'plot(0.,0.,999)' is called will not have the same name.

April 15, 1980:
A bug was found in the  c_lib  routine  'malloc'  that  allocates
space.  If the 'dev' is less than or equal to two when 'plots' is
called, and the program is  too  big,  a  'memory  fault  -  core
dumped' message will occur. Reduce the amount of arrays that your
program uses and make sure that the '-i' flag is  used  when  the
program  is  compiled.   Use the routine 'size' to make sure that
your 'data' + 'bss' sizes are less than about 30K before you  run
the program. Soon an error message will tell you that the program
is too big. It is in there but the malloc bug precludes  the  use
of it for now.

April 15, 1980:
Qplot has some new features added to it:
1. A '-o' option has been added. This is the  same  as  the  '-p'
option  except  that  the  graphics  output is written out to the
standard output.
2. The number of significant digits used in the axis  annotations
can be changed using the 'digits=n' option.
3. The '-f' option will draw a frame around the plot.
4. The 'x=file,n" option will now invoke the '-x' option for you.
5. The length of the axis's can be changed using the 'xlen=r' and
the 'ylen=r' options.
6. Long integers can be entered as a possible byte type by  using
the byte declaration ',l'.
7. A '-r' flag will force a real internally generated x vector if
the 'xmin=' and 'xmax=' options are used.

April 11, 1980:
The 'axis' subroutine was changed so  that  a  minus  sign  isn't
considered to be a significant digit.
