/*
 * Data dictionary creator for VF by Richard Conn 
 *
 * Note: This requires the relation VFDDSORTED to be present in the
 * database XANADU. 
 *
 */
#include <stdio.h>

main()
{
## ingres xanadu

    display("Command-Line Defined Symbols", 'D');
    display("Constants", 'C');
    display("Variables", 'V');
    display("Structures", 'S');
    display("Functions", 'F');

## exit
}

/* Display Routine */
display(title, ch)
    char           *title;
    char            ch;
{
    /* Local Variables */
    int             i;
    char           *rover;

    /* Structure of relation records */
##    char            Citem[20+1];
##    char            Cdesc[80+1];
##    char            Ctype[1+1];
##    char            Cupdate[1+1];
##    char            Cvartype[20+1];
##    char            Cvarrange[20+1];

    printf("\n\n\n");
    for (i = 0; i < strlen(title) + 10; i++)
	printf("*");
    printf("\n**** %s ****\n", title);
    for (i = 0; i < strlen(title) + 10; i++)
	printf("*");
    printf("\n\n");
## retrieve (Citem=vfddsorted.item, Cdesc=vfddsorted.desc,
## Ctype=vfddsorted.type, Cupdate=vfddsorted.update,
## Cvartype=vfddsorted.vartype, Cvarrange=vfddsorted.varrange)
## {
    if (*Ctype == ch) {
	rover = &Cdesc[80];
	while (*rover <= ' ')
	    rover--;
	rover++;
	*rover = '\0';
	printf("%20s %s\n", Citem, Cdesc);
	switch (*Ctype) {
	case 'S':
	case 'V':
	    if (*Cupdate == 'V')
		printf("  ** Set from VFRC File **\n");
	    break;
	case 'F':
	    if (*Cupdate == 'Y')
		printf("  ** Changes Screen Display **\n");
	    break;
	default:
	    break;
	}
	if (*Ctype == 'V') {
	    printf("  Type: %-20s   ", Cvartype);
	    if (*Cvarrange > ' ')
		printf("Range: %s\n", Cvarrange);
	    else
		printf("\n");
	}
    }
## }
}
