.TH TRIMLOG 8 RIACS "9 May 1989"
.SH NAME
trimlog \- trim system log files
.SH SYNOPSIS
trimlog
.SH DESCRIPTION
.PP
.I Trimlog
is used to trim system log files to keep them from growing without bound.
When invoked,
it reads commands from the file
.I %CONFIG%
which tell it which files to trim,
how to trim them,
and by how much they should be trimmed.
.PP
The
.I %CONFIG%
file may contain any of the following commands:
.IP "\fBtruncate\fP \fIfilename\fP \fIn\fP"
Truncate the named file to a length of no more than
.I n
bytes.
This has the effect of removing all but the first
.I n
bytes of the file.
This command is useful for zeroing log files.
.IP "\fBtrimbylines\fP \fIfilename\fP \fIn\fP"
Trim the named file to a length of no more than
.I n
lines.
The last
.I n
lines will be copied to the front of the file,
and the rest of the file truncated.
This command is useful for deleting old entries from textual log files
such as those maintained by
.IR syslog (8).
.IP "\fBtrimbybytes\fP \fIfilename\fP \fIn\fP"
Trim the named file to a length of no more than
.I n
bytes.
The last
.I n
bytes will be copied to the front of the file,
and the rest of the file truncated.
This command is useful for deleting old entries from binary log files
such as
.IR /usr/adm/wtmp .
.PP
Lines which begin with a sharp sign (`#') in the log file are treated
as comments.
.SH BUGS
.PP
Trimming log files of some commands while they are running may result in
``holes'' being left in the log file.
There is no provision to signal the commands to close their log files
and reopen them.
.SH AUTHOR
David A. Curry, Research Institute for Advanced Computer Science
