/* Program for manipulating property lists, maintained as headers for a file */

/* Usage:
 *	getprop [options] file property
 *	remprop [options] file property
 *	putprop [options] file property value
 */

#include <stdio.h>

#include "prop.h"

char *name;

usage()
{
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "\tgetprop [options] file property\n");
	fprintf(stderr, "\tremprop [options] file property\n");
	fprintf(stderr, "\tputprop [options] file property value\n");
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "\t-Tc\tTag character is 'c' (default ':').\n");
	fprintf(stderr, "\t-a\tExtract all matching entries.\n");
	fprintf(stderr, "\t-r\tRFC style (default) (sets default tag to ':').\n");
	fprintf(stderr, "\t-m\tMAKE style (sets default tag to '=').\n");
	fprintf(stderr, "\t-s\t/bin/sh style (sets default tag to '=').\n");
}

args(ac, av, n)
int ac;
char **av;
int n;
{
	if(ac!=n)
	{
		fprintf(stderr, "%s: Argument count.\n", name);
		usage();
		exit(ERROR);
	}
}

main(ac, av)
int ac;
char **av;
{
	char *strrchr();
	int flag;
	char buffer[BUFSIZ];

	if(name = strrchr(av[0], '/'))
		name++;
	else
		name = av[0];

	while(av[1][0] == '-') {
		av++;
		ac--;
		while(*++*av) {
			switch(**av) {
				case 'T':
					TagChar = *++*av;
					if(!TagChar) {
						fprintf(stderr, "%s: Missing tag character\n", name);
						usage();
						exit(2);
					}
					break;
				case 'a':
					Flags |= ALLFLAG;
					break;
				case 'm':
					DefaultTag = '=';
					Style = MAKEFILE;
					break;
				case 'r':
					DefaultTag = ':';
					Style = RFC;
					break;
				case 's':
					DefaultTag = '=';
					Style = BINSH;
					break;
				default:
					fprintf(stderr, "%s: Unknown option -%c\n", name, **av);
					usage();
					exit(2);
			}
		}
	}

	switch(name[0])
	{
		default:
		case 'g': 
			args(ac, av, 3); 
			if(flag = getprop(av[1], av[2], buffer) == SUCCESS)
				puts(buffer);
			return flag;
		case 'r': 
			args(ac, av, 3); 
			return remprop(av[1], av[2]); 
		case 'p': 
			args(ac, av, 4); 
			return putprop(av[1], av[2], av[3]); 
	}
}
