.\" to produce the man page.
.\" troff -man -Tdumb cpr.tf | ddumb >cpr.p
.\"
.TH PROP 3
.SH "NAME"
prop  \-  Manipulate property-list-style file headers
.SH "SYNOPSIS"
#include "prop.h"

.B getprop(
file, property, buffer
.B );
.br
.B putprop(
file, property, value
.B );
.br
.B remprop(
file, property
.B );
.SH "DESCRIPTION"
The
.B prop
suite of routines manipulate the header of a file. The header is defined
similarly to a mail header in \fIRFC822\fR: a block of name-value pairs
followed by a blank line.
The remainder of the file can be anything, and is maintained intact by the
.B prop
routines.
.PP
The format of the name-value pairs is fairly flexible. By default, these
programs will recognise either a colon or an equal-sign to terminate the
name. The value may be quoted using \fIRFC-822, Makefile\fR, or \fI/bin/sh\fR
conventions.
.PP
.I RFC-822
properties are of the form \fB"Name: value"\fR, with continuation
lines indented.
.I Makefile
properties are of the form \fB"NAME= value"\fR, with
continued lines escaped by a backslash.
.I /bin/sh
properties are of the
form \fB"name='value'"\fR, with newlines embedded in the quoted string.
.SH "ROUTINES"
.B putprop
is used to create a proplist file, and add name-value pairs to it. If any
name already exists, \fBputprop\fR will override it.
.PP
.B getprop
will return one or more properties from the file.
.PP
.B remprop
will delete properties from the file.
.SH "EXTERNAL VARIABLES"
.IP \fBFlags\fR
A bit-map containing various flags. Currently only
.B ALLFLAG
is defined.  If
.B (Flags&ALLFLAG)
is true, then
.B getprop
will put all properties with the right name in the
buffer.
.IP \fBStyle\fR
A byte containing the style to use for the proplist: \fBRFC\fR for
.I RFC822
style,
.B BINSH
for
.I /bin/sh
style, or
.B MAKEFILE
for
.I Makefile
style.
.IP \fBDefaultTag\fR
A byte containing the character to use to flag a variable, used by
.B putprop
for creating a proplist the first time. Initialised to \fB':'\fR, and should be
changed to \fB'='\fR if you use
.B BINSH
or
.B MAKEFILE
mode.
.IP \fBTagChar\fR
A byte containing the character to use to flag a variable, used by all
routines. This should normally be
.I NULL.
.SH "SEE ALSO"
.B prop (1)
.SH "AUTHOR"
.IP "Peter da Silva" 2.0i
original, Hackercorp
.SH SUPPORT
This software is
.I not
supported.
.PP
Send comments or improvements to
.B peter@sugar.hackercorp.com
