.TH PROP 1
.SH "NAME"
prop  \-  Manipulate property-list-style file headers
.SH "SYNOPSIS"
.B getprop
[-rms] [-a] [-Tx]
file property
.br
.B putprop 
[-rms] [-Tx]
file property value
.br
.B remprop 
[-rms] [-Tx]
file property value
.SH "DESCRIPTION"
The
.B prop
suite of programs manipulate the header of a file. The header is defined
similarly to a mail header in
.I RFC822:
a block of name-value pairs
followed by a blank line.
The remainder of the file can be anything, and is maintained intact by the
.B prop
programs.
.PP
The format of the name-value pairs is fairly flexible. By default, these
programs will recognise either a colon or an equal-sign to terminate the
name. The value may be quoted using
.I RFC-822, Makefile,
or
.I /bin/sh
conventions.
.PP
.I RFC-822
properties are of the form \fB"Name: value"\fR, with continuation
lines indented.
.I Makefile
properties are of the form \fB"NAME= value"\fR, with
continued lines escaped by a backslash. \fI/bin/sh\fR properties are of the
form \fB"name='value'"\fR, with newlines embedded in the quoted string.
.SH "COMMANDS"
.B putprop
is used to create a proplist file, and add name-value pairs to it. If the
name already exists, putprop will override it.
.PP
.B getprop
will return one or more properties from the file.
.PP
.B remprop
will delete properties from the file.
.SH "OPTIONS"
.IP \fB-r\fR
Use \fIRFC822\fR style properties (default).
.IP \fB-s\fR
Use \fI/bin/sh\fR style properties.
.IP \fB-m\fR
Use \fIMakefile\fR style properties.
.IP \fB-a\fR
(getprop only)
Display all properties for this name. \fBputprop\fR will not create such
a condition, but they are possible in \fIRFC822\fR... for example, the
\fB"Received:"\fR header entry.
.IP \fB-T\fIc\fR
Set the tag character to \fIc\fR.
By default, this is either \fB=\fR or \fB:\fR, depending
on which is first recognised in the file.
.SH "EXAMPLES"
In an automatically configured makefile, you could update the
configuration with \fBputprop -m Makefile SHELL /bin/sh.\fR
.PP
To update a shell script,
try \fBputprop -s ~/.profile ORGANIZATION "$ORGANIZATION"\fR.
.SH "SEE ALSO"
.B prop (3)
.SH "AUTHOR"
.IP "Peter da Silva" 2.0i
original, Hackercorp
.SH SUPPORT
This software is
.I not
supported.
.PP
Send comments or improvements to \fBpeter@sugar.hackercorp.com\fR
