/* LINTLIBRARY */

#ifndef lint
static char *RCSid = "$Header: unenv.c,v 1.1 1988-02-29 00:41:23 sten Exp $";
#endif

/*
 * $Log:	unenv.c,v $
 * 
 * Revision 1.1  1988-02-29  00:41:23  sten
 * Initial revision
 * 
 * Revision 1.1  1986-10-20  16:51:22  sten
 * Initial revisi
 */

#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#define Strcpy (void) strcpy
#define Strcat (void) strcat

/****************************************\
* 					 *
*  untilde: perform tilde substitution.	 *
* 					 *
\****************************************/

untilde(out, in)
char *out, *in;
{
    if (in[0] != '~')
    {
	Strcpy(out, in);
	return (0);
    }
    if (isalnum(in[1]))
    {
	char            user[80];
	struct passwd  *pw, *getpwnam();
	char           *p, *pu;

	p = in + 1;
	pu = user;
	while (isalnum(*p) || *p == '-')
	    *pu++ = *p++;
	*pu = '\0';
	if ((pw = getpwnam(user)) == NULL)
	    return (1);
	Strcpy(out, pw->pw_dir);
	Strcat(out, p);
    } else
    {
	char           *p;

	if ((p = (char *) getenv("HOME")) == (char *) NULL)
	    return (1);
	Strcpy(out, p);
	Strcat(out, in + 1);
    }
    return (0);
}

/*******************************************\
* 					    *
*  unenv: perform environment substitution  *
* 					    *
\*******************************************/

unenv(out, in)
char *out, *in;
{
    while (*in != '\0')
    {
	if (*in != '$')
	    *out++ = *in++;
	else
	{
	    char            envar[80];
	    char           *p;

	    in++;
	    for (p = envar; isalnum(*in);)
		*p++ = *in++;
	    *p = '\0';
	    if ((p = (char *) getenv(envar)) == (char *) NULL)
		return (1);
	    Strcpy(out, p);
	    out += strlen(out);
	}
    }
    *out = '\0';
    return (0);
}
