#ifndef lint
static char *RCSid = "$Header: inelim.c,v 1.5 1988-02-29 00:39:38 sten Exp $";
#endif

/*****************************************************************************\
* 									      *
*  NAME									      *
*    inelim - eliminate include statements				      *
* 									      *
*  SYNOPSIS								      *
*    inelim [-v] [-p pattern] [files]					      *
* 									      *
*  DESCRIPTION								      *
*    inelim eliminate include statements by substituting the line with the    *
*    include statement with the contents of then file to be included. The     *
*    result is written to stdout. The -v option prints file namn and line     *
*    number at the beginning of each line. The -p option allows you to	      *
*    specify an alternative pattern instead of the standard 'include'. If no  *
*    files are given, stdin is taken. Tilde and environment substitution is   *
*    performed on each include file name. If the expanded file name doesn't   *
*    begin with a '/', the directory in which we are reading from at the      *
*    moment is prefixed. If the first character in the file name is '|', the  *
*    rest is fed to "/bin/sh" and data from stdout replaces the include	      *
*    line.								      *
* 									      *
*  AUTHOR								      *
*    sten@enea								      *
* 									      *
\*****************************************************************************/

/*
 * $Log:	inelim.c,v $
 * 
 * Revision 1.5  1988-02-29  00:39:38  sten
 * before public release
 * 
 * Revision 1.4  1988-02-23  14:54:58  sten
 * incelim => inelim
 * 
 * Revision 1.3  1987-03-02  00:41:42  sten
 * inclusion of command stdout.
 * 
 * Revision 1.2  1986-10-20  16:40:57  sten
 * released to the Inner Circle
 * 
 * Revision 1.1  1986-10-05  23:09:39  sten
 * Initial revision
 */

#include <stdio.h>
#include <ctype.h>
#include <assert.h>

#ifdef BSD
#include <sys/param.h>
#endif
#ifdef V7
#define MAXPATHLEN 256
#endif
#ifdef SYSV
#include <limits.h>
#define MAXPATHLEN PATH_MAX
#endif

#ifdef SYSV
#define rindex strrchr
#endif

#define LLEN 256

extern char *strcat();
extern char *strcpy();
extern FILE *popen();
extern int rindex();
extern void exit();

#define Strcpy (void) strcpy
#define Strcat (void) strcat

#define INCLUDE "include"

char *progname;
int verbose = 0;
char *pattern = INCLUDE;

/******************************************************************\
* 								   *
*  pipefile: read the file given as parameter and invoke pipefile  *
*    recursively on detected include files.			   *
* 								   *
\******************************************************************/
static void
pipefile(cfd, cwd, cfn)
FILE *cfd;
char *cwd, *cfn;
{
    int             lcnt = 0;
    char            iwd[MAXPATHLEN];
    char            line[LLEN];

    while (fgets(line, LLEN - 1, cfd) != 0)
    {
	lcnt++;
	if (strncmp(line, pattern, strlen(pattern)) != 0)
	{
	    if (verbose)
		fprintf(stdout, "%s/%s, line %d: ", cwd, cfn, lcnt);
	    fputs(line, stdout);
	} else
	{
	    FILE           *ifd;
	    char           *ifn, *p;
	    char            path[MAXPATHLEN];
	    char            ppath[MAXPATHLEN];

	    for (p = line + strlen(pattern); isspace(*p); p++);
	    if (untilde(ppath, p) != 0)
	    {
		fprintf(stderr, "%s/%s, line %d: %s: %s\n",
			cwd, cfn, lcnt, progname, "Cannot untilde");
		exit(1);
	    }
	    if (ppath[0] == '|')
	    {
		ppath[strlen(ppath) - 1] = '\0';
		for (p = ppath + 1; isspace(*p); p++);
		if ((ifd = popen(p, "r")) == (FILE *) NULL)
		{
		    fprintf(stderr, "%s: Cannot popen %s\n", progname, ppath);
		    exit(1);
		}
		pipefile(ifd, cwd, ppath);
		(void) pclose(ifd);
	    } else
	    {
		if ((unenv(path, ppath)) != 0)
		{
		    fprintf(stderr, "%s/%s, line %d: %s: %s\n",
			    cwd, cfn, lcnt, progname, "Cannot unenv");
		    exit(1);
		}
		if (path[0] == '/')
		    Strcpy(iwd, path);
		else
		{
		    Strcpy(iwd, cwd);
		    Strcat(iwd, "/");
		    Strcat(iwd, path);
		}
		iwd[strlen(iwd) - 1] = '\0';
		if ((ifd = fopen(iwd, "r")) == (FILE *) NULL)
		{
		    fprintf(stderr, "%s: Cannot open %s\n", progname, iwd);
		    exit(1);
		}
		ifn = (char *) rindex(iwd, '/');
		*ifn++ = '\0';
		pipefile(ifd, iwd, ifn);
		(void) fclose(ifd);
	    }
	}
    }
}

#ifdef V7
/**********************************************\
* 					       *
* mygetwd retrieves current working directory  *
* 					       *
\**********************************************/
static void
mygetwd(to)
char *to;
{
    FILE *pwdfd;
    char *i;

    pwdfd = popen ("/bin/pwd\n");
    assert (pwdfd != NULL);
    i = fgets (to, MAXPATHLEN, pwdfd);
    assert (i != NULL);
    pclose (pwdfd);
    to[strlen (to) - 1] = '\0';
}
#endif
/*****************************************\
* 					  *
*  usage: display correct usage and exit  *
* 					  *
\*****************************************/
static void
usage()
{
    fprintf(stderr, "Usage: %s [-v] [-p pattern] [files]\n", progname);
    exit(1);
}

void
main (argc, argv)
int	argc;
char	*argv[];
{
    char            sw;
    extern int      optind;
    extern char    *optarg;
    char            dir[MAXPATHLEN];

    if ((progname = (char *)rindex(argv[0], '/')) == 0)
	progname = argv[0];
    while ((sw = getopt(argc, argv, "vp:")) != (char) EOF)
	switch (sw)
	{
	case 'v':
	    verbose++;
	    break;
	case 'p':
	    pattern = optarg;
	    break;
	case '?':
	    usage();
	    break;
	}
#ifdef BSD
    (void) getwd(dir);
#endif
#ifdef V7
    mygetwd(dir);
#endif
#ifdef SYSV
    (void) getcwd(dir, MAXPATHLEN);
#endif
    if (optind == argc)
	pipefile(stdin, dir, "");
    else
	for (; optind < argc; optind++)
	{
	    FILE           *fd;
	    char           *file;
	    char            path[MAXPATHLEN];
	    char            ppath[MAXPATHLEN];

	    if (strcmp(argv[optind], "-") == 0)
		pipefile(stdin, dir, "");
	    else
	    {
		if (untilde(ppath, argv[optind]) != 0)
		{
		    fprintf(stderr, "%s: %s: %s\n",
			    progname, "Cannot untilde", argv[optind]);
		    exit(1);
		}
		if ((unenv(path, ppath)) != 0)
		{
		    fprintf(stderr, "%s: %s: %s\n",
			    progname, "Cannot unenv", argv[optind]);
		    exit(1);
		}
		if (path[0] == '/')
		    Strcpy(dir, path);
		else
		{
		    if (dir[strlen(dir) - 1] != '/')
			Strcat(dir, "/");
		    Strcat(dir, path);
		}
		if ((fd = fopen(dir, "r")) == (FILE *) NULL)
		{
		    fprintf(stderr, "%s: Cannot open %s\n", progname, dir);
		    exit(1);
		}
		file = (char *) rindex(dir, '/');
		*file++ = '\0';
		pipefile(fd, dir, file);
		(void) fclose(fd);
	    }
	}
    exit(0);
    /* NOTREACHED */
}
