
/*
**
**	Copyright (c) 1988, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

#include <stdio.h>
#include "config.h"

char *strtok();

an_read()
{
	char buf[BUFSIZ+1];
	int incflag;
	char code;
	int fcount;
	char *dstr;

	fcount = incflag = 0;
	dstr = " \t\"\n";
	while (fgets(buf,BUFSIZ,stdin) != NULL)
	{
		if (buf[0] != '@')
			continue;
		code = buf[1];
		if (incflag)
		{
			switch(code)
			{
			case '<':
				fatal("nested @<");
			case '>':
				incflag = 0;
			default:
				break;
			}
			continue;
		}
		switch(code)
		{
		case '=':
			++fcount;
			rat_file(strtok(buf+2,dstr));
			break;
		case '!':
			if (fcount <= 0)
				fatal("definition with no file");
			rat_def_enter(strtok(buf+2,dstr));
			break;
		case '?':
			if (fcount <= 0)
				fatal("reference with no file");
			rat_ref_enter(strtok(buf+2,dstr));
			break;
		case '<':
			incflag = 1;
			break;
		case '>':
			fatal("unmatched @>");
		default:
			fatal("bad line - @%c",code);
		}
	}

	if (incflag)
		fatal("unclosed @<");
}
