#define REF 1
#define DEF 2
#define FNAME 3
#define DEP 4
#define DDEF 5
#define UDEF 6
#define CYCLE 7
#define FORGET 8

#define MAXTYPE 8	/* maximum of above node types */

typedef struct
{
	char *name;
	int type;
} KEY;

typedef struct _nd_s
{
	struct _nd_s *next;
	KEY key;
	union
	{
		struct _nd_s *file;	/* file for DEF, DDEF, REF, UREF */
		char *cycle;
		struct
		{
			struct _nd_s *dep;	/* FNAME dependency list */
			int refcount;		/* refcount for use in sort */
			int mark;		/* mark for DFS's */
		} fname;
		struct
		{
			struct _nd_s *dfile;	/* defining file */
			struct _nd_s *rfile;	/* referring file */
			struct _nd_s *next;	/* next list element */
			char *sym;		/* symbol causing dependency */
			int erase;		/* erase edge (cyclic) */
		} dep;
		struct
		{
			char *files;	/* up to MAXCATFILE */
			int count;	/* actual number of files */
		} ud;
	} d;
} NODE;
