
/*
**
**	Copyright (c) 1988, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

#include <stdio.h>
#include "node.h"

extern int Verbosity;

NODE *
rat_list_sort(list)
NODE *list;
{
	register NODE *ptr;
	register int elt,i;
	NODE **arr;
	char *malloc();
	int compar();

	if (list == NULL)
		return(NULL);

	elt = 0;
	for (ptr = list; ptr != NULL; ptr = ptr->next)
		++elt;

	if (Verbosity > 3)
	{
		fprintf(stderr,"Original order:\n");
		for (ptr = list; ptr != NULL; ptr = ptr->next)
			fprintf(stderr,"	%s\n",ptr->key.name);
	}

	if ((arr = (NODE **) malloc(elt * sizeof(NODE *))) == NULL)
		fatal("Can't alloc array for sorting");

	i = 0;
	for (ptr = list; ptr != NULL; ptr = ptr->next)
	{
		arr[i] = ptr;
		++i;
	}

	qsort((char *) arr,elt,sizeof(NODE *),compar);

	--elt;
	for (list=ptr=arr[i=0]; i < elt; ++i) 
	{
		ptr->next = arr[i+1];
		ptr = ptr->next;
	}
	ptr->next = NULL;

	free((char *) arr);

	if (Verbosity > 3)
	{
		fprintf(stderr,"End order:\n");
		for (ptr = list; ptr != NULL; ptr = ptr->next)
			fprintf(stderr,"	%s\n",ptr->key.name);
	}

	return(list);
}

static
compar(s1,s2)
register char *s1;
register char *s2;
{
	return (strcmp((*((NODE **)s1))->key.name,(*((NODE **)s2))->key.name));
}
