
/*
**
**	Copyright (c) 1988, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

#include <stdio.h>
#include <sys/param.h>
#include "config.h"

/*
** localnames.h is generated by the makefile before compiling, and
** moved to lastnames.h afterwards.
*/
#include "localnames.h"

main(argc,argv)
int argc;
char **argv;
{
	char pipe[3*MAXPATHLEN+MAXCMDLEN+120];
	char *cpp,cppopt[MAXCMDLEN];
	char *p,popt[MAXCMDLEN];
	char *a,aopt[MAXCMDLEN];
	int verbosity;
	int xflag;

	aopt[0] = cppopt[0] = popt[0] = '\0';
	cpp = cppopt;
	p = popt;
	a = aopt;
	xflag = 0;

	/*
	** Note that we preserve the order of the files & parser options
	** It is legal in the parser to turn options on and off between
	** files.
	*/
	verbosity = 0;
	for (++argv; argc > 1; --argc,++argv)
	{
		if (**argv == '-')
		{
			switch(*(*argv+1))
			{
			case 's':
			case 'z':
			case 'r':
			case 'n':
				sprintf(a,"%s ",*argv);
				a += strlen(a);
				break;
			case 'q':
			case 'i':
			case 'p':
			case 'a':
			case 'c':
			case 'f':
				sprintf(p,"%s ",*argv);
				p += strlen(p);
				break;
			case 'v':
				if (*(*argv+2) != '\0')
					verbosity = atoi(*argv+2);
				else
					verbosity = 1;
				if (verbosity < 0)
				{
					verbosity *= -1;
					sprintf(a,"-v%d ",verbosity);
					a += strlen(a);
				}
				else
				{
					sprintf(p,"-v%d ",verbosity);
					p += strlen(p);
				}
				break;
			case 'x':
				xflag = 1;
				break;
			default:
				sprintf(cpp,"%s ",*argv);
				cpp += strlen(cpp);
				break;
			}
		}
		else
		{
			sprintf(p,"%s ",*argv);
			p += strlen(p);
		}
	}

	if (xflag)
		sprintf(pipe,"%s/%s -x %s|%s/%s %s",
				HATDIR,PARSER,popt,HATDIR,ANALYZER,aopt);
	else
		sprintf(pipe,"%s/%s %s|%s %s|%s/%s %s",
			HATDIR,PARSER,popt,CPPCMD,cppopt,HATDIR,ANALYZER,aopt);

	if (verbosity > 0)
		fprintf(stderr,"exec: %s\n",pipe);

	execl(SHELLCMD,SHELLCMD,"-c",pipe,NULL);
	fprintf(stderr,"EXECL RETURNED\n");
}
