#include <stdio.h>

/*
** generic error message routines.  Diag_xxx, may be externally set by caller.
**
** possible portability problem - use of several "long" arguments to pass
** stack through to underlying printf() family routine.
*/

/*
**
**	Copyright (c) 1987, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

char *Diag_file = "";		/* filename for use in diagnostic message */
int Diag_line = 1;		/* diagnostic line number */
int Diag_count = 0;		/* diagnostic counter */
FILE *Diag_fp = stderr;		/* output stream for messages */
char *Diag_cmd = "?";		/* command name for fatal() / usage() */

static int (*Fatcall)() = NULL;

/*
** print nonfatal diagnostic with line number from an input file.  Format
** compatible with "context"
*/
diagnostic(s,a,b,c,d,e,f)
char *s;
long a,b,c,d,e,f;
{
	fprintf(Diag_fp,"%s line %d: ",Diag_file,Diag_line);
	fprintf(Diag_fp,s,a,b,c,d,e,f);
	fprintf(Diag_fp,"\n");
	++Diag_count;
}

/*
** print fatal error message and exit.  May call user set cleanup routine first.
** argument list passed to fatal() will also be passed to cleanup routine.
*/
fatal (s,a,b,c,d,e,f)
char *s;
long a,b,c,d,e,f;
{
	fprintf (Diag_fp,"%s: ",Diag_cmd);
	fprintf (Diag_fp,s,a,b,c,d,e,f);
	fprintf (Diag_fp,"\n");
	if (Fatcall != NULL)
		(*Fatcall) (s,a,b,c,d,e,f);
	exit (1);
}

/*
** set cleanup routine for fatal() calls
*/
fat_set (fn)
int (*fn) ();
{
	Fatcall = fn;
}

/*
** print usage message and exit.
*/
usage (s,a,b,c,d,e,f)
char *s;
long a,b,c,d,e,f;
{
	fprintf (Diag_fp,"usage: %s ",Diag_cmd);
	fprintf (Diag_fp,s,a,b,c,d,e,f);
	fprintf (Diag_fp,"\n");
	exit (1);
}
