
/*
**
**	Copyright (c) 1988, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

#include <stdio.h>
#include "node.h"

extern NODE *RatList[];
extern char *RatTab;
extern char *strtok();
extern char *htab_find();
extern NODE *rat_list_sort();
extern int Verbosity;
extern int Smask;
extern int Hflag;

rat_analyze()
{
	/* fill in dependency & undef lists.  */
	if (Verbosity > 1)
		fprintf(stderr,"finding dependencies\n");
	rat_dep_scan();

	/* topological sort based on dependency */
	if (Verbosity > 1)
		fprintf(stderr,"sorting dependencies\n");
	rat_top_sort();

	/* sort symbol DEF, UDEF, DDEF lists into alphabetical order */
	if (Verbosity > 1)
		fprintf(stderr,"sorting symbol lists\n");
	RatList[DEF] = rat_list_sort(RatList[DEF]);
	RatList[UDEF] = rat_list_sort(RatList[UDEF]);
	RatList[DDEF] = rat_list_sort(RatList[DDEF]);

	/* print results */
	if (Smask & 3)
		fildep_sect();
	if (Smask & 4)
		sym_sect();
	if (Smask & 8)
		dd_sect();
	if (Smask & 0x10)
		ud_sect();
}

static
fildep_sect()
{
	register NODE *ptr;
	register NODE *dp;

	if (Smask & 1)
	{
		if (Hflag)
			printf ("\f\n<FILE DEPENDENCIES / INCLUSION ORDER>\n\n");

		for (ptr = RatList[FNAME]; ptr != NULL; ptr = ptr->next)
		{
			printf("%s:\n",ptr->key.name);
			for (dp = ptr->d.fname.dep; dp != NULL; dp = dp->d.dep.next)
				printf("\t%s (%s)\n", (dp->d.dep.dfile)->key.name,
						dp->d.dep.sym);
		}
	}

	/*
	** find expanded dependency list by marking nodes, and using
	** DFS.  Lot of hacking through the list, but it's the file
	** list, which is presumably short compared to lists of
	** symbols & so on.
	*/
	if (Smask & 2)
	{
		if (Hflag)
			printf ("\f\n<EXPANDED DEPENDENCY LIST>\n\n");

		for (ptr = RatList[CYCLE]; ptr != NULL; ptr = ptr->next)
			printf("CIRCULAR DEPENDENCIES: %s\n\n",ptr->d.cycle);

		for (ptr = RatList[FNAME]; ptr != NULL; ptr = ptr->next)
		{
			printf("%s:\n",ptr->key.name);
			for (dp = RatList[FNAME]; dp != NULL; dp = dp->next)
				dp->d.fname.mark = 0;
			ref_mark(ptr);
			for (dp = RatList[FNAME]; dp != NULL; dp = dp->next)
				if (dp->d.fname.mark && dp != ptr)
					printf("\t%s\n",dp->key.name);
		}
	}

}

/*
** recursive DFS to mark included files
*/
static
ref_mark(n)
NODE *n;
{
	NODE *ptr;

	n->d.fname.mark = 1;
	for (ptr = n->d.fname.dep; ptr != NULL; ptr = ptr->d.dep.next)
		if (! ((ptr->d.dep.dfile)->d.fname.mark))
			ref_mark(ptr->d.dep.dfile);
}

/*
** NOTE: sym_sect removes REF nodes from the hash table, in order
** to get at all the multiple entries.
*/
static
sym_sect()
{
	register NODE *ptr;
	register NODE *rptr;
	KEY key;

	if (Hflag)
		printf ("\f\n<DEFINITIONS / REFERENCES BY SYMBOL>\n\n");

	key.type = REF;
	for (ptr = RatList[DEF]; ptr != NULL; ptr = ptr->next)
	{
		key.name = ptr->key.name;
		printf("%s: %s\n",key.name,(ptr->d.file)->key.name);
		while ((rptr = (NODE *)htab_find(RatTab,(char *) &key)) != NULL)
		{
			if (rptr->d.file != ptr->d.file)
				printf("\t%s\n",(rptr->d.file)->key.name);
			htab_del(RatTab,(char *) &key);
		}
	}
}

static
dd_sect()
{
	register NODE *ptr;
	register NODE *dptr;
	KEY key;

	if (Hflag)
		printf ("\f\n<DOUBLE DEFINITIONS>\n\n");

	key.type = DEF;
	for (ptr = RatList[DDEF]; ptr != NULL; ptr = ptr->next)
	{
		key.name = ptr->key.name;
		dptr = (NODE *) htab_find(RatTab,(char *) &key);
		printf ("%s: %s %s\n",ptr->key.name,
				(dptr->d.file)->key.name,
				(ptr->d.file)->key.name);
	}
}

/*
** parses file names from UDEF node strings destructively
*/
static
ud_sect()
{
	register NODE *ptr;
	char *wd;
	int cnt;

	if (Hflag)
		printf ("\f\n<UNDEFINED>\n\n");

	for (ptr = RatList[UDEF]; ptr != NULL; ptr = ptr->next)
	{
		printf("%s:\n", ptr->key.name);
		cnt = 0;
		for (wd = strtok(ptr->d.ud.files," "); wd != NULL;
							wd = strtok(NULL," "))
		{
			--cnt;
			printf("\t%s\n",wd);
		}
		if ((cnt += ptr->d.ud.count) > 0)
			printf("\t+%d more\n",cnt);
	}
}
