
/*
**
**	Copyright (c) 1988, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/dir.h>
#include "node.h"
#include "config.h"

extern char *Diag_cmd;

char *htab_init();

/*
** there's only a few global variables, so we just declare them in here,
** rather than having a separate source file.
*/
NODE *RatList[MAXTYPE+1];	/* lists of nodes by type */
char *RatTab;			/* hash table pointer */

int Verbosity;
int Smask;
int Hflag;
int Zflag;

main(argc,argv)
int argc;
char **argv;
{
	char *rindex();
	char *ptr;

	if ((Diag_cmd = rindex(*argv,'/')) == NULL)
		Diag_cmd = *argv;

	Zflag = Verbosity = 0;
	Smask = 0x1f;

	rat_init();

	for (++argv; argc > 1; --argc,++argv)
	{
		/*
		** not intended to handle multiple files.
		** "normal" invocation is on the end of a pipe
		** Allowing a file at all is simply a debugging aid.
		*/
		if (**argv != '-')
		{
			fprintf(stderr,"reading from %s\n",*argv);
			freopen(*argv,"r",stdin);
			continue;
		}
		switch(*(*argv+1))
		{
		case 's':
			Smask = 0;
			for (ptr = *argv + 2; *ptr != '\0'; ++ptr)
			{
				switch(*ptr)
				{
				case 'd':
					Smask |= 1;
					break;
				case 'e':
					Smask |= 2;
					break;
				case 's':
					Smask |= 4;
					break;
				case 'm':
					Smask |= 8;
					break;
				case 'u':
					Smask |= 0x10;
					break;
				default:
					fatal("bad section - %c",*ptr);
				}
			}
			break;
		case 'r':
			Smask = 0x1f;
			for (ptr = *argv + 2; *ptr != '\0'; ++ptr)
			{
				switch(*ptr)
				{
				case 'd':
					Smask &= ~1;
					break;
				case 'e':
					Smask &= ~2;
					break;
				case 's':
					Smask &= ~4;
					break;
				case 'm':
					Smask &= ~8;
					break;
				case 'u':
					Smask &= ~0x10;
					break;
				default:
					fatal("bad section - %c",*ptr);
				}
			}
			break;
		case 'z':
			Zflag = 1 - Zflag;
			break;
		case 'v':
			Verbosity = atoi(*argv+2);
			break;
		case 'n':
			rat_forget(*argv+2);
			break;
		default:
			fatal("bad argument - %s",*argv);
		}
	}

	if (Smask == 0x10 || Smask == 8 || Smask == 4
					|| Smask == 2 || Smask == 1)
		Hflag = 0;
	else
		Hflag = 1;

	if (Verbosity > 0)
		fprintf(stderr,"%s: ENTRY\n",Diag_cmd);

	an_read();

	if (Verbosity > 0)
		fprintf(stderr,"%s: ANALYSIS\n",Diag_cmd);

	rat_analyze();
}

/*
** to hash a key, we do a "normal" hash with the string, with the 
** type added.  This keeps us from generating a lot of collisions
** from having both a REF & a DEF for most symbols. 
*/
static int
hash_func(s,size)
register char *s;
int size;
{
	register long rem;
	KEY *k;

	k = (KEY *) s;
	s = k->name;

	for (rem = k->type % size; *s != '\0'; ++s)
		rem = (rem*128 + (unsigned) *s) % size;
	return(rem);
}

/*
** key comparison - both name & type equal.
*/
static int
key_compare(s1,s2)
char *s1;
char *s2;
{
	if (((KEY *) s1)->type != ((KEY *) s2)->type)
		return (-1);

	return (strcmp(((KEY *) s1)->name, ((KEY *) s2)->name));
}

static
rat_init ()
{
	int i;

	i = next_prime(TABLE_SIZE);
	RatTab = htab_init(i,NULL,key_compare,hash_func);

	for (i=0; i < MAXTYPE+1; ++i)
		RatList[i] = NULL;
}
