 
 /*
 **
 ** Copyright (c) 1988, Robert L. McQueer
 ** 	All Rights Reserved
 **
 ** Permission granted for use, modification and redistribution of this
 ** software provided that no use is made for commercial gain without the
 ** written consent of the author, that all copyright notices remain intact,
 ** and that all changes are clearly documented.  No warranty of any kind
 ** concerning any use which may be made of this software is offered or implied.
 **
 */

 extern int Diag_line;
 extern char *Diag_file;
 extern int Iflag;
 extern int Xflag;
 extern int Aflag;
 extern int Cflag;
 extern int Verbosity;

 extern char *Ftab;

 extern char Fextra[];

 int Add_line;	/* referenced by yyparse() */

 static int Outflag;
 static int Oldstate;
 static int Close_include;

 static int Squelch;

 /*
 ** ifdef stack.  Cheap to specify a large number of nesting levels,
 ** so we don't bother making this configurable.  Number allowed
 ** is 32 times the length of the array (it's a bit map)
 ** Estack length matches Ifstack, and simply says whether the
 ** else goes with an if we are processing or not.
 */
 static unsigned long Ifstack[50];	/* yep, 1600 nested ifdefs! */
 static unsigned long Estack[50];
 static int Ifidx;

 /*
 ** a local stdio.h is used to pull in yytab.h and define
 ** MYPUTS(), which outputs a string conditionally on the
 ** setting of Outflag.  Also defines SQRET as a conditional
 ** return based on Squelch setting.
 */

 /*
 ** NOTES on interaction with yyparse:
 **
 ** returning WORD, NAWORD or AWORD indicates a string constant
 ** has been queued up using q_str().  It is up to the parser
 ** to dequeue the returned strings without overflowing the queue.
 **
 ** All /lib/cpp syntax is delimited for yyparse with the token
 ** CPPEND once we reach the end of the # line, or possible
 ** continuations for #define constructs.  Separate tokens
 ** DEFINE and CPP distinguish #define lines from other cpp
 ** lines.  States <PREPRO>, <DEF1> and <INDEF> are used for this.
 **
 ** Squelch controls #ifdef treatment.  If set, we simply continue
 ** scanning rather than passing tokens back to yyparse.  Thus
 ** we turn off #ifdef'ed out sections by simply not allowing the
 ** parser to see them.  Squelch is changed in such a manner as
 ** to send back or suppress things only on CPP boundaries. An
 ** entire CPP -> CPPEND statement is suppressed when we suppress,
 ** together with everything until the CPP -> CPPEND sequence
 ** turning it back on again, which is sent back in its entirety.
 **
 ** MYPUTS controls output of /lib/cpp constructs.  The scanner
 ** outputs all the /lib/cpp lines, unless the Xflag is on.  It
 ** also outputs "@<" , "@>" lines around includes if Iflag
 ** is on, and outputs the "@=" line, a "#line" directive, and
 ** any optional stuff specified by the command line at the
 ** beginning of each file.  The parser outputs "@!", "@?" lines
 ** only.
 **
 ** Much stuff is never seen by the parser.  Many characters such
 ** as +, -, (, ), = which are not important to the constructs the
 ** parser is looking for are treated as simple white space.  Numeric,
 ** single-quote and double-quote constants are also ignored, being
 ** treated much as commentary.  <COMMENT> and <QUOTE> states apply
 ** to this.  Note that they have to resume an old state, rather
 ** than an unconditional 0 to handle comment and quote constants
 ** within cpp syntax.
 **
 ** AWORD, NAWORD tokens apply only to the word following #define.
 ** AWORD indicates and argument list, NAWORD none.  ')' is returned
 ** as a token (MEND) only inside #define's, allowing the parser
 ** to pick up argument lists.
 **
 ** obvious item reference, .<something> or -><something> are
 ** also thrown out inside #defines, so we don't see them as
 ** symbol references.
 **
 ** Add_line is a mechanism to attempt to make line numbers
 ** match up for /lib/cpp.  Every time we generate a spare \n
 ** for a @ line, we bump it.  When an "optional" newline comes along,
 ** we decrement it if > 0, or output a newline.
 */

%Start COMMENT QUOTE INDEF DEF1 PREPRO
%%
<COMMENT>\n		{
				if (!Outflag && !Xflag)
				{
					if (Add_line > 0)
						--Add_line;
					else
						fputs(yytext,stdout);
				}
				++Diag_line;
			}
<COMMENT>[^*\n]+	;
<COMMENT>\*\/		BEGIN Oldstate;
<COMMENT>\*		;

<QUOTE>\n		{
				MYPUTS("\n");
				++Diag_line;
				diagnostic("unclosed quote");
				BEGIN Oldstate;
			}
<QUOTE>[^\\"\n]+	MYPUTS(yytext);
<QUOTE>\\\\		MYPUTS(yytext);
<QUOTE>\\\"		MYPUTS(yytext);
<QUOTE>\"		{
				BEGIN Oldstate;
				MYPUTS(yytext);
			}
<QUOTE>\\\n		{
				++Diag_line;
				MYPUTS(yytext);
			}
<PREPRO>\n		{
				++Diag_line;
				if (Close_include)
				{
					MYPUTS("\n@>\n");
					Add_line += 2;
				}
				else
					MYPUTS("\n");
				Close_include = Outflag = Oldstate = 0;
				BEGIN 0;
				SQRET(CPPEND);
			}

<DEF1>[A-Za-z_][A-Za-z0-9_]*\(	{
					MYPUTS(yytext);
					yytext[yyleng-1] = '\0';
					BEGIN INDEF;
					if (!Squelch)
					{
						q_str(yytext);
						SQRET(AWORD);
					}
				}

<DEF1>[A-Za-z_][A-Za-z0-9_]*	{
					MYPUTS(yytext);
					BEGIN INDEF;
					if (!Squelch)
					{
						q_str(yytext);
						SQRET(NAWORD);
					}
				}

<DEF1>\\\n	MYPUTS(yytext);
<DEF1>[ \t]+	MYPUTS(yytext);
<DEF1>.		{
			diagnostic("bizarre #define - can't find symbol");
			MYPUTS(yytext);
			BEGIN 0;
			REJECT;
		}

<INDEF>\\\n		{
				++Diag_line;
				MYPUTS(yytext);
			}
<INDEF>\)		{
				MYPUTS(yytext);
				SQRET(MEND);
			}

<INDEF>\-\>[A-Za-z0-9_]*	MYPUTS(yytext);
<INDEF>\.[A-Za-z0-9_]*		MYPUTS(yytext);

<INDEF>\\\\		MYPUTS(yytext);
<INDEF>\n		{
				++Diag_line;
				MYPUTS("\n");
				Outflag = Oldstate = 0;
				BEGIN 0;
				SQRET(CPPEND);
			}

\/\*	BEGIN COMMENT;
\"	{
		MYPUTS("\"");
		BEGIN QUOTE;
	}

^\#[ \t]*define		{
				Oldstate = INDEF;
				BEGIN DEF1;
				Outflag = ! Xflag;
				MYPUTS(yytext);
				SQRET(DEFINE);
			}
^\#[ \t]*include	{
				if (Iflag)
				{
					Close_include = 1;
					Outflag = 1;
					MYPUTS("\n@<\n");
					Add_line += 2;
					MYPUTS(yytext);
				}
				else
					Close_include = 0;
				Oldstate = PREPRO;
				BEGIN PREPRO;
				SQRET(CPP);
			}

^\#[ \t]*ifdef[ \t]*[A-Za-z0-9_]+	{
						Outflag = ! Xflag;
						MYPUTS(yytext);
						if (Cflag || Aflag)
							do_ifd(yytext,0);
						Oldstate = PREPRO;
						BEGIN PREPRO;
						SQRET(CPP);
					}
^\#[ \t]*ifndef[ \t]*[A-Za-z0-9_]+	{
						Outflag = ! Xflag;
						MYPUTS(yytext);
						if (Cflag || Aflag)
							do_ifd(yytext,1);
						Oldstate = PREPRO;
						BEGIN PREPRO;
						SQRET(CPP);
					}
^\#[ \t]*if		{
				Outflag = ! Xflag;
				MYPUTS(yytext);

				if (Cflag || Aflag)
					do_if();
				Oldstate = PREPRO;
				BEGIN PREPRO;
				SQRET(CPP);
			}
^\#[ \t]*else		{
				Outflag = ! Xflag;
				MYPUTS(yytext);
				if (Cflag || Aflag)
					do_else();
				Oldstate = PREPRO;
				BEGIN PREPRO;
				SQRET(CPP);
			}
^\#[ \t]*endif		{
				Outflag = ! Xflag;
				MYPUTS(yytext);
				if (Cflag || Aflag)
					do_end();
				Oldstate = PREPRO;
				BEGIN PREPRO;
				SQRET(CPP);
			}

^\#	{
		Oldstate = PREPRO;
		Outflag = ! Xflag;
		BEGIN PREPRO;
		MYPUTS("#");
		SQRET(CPP);
	}

\;	{
		MYPUTS(yytext);
		SQRET(SEMICOLON);
	}
\{	{
		MYPUTS(yytext);
		SQRET(LBRACE);
	}
\}	{
		MYPUTS(yytext);
		SQRET(RBRACE);
	}
\[	{
		MYPUTS(yytext);
		SQRET(LSQ);
	}
\]	{
		MYPUTS(yytext);
		SQRET(RSQ);
	}
\,	{
		MYPUTS(yytext);
		SQRET(COMMA);
	}

[0-9]+\.[0-9]*[Ee][+-]*[0-9]	MYPUTS(yytext);
[0-9]+[Ee][+-]*[0-9]		MYPUTS(yytext);

[0-9]+\.[0-9]*		MYPUTS(yytext);
[0-9]+L			MYPUTS(yytext);
[0-9]+			MYPUTS(yytext);
0[Xx][a-fA-F0-9]*L	MYPUTS(yytext);
0[Xx][a-fA-F0-9]*	MYPUTS(yytext);

\'\\\'\'	MYPUTS(yytext);
\'.*\'		MYPUTS(yytext);

[A-Za-z_][A-Za-z0-9_]*	{
				int i;

				MYPUTS(yytext);
				if (!Squelch)
				{
					if ((i = keycheck(yytext)) == WORD)
						q_str(yytext);
					SQRET(i);
				}
			}

\n	{
		if (!Outflag && !Xflag)
		{
			if (Add_line > 0)
				--Add_line;
			else
				fputs(yytext,stdout);
		}
		else
			MYPUTS(yytext);
		++Diag_line;
	}
.	MYPUTS(yytext);
%%

static
tok_out(i)
int i;
{
	diagnostic("scanned token %d",i);
	return (i);
}

/*
** called on each new file, to reset the scanner
*/
init_lex(name)
char *name;
{
	Add_line = Close_include = Ifidx = Squelch = Outflag = Oldstate = 0;

	printf("@=\"%s\"\n",name);
	if (! Xflag)
		printf("%s#line 1 \"%s\"\n",Fextra,name);
	Diag_line = 1;
	Diag_file = name;
}

char *strtok();
char *htab_find();

/*
** do_ifd is destructive, so it must be called AFTER output of text
*/
static
do_ifd(s,rev)
char *s;
int rev;
{
	int idx;
	int shift;

	idx = Ifidx/32;
	shift = Ifidx % 32;

	if (Squelch)
		Ifstack[idx] |= 1L << shift;
	else
		Ifstack[idx] &= ~(1L << shift);

	++Ifidx;

	if (Squelch)
	{
		Estack[idx] &= ~(1L << shift);
		return;
	}

	strtok(s," \t#");
	s = strtok(NULL," \t");
	--s;			/* we KNOW the strtok's bumped the string */
	*s = '+';
	if (htab_find(Ftab,s) != NULL)
	{
		if (rev)
			Squelch = 1;
		else
			Squelch = 0;
		Estack[idx] |= 1L << shift;
	}
	else
	{
		*s = '-';
		if (htab_find(Ftab,s) != NULL || Aflag)
		{
			if (rev)
				Squelch = 0;
			else
				Squelch = 1;
			Estack[idx] |= 1L << shift;
		}
		else
			Estack[idx] &= ~(1L << shift);
	}
}

/*
** ignore sense of all #if statements.
*/
static
do_if()
{
	int idx;
	int shift;

	idx = Ifidx/32;
	shift = Ifidx % 32;

	if (Squelch)
		Ifstack[idx] |= 1L << shift;
	else
		Ifstack[idx] &= ~(1L << shift);

	++Ifidx;

	Estack[idx] &= ~(1L << shift);
}

static
do_end()
{
	int idx;
	int shift;

	if (Ifidx == 0)
	{
		diagnostic("unmatched #endif");
		Squelch = 0;
		return;
	}

	--Ifidx;
	idx = Ifidx/32;
	shift = Ifidx % 32;

	Squelch = (Ifstack[idx] >> shift) & 1;
}

static
do_else()
{
	int idx;
	int shift;

	if (Ifidx == 0)
	{
		diagnostic("unmatched #else");
		Squelch = 0;
		return;
	}

	idx = Ifidx - 1;
	shift = idx % 32;
	idx /= 32;

	if ((Estack[idx] >> shift) & 1)
		Squelch = ! Squelch;
}
