
/*
**
**	Copyright (c) 1988, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

%token TYPEDEF EXTERN STRUCT ENUM
%token DEFINE WORD CPP CPPEND MEND AWORD NAWORD
%token ADJ STCLASS NTYPE KEYWORD
%token LSQ RSQ LBRACE RBRACE SEMICOLON COMMA
%right ADJ NTYPE
%%
file	:
		{
			p_init();
		}
	| file blurb
	;

blurb	: TYPEDEF st tdef tlist SEMICOLON
	| EXTERN ext SEMICOLON
	| pre
	| WORD
		{
			if (Qflag)
				r_out(next_str());
			else
				next_str();
		}
	| COMMA
	| LBRACE
	| RBRACE
	| SEMICOLON
	| KEYWORD
	| STCLASS
	| native
	| s1def
	| e1def
	| arrdim
	| error
		{
			Sn_def = 0;
			Head = Tail = 0;
			p_init();
		}
	;

pre	: DEFINE NAWORD
		{
			d_enter(next_str());
		}
		macro CPPEND
		{
			do_refs();
		}
	| DEFINE AWORD
		{
			d_enter(next_str());
		} margs MEND
		macro CPPEND
		{
			do_refs();
		}
	| CPP pjunk CPPEND
	;

margs	: 
	| mlist
	;

mlist	: WORD
		{
			a_enter(next_str());
		}
	| mlist COMMA WORD
		{
			a_enter(next_str());
		}
	;

s1def	: snword LBRACE
		{
			d_out(next_str());
		}
		struct RBRACE
	| STRUCT LBRACE struct RBRACE
	| snword WORD
		{
			r_out(next_str());
			next_str();
		}
	;

snword	: STRUCT WORD
	;

e1def	: eword LBRACE
		{
			d_out(next_str());
		}
		elist RBRACE
	| ENUM LBRACE elist RBRACE
	| eword WORD
		{
			r_out(next_str());
			next_str();
		}
	;

eword	: ENUM WORD
	;

st	:
	| st STCLASS
	;

tdef	: s2def
	| e2def
	| WORD
		{
			r_out(next_str());
			Sn_def = 0;
		}
	| native
		{
			Sn_def = 0;
		}
	;

elist	: 
		{
			Ecount = 0;
		}
	| elist WORD
		{
			if (Ecount)
				r_out(next_str());
			else
				d_out(next_str());
			++Ecount;
		}
	| elist COMMA
		{
			Ecount = 0;
		}
	;

native	: NTYPE
	| ADJ
	| ADJ native
	;

s2def	: snword LBRACE
		{
			strcpy(Sname,next_str());
			d_out(Sname);
			Sn_def = 1;
		}
		struct RBRACE
	| STRUCT LBRACE struct RBRACE
		{
			Sn_def = 0;
		}
	| snword WORD
		{
			Sn_def = 0;
			r_out(next_str());
			d_out(next_str());
		}
	;

e2def	: eword LBRACE
		{
			strcpy(Sname,next_str());
			d_out(Sname);
			Sn_def = 1;
		}
		elist RBRACE
	| ENUM LBRACE elist RBRACE
		{
			Sn_def = 0;
		}
	| eword WORD
		{
			Sn_def = 0;
			r_out(next_str());
			d_out(next_str());
		}
	;

struct	:
	| struct pre
	| struct s1def items SEMICOLON
	| struct e1def items SEMICOLON
	| struct WORD
		{
			r_out(next_str());
		} items SEMICOLON
	| struct native items SEMICOLON;
	;

items	:
	| items COMMA
	| items WORD
		{
			if (Qflag)
				d_out(next_str());
			else
				next_str();
		}
	| items arrdim
	;

tlist	:
	| tlist COMMA
	| tlist WORD
		{
			char *ptr;

			ptr = next_str();
			if (! Sn_def || strcmp(ptr,Sname) != 0)
				d_out(ptr);
		} tlarr
	;

tlarr	:
	| tlarr arrdim
	;

ext	: WORD
		{
			r_out(next_str());
		}
		ejunk
	| STRUCT WORD 
		{
			r_out(next_str());
		}
		ejunk
	| ENUM WORD
		{
			r_out(next_str());
		}
		ejunk
	| native ejunk
	;

ejunk	: 
	| ejunk WORD
		{
			next_str();
		}
	| ejunk LBRACE ebal RBRACE
	| ejunk STRUCT
	| ejunk COMMA
	| ejunk arrdim
	;

ebal	:
	| ebal LBRACE ebal RBRACE
	| ebal WORD
		{
			next_str();
		}
	| ebal COMMA
	| ebal SEMICOLON
	| ebal STRUCT
	| ebal arrdim
	| ebal native
	;

macro	:
	| macro WORD
		{
			r_enter(next_str());
		}
	| macro COMMA
	| macro SEMICOLON
	| macro LBRACE
	| macro RBRACE
	| macro STRUCT
	| macro LSQ
	| macro KEYWORD
	| macro RSQ
	| macro MEND
	| macro native
	| macro STCLASS
	| macro TYPEDEF
	| macro EXTERN
	| macro ENUM
	;

pjunk	:
	| pjunk WORD
		{
			next_str();
		}
	| pjunk COMMA
	| pjunk SEMICOLON
	| pjunk LBRACE
	| pjunk RBRACE
	| pjunk STRUCT
	| pjunk DEFINE
	| pjunk TYPEDEF
	| pjunk ENUM
	| pjunk EXTERN
	| pjunk LSQ
	| pjunk RSQ
	| pjunk native
	| pjunk STCLASS
	| pjunk KEYWORD
	;

arrdim	: LSQ dstuff RSQ
	;

dstuff	:
	| dstuff COMMA
	| dstuff WORD
		{
			r_out(next_str());
		}
	| dstuff STRUCT
	| dstuff native
	| dstuff KEYWORD
	;
%%

#include <stdio.h>
#include "config.h"


/*
** yyparse can look ahead one token.  Must make SDEPTH
** sufficient for all tokens parsed before calling next_str(), taking
** this into account.  I think 2 would actually work, currently.
*/
#define SDEPTH 3

static char Sq[SDEPTH][BUFSIZ];
static int Tail = 0;
static int Head = 0;

static int Sn_def;
static int Ecount;

static char Sname[BUFSIZ];

static char *Dtab = NULL;
static char *Def;

extern char *Ftab;

extern int Qflag;
extern int Iflag;
extern int Verbosity;

extern int Add_line;	/* see scanner */

char *htab_init();
char *htab_find();

char *str_store();

/* called by yylex() */
q_str(s)
char *s;
{
	strcpy(Sq[Tail],s);
	Tail = (Tail+1)%SDEPTH;
	if (Verbosity > 4)
		diagnostic("PUSH: %s",s);
}

static char *
next_str()
{
	char *ptr;

	ptr = Sq[Head];
	Head = (Head+1)%SDEPTH;
	if (Verbosity > 4)
		diagnostic("NEXT: %s",ptr);
	return (ptr);
}

static
p_init()
{
	if (Dtab == NULL)
	{
		Dtab = htab_init(SMALL_TABLE,NULL,NULL,NULL);
		if (Verbosity > 3)
			diagnostic("tab INIT");
	}
	else
	{
		htab_clear(Dtab);
		if (Verbosity > 3)
			diagnostic("tab CLEAR");
		str_free();
	}

	if (Tail != Head)
		diagnostic("OOPS - parser/lex synch problem");
	Head = Tail;
}

static
d_enter(s)
char *s;
{
	if (Verbosity > 2)
		diagnostic("#def: %s",s);
	if (keycheck(s) != WORD)
		diagnostic("Redefining keywords is not a good idea");
	Def = str_store(s);
}

static
a_enter(s)
char *s;
{
	if (Verbosity > 2)
		diagnostic("#arg: %s",s);
	htab_enter(Dtab,str_store(s),"ARG");
	if (Verbosity > 3)
		diagnostic("tab enter '%s', 'ARG'",s);
}

static
r_enter(s)
char *s;
{
	if (Verbosity > 2)
		diagnostic("#ref: %s",s);
	if (htab_find(Dtab,s) == NULL)
	{
		if (Verbosity > 3)
			diagnostic("tab enter '%s', ''",s);
		htab_enter(Dtab,str_store(s),"");
	}
	else
	{
		if (Verbosity > 3)
			diagnostic("tab contains '%s'",s);
	} 
}

static
do_refs()
{
	int i;
	char *k,*d;

	if (Verbosity > 2)
		diagnostic("#end");
	d_out(Def);
	for (i=htab_list(Dtab,1,&d,&k); i != 0; i=htab_list(Dtab,0,&d,&k))
	{
		if (Verbosity > 3)
			diagnostic("tab list '%s', '%s'",k,d);
		if (*d == '\0')
			r_out(k);
	}
	p_init();
}

static
r_out(s)
char *s;
{
	if (Verbosity > 1)
		diagnostic("REF: %s",s);
	if (Ftab != NULL && htab_find(Ftab,s) != NULL)
	{
		if (Verbosity > 1)
			diagnostic("Forget %s",s);
		return;
	}
	printf("@?\"%s\"\n",s);
	++Add_line;
}


static
d_out(s)
char *s;
{
	if (Verbosity > 1)
		diagnostic("DEF: %s",s);
	if (Ftab != NULL && htab_find(Ftab,s) != NULL)
	{
		if (Verbosity > 1)
			diagnostic("Forget %s",s);
		return;
	}
	printf("@!\"%s\"\n",s);
	++Add_line;
}

yyerror(s)
char *s;
{
	diagnostic(s);
}
