/*
** size of hash tables
**
** TABLE_SIZE refers to analysis program, and will contain entries
** for every symbol reference, definition, file, etc. - It can
** potentially contain a great many entries.
**
** SMALL_TABLE is for three tables used by the parser  - language keywords,
** -f/-c options, and the symbols referenced by a single macro respectively.
** None expected to require a huge number of entries.
**
** These sizes DO NOT affect how many entries may be made to the tables -
** they are a linked list arrangement allowed to be >100% density.
**
** actual table sizes will be adjusted upwards to a prime number.
*/
#define TABLE_SIZE 4000
#define SMALL_TABLE 60

/*
** hash table node allocation block for the analysis program.
*/
#define NODE_BLOCK 200

/*
** buffer size for strings containing lists of files, and lists
** of #define's and #undef's for -p options
*/
#define CATBUFFER 4800

/*
** couple things which ought to be defined in stdio.h and sys/params.h.
** In case they aren't
*/
#ifndef MAXPATHLEN
#define MAXPATHLEN 240
#endif

#ifndef BUFSIZ
#define BUFSIZ 1024
#endif

/*
** longest command line possible using your favorite shell(s)
** Used to allocate buffers for strings constructed from command line
** arguments
*/
#define MAXCMDLEN 4096
