
/*
**
**	Copyright (c) 1988, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/dir.h>
#include "config.h"

extern char *Diag_cmd;

extern FILE *yyin;

char *htab_init();

int Qflag;
int Iflag;
int Verbosity;
int Xflag;
int Cflag;
int Aflag;

char *Ftab;

char Fextra[CATBUFFER];

main(argc,argv)
int argc;
char **argv;
{
	char *fex;

	Diag_cmd = *argv;

	kt_init();

	Cflag = Aflag = Xflag = Iflag = Qflag = Verbosity = 0;
	Ftab = NULL;

	fex = Fextra;

	for (--argc; argc > 0; --argc)
	{
		++argv;
		if (**argv == '-')
		{
			++(*argv);
			switch(**argv)
			{
			case 'q':
				Qflag = 1 - Qflag;
				break;
			case 'i':
				Iflag = 1 - Iflag;
				break;
			case 'a':
				if (Ftab == NULL)
					Ftab = htab_init(SMALL_TABLE,
							NULL,NULL,NULL);
				Aflag = 1 - Aflag;
				break;
			case 'x':
				Xflag = 1;
				break;
			case 'p':
				switch((*argv)[1])
				{
				case '-':
					*argv += 2;
					sprintf(fex,"#undef %s\n",*argv);
					break;
				case '+':
					++(*argv);	/* fall through */
				default:
					++(*argv);
					sprintf(fex,"#define %s\n",*argv);
					break;
				}
				fex += strlen(fex);
				break;
			case 'c':
				Cflag = 1;
				if (Ftab == NULL)
					Ftab = htab_init(SMALL_TABLE,
							NULL,NULL,NULL);

				/*
				** yes, modifying the command line strings
				** Probably shouldn't do that, but
				** we aren't changing the length, just
				** replacing characters.
				*/
				switch((*argv)[1])
				{
				case '-':
					++(*argv);
					**argv = '+';
					htab_del(Ftab,*argv);
					**argv = '-';
					htab_enter(Ftab,*argv,*argv);
					break;
				case '.':
					++(*argv);
					**argv = '+';
					htab_del(Ftab,*argv);
					**argv = '-';
					htab_del(Ftab,*argv);
					++(*argv);
					break;
				case '+':
					++(*argv);	/* fall through */
				default:
					**argv = '-';
					htab_del(Ftab,*argv);
					**argv = '+';
					htab_enter(Ftab,*argv,*argv);
					break;
				}
				break;
			case 'f':
				++(*argv);
				if (Ftab == NULL)
					Ftab = htab_init(SMALL_TABLE,
							NULL,NULL,NULL);
				if (htab_del(Ftab,*argv) < 0)
					htab_enter(Ftab,*argv,*argv);
				break;
			case 'v':
				++(*argv);
				Verbosity = atoi(*argv);
				break;
			default:
				fatal("bad option: %s",*argv);
				exit(1);
			}
		}
		else
		{
			if (Verbosity > 0)
				printf("Scanning file %s .....\n",*argv);

			if ((yyin = fopen(*argv,"r")) == NULL)
			{
				fprintf(stderr,"Cannot open %s\n",*argv);
				continue;
			}
			init_lex(*argv);
			yyparse();
			fclose(yyin);
		}
	}
}
