
/*
**
**	Copyright (c) 1988, Robert L. McQueer
**		All Rights Reserved
**
** Permission granted for use, modification and redistribution of this
** software provided that no use is made for commercial gain without the
** written consent of the author, that all copyright notices remain intact,
** and that all changes are clearly documented.  No warranty of any kind
** concerning any use which may be made of this software is offered or implied.
**
*/

#include <stdio.h>
#include "config.h"
#include "y.tab.h"

static char *Ktab = NULL;

char *htab_init();
char *htab_find();

typedef struct
{
	char *word;
	int tok;
} KTAB_ENTRY;

/*
** this table controls recognition of C language keywords.  Except
** for a few, it really divides them into 4 rough classes, which is
** all the parser cares about:
**
**	NTYPE - can only appear as the terminating end of a datatype.
**	ADJ - can appear either as the terminating end of a datatype,
**		or as an adjective modifying a datatype.
**	STCLASS - storage classes and anything else which can modify
**		a datatype, but not terminate it.
**	KEYWORD - any other keyword.
**
** Datatype includes things like "void" only applicable to functions
** so that function pointers are recognized.
**
** Things not recognized by all compilers should be #ifdef'ed with
** USEXXX.  Most compilers / OS's generate some symbol to allow
** you to recognize them.  Use those directly underneath to define
** the right USEXXX's.  You can also assign sets to be used explicitly
** from -D options.
*/

/*
** CCEXTRAKEYS picks up some supposed reserved words which are often
** ignored by compilers
*/
#ifdef CCEXTRAKEYS
#define USECONST
#define USEVOLATILE
#define USEENTRY
#endif

/*
** for void, we require you to set something to turn it OFF
*/
#ifndef CCNOVOID
#define USEVOID
#endif

#ifdef vms
#define USEGLOBAL
#endif

static KTAB_ENTRY Kt[] =
{
	{ "typedef", TYPEDEF },
	{ "extern", EXTERN },
	{ "struct", STRUCT },
	{ "union", STRUCT },	/* same as a struct for our purposes */
	{ "enum", ENUM },

#ifdef USEVOID
	{ "void", NTYPE},
#endif
	{ "int", NTYPE },
	{ "float", NTYPE },
	{ "char", NTYPE },
	{ "double", NTYPE},

	{ "unsigned", ADJ},
	{ "signed", ADJ},
	{ "short", ADJ},
	{ "long", ADJ},

	{ "register", STCLASS},
	{ "auto", STCLASS},
	{ "static", STCLASS},
#ifdef USEGLOBAL
	{ "GLOBALDEF", STCLASS},
	{ "globaldef", STCLASS},
	{ "GLOBALREF", STCLASS},
	{ "globalref", STCLASS},
#endif
#ifdef USECONST
	{ "const", STCLASS},
#endif
#ifdef USEVOLATILE
	{ "volatile", STCLASS},
#endif

	{ "goto", KEYWORD },
	{ "return", KEYWORD },
	{ "sizeof", KEYWORD },
	{ "break", KEYWORD },
	{ "continue", KEYWORD },
	{ "if", KEYWORD },
	{ "else", KEYWORD },
	{ "for", KEYWORD },
	{ "do", KEYWORD },
	{ "while", KEYWORD },
	{ "switch", KEYWORD },
	{ "case", KEYWORD },
#ifdef USEENTRY
	{ "entry", KEYWORD },
#endif
	{ "default", KEYWORD }
};

kt_init()
{
	int i;

	Ktab = htab_init(SMALL_TABLE,NULL,NULL,NULL);
	for (i=0; i < sizeof(Kt)/sizeof(Kt[0]); ++i)
		htab_enter(Ktab, Kt[i].word, (char *) &(Kt[i].tok));
}

keycheck(s)
char *s;
{
	char *dat;

	if ((dat = htab_find(Ktab,s)) != NULL)
		return (*((int *) dat));
	return (WORD);
}
