/*
 * flock a file and wait for a process to exit				(ksb)
 *
 * Copyright 1988, All Rights Reserved
 *	Kevin S Braunsdorf
 *	ksb@j.cc.purdue.edu, pur-ee!ksb
 *	Math/Sci Building, Purdue Univ
 *	West Lafayette, IN
 *
 *  `You may redistibute this code as long as you don't claim to have
 *   written it. -- kayessbee'
 *
 * $Compile: ${cc-cc} ${DEBUG--C} ${SYS--Dbsd} %f -o %F
 */
#include <sys/types.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <stdio.h>

#if defined(bsd)
#define strchr	index
#define strrchr	rindex
#endif

static char *progname =
	"$Id: flock.c,v 2.0 88/10/23 15:06:21 ksb Exp $";

static char acUsage[] =		/* this is the usage line for the user	*/
	"%s: usage [-chn] [-EX|SH|UN|NB] file|fd [cmd]\n";
static char *apcHelp[] = {	/* help text				*/
	"c	create file, if nonexistant",
	"h	print this help message",
	"n	do not create file",
	"EX	exclusive lock, default",
	"NB	do not block for lock",
	"SH	shared lock",
	"UN	unlock",
	(char *)0
};

typedef struct LKnode {		/* a cmd line option implies a lock bit	*/
	char *pcflag;
	int iflag;
} LOCKKEY;

static LOCKKEY aLKLocks[] = {	/* the list of the cmd lines we know	*/
	{"LOCK_EX", LOCK_EX},
	{"LOCK_SH", LOCK_SH},
	{"LOCK_UN", LOCK_UN},
	{"LOCK_NB", LOCK_NB},
	{"EX", LOCK_EX},
	{"SH", LOCK_SH},
	{"UN", LOCK_UN},
	{"NB", LOCK_NB},
	{(char *)0, -1}
};

/*
 * determine which flag the use wants to set/clear			(ksb)
 */
int
Flag(pcCmd)
char *pcCmd;
{
	register char *pcTry;
	register LOCKKEY *pLK;
	extern char *strchr();

	for (pLK = aLKLocks; (char *)0 != (pcTry = pLK->pcflag); ++pLK) {
		if (0 == strcmp(pcTry, pcCmd)) {
			return pLK->iflag;
		}
	}
	if ((char *)0 != (pcTry = strchr(pcCmd, '|'))) {
		*pcTry++ = '\000';
		return Flag(pcCmd)|Flag(pcTry);
	}

	fprintf(stderr, "%s: `%s' is not a flock key\n", progname, pcCmd);
	exit(1);
	/*NOTREACHED*/
}

/*
 * is this character string all digits					(ksb)
 */
int
isnumber(pc)
char *pc;
{
	while (*pc) {
		if (*pc < '0' || *pc > '9')
			break;
		++pc;
	}
	return *pc == '\000';
}

/*
 * Get a lock on the named file and execute the rest of our arguments	(ksb)
 * while the lock is active, when this command exits exit with it's
 * extit status.
 */
int
main(argc, argv)
int argc;
char **argv;
{
	extern int atoi();
	extern char *strrchr();
	static char *apcTrue[] = {"true", (char *)0};
	auto union wait wait_buf;
	auto int fd, tClose, oFlags, fCreate = 0;
	auto int iLock = -1;
	auto char **ppcHelp;


	if ((char *)0 != (progname = strrchr(*argv, '/'))) {
		++progname;
	} else {
		progname = *argv;
	}
	++argv, --argc;
	while (argc > 0 && '-' == argv[0][0]) {
		switch (*++argv[0]) {
		case '\000':
			break;
		case 'n':
		case 'c':
			fCreate = argv[0][0] == 'c';
			argv[0][0] = '-';
			continue;
		case 'h':
			fprintf(stdout, acUsage, progname);
			for (ppcHelp = apcHelp; (char *)0 != *ppcHelp; ++ppcHelp) {
				fprintf(stdout, "%s\n", *ppcHelp);
			}
			exit(0);
		default:
			if (-1 == iLock)
				iLock = 0;
			iLock ^= Flag(argv[0]);
			break;
		}
		++argv, --argc;
	}

	if (-1 == iLock) {
		iLock = LOCK_EX;
	}

	if (0 == argc) {
		fprintf(stderr, acUsage, progname);
		exit(1);
	}

	tClose = 1;
	if (-1 == (fd = open(argv[0], O_RDONLY, 0600))) {
		oFlags = 0 != fCreate ? O_CREAT|O_WRONLY|O_APPEND : O_WRONLY|O_APPEND;
		if (-1 == (fd = open(argv[0], oFlags, 0666))) {
			if (!isnumber(argv[0])) {
				fprintf(stderr, "%s: open: ", progname);
				perror(argv[0]);
				exit(1);
			}
			fd = atoi(argv[0]);
			if (-1 == fcntl(fd, F_GETFD, 0)) {
				fprintf(stderr, "%s: %d: ", progname, fd);
				perror("fcntl");
				exit(1);
			}
			tClose = 0;
		}
	}
	if (-1 == flock(fd, iLock)) {
		fprintf(stderr, "%s: flock: ", progname);
		perror(argv[0]);
		exit(1);
	}
	++argv, --argc;

	if (0 == argc) {
		argv = apcTrue;
	}
	if (tClose != 0) {		/* save a fork */
		switch (fork()) {
		case 0:
			close(fd);
			break;
		case -1:
			fprintf(stderr, "%s: ", progname);
			perror("fork");
			exit(1);
			/*NOTREACHED*/
		default:
			wait(& wait_buf);
			/* exit will close fd for us */
			exit((int) wait_buf.w_retcode);
			/*NOTREACHED*/
		}
	}
	execvp(argv[0], argv);
	fprintf(stderr, "%s: ", progname);
	perror(argv[0]);
	exit(1);
	/*NOTREACHED*/
}
