.TH filterfile 1
.SH NAME
filterfile \- apply a filter to a file
.SH SYNTAX
filterfile
[
\fB\-dDpPtT\fI
] [
\fB\-o\fIout
] [
\fB\-e\fIext
] [
\fB\-ACHUVW\fI
]
file /path/filter
[
arg ...
]
.SH DESCRIPTION
\fIfilterfile\fB
applies a filter to a file,
writing the result to another file.
Various options let
\fIfilterfile\fB
delete the input file,
set the times of the output to the times of the input,
or set the protection mode of the output to that of the input.
.PP
Options
.B ACHUVW
print the authorship notice,
copyright notice,
help notice,
short usage summary,
version number,
and warranty information respectively.
.PP
\fIfilterfile\fB
has several flags:
.TP 12
.B -d
Delete the input file after the filter runs successfully.
The input file will remain untouched if the filter crashes
or exits with an error indication.
.TP
.B -D
Do not delete the input file. This is the default.
.TP
.B -p
Set the protection modes of the output to the protection modes
of the input.
.TP
.B -P
Leave the output protection modes alone. This is the default.
.TP
.B -t
Set the access and modification times of the output to those
of the input.
.TP
.B -T
Leave the times alone. This is the default.
.TP
\fB-o\fIout
Write the output on file
\fIout\fB.
This overrides
the 
.B\-e
option.
.TP
\fB-e\fIext
Write the output on
\fIfile.ext\fB.
.PP
If you specify neither
.B\-o
nor
\fB\-e\fI,
\fIfilterfile\fB
will look for an environment variable
.B FILEFILTEREXT
giving an extension.
If there is no such variable,
\fIfilterfile\fB
will give the output the same name as the input,
followed by a period.
.PP
If the extension begins with a period and the input file name
ends with that extension already, the extension is deleted from
the file name rather than added to it. If you really do want
periods in the extension, type them as slashes.
.PP
The options and input file name can come in any order,
but the second argument not starting with a hyphen
is taken to be the name of the filter.
Any further arguments are passed on as options to the filter.
.PP
You need not specify a full path name for the filter.
.SH DIAGNOSTICS
Altogether too many,
though luckily most are self-explanatory.
Most of these messages are followed by a more specific explanation
of the reason for the error; this list does not contain all the
possible variations.
.TP
\fIfatal: cannot create output file name: out of memory\fB
There is so little memory available that
\fIfilterfile\fB
cannot even put together the input file name and extension
to make the output file name.
.TP
\fIfatal: will not proceed: input file has extra links\fB
You have asked that the input file be deleted, but it
has more than one link.
.TP
\fIwarning: cannot change protections of output file\fB
This should never happen,
unless the file changes to someone else's ownership.
.TP
\fIfatal: cannot execute filter\fB
\fIfilterfile\fB
is unable to execute the filter.
.TP
\fIfatal: cannot fork\fB
You have probably run out of processes.
.TP
\fIfatal: cannot reopen input file\fB
\fIfilterfile\fB
is unable to open the input file at its original location.
.TP
\fIfatal: cannot reopen output file\fB
\fIfilterfile\fB
is unable to open the output file at its original location.
.PP
The following errors should all be self-explanatory:
.TP
\fIfatal: cannot open input file\fB
.TP
\fIfatal: cannot create output file\fB
.TP
\fIfatal: will not delete input file: it has been moved\fB
.TP
\fIfatal: will not delete input file: it has extra links\fB
.TP
\fIfatal: cannot delete input file\fB
.TP
\fIwarning: will not set times of output file: it has been moved\fB
.TP
\fIwarning: cannot set times of output file\fB
.PP
There are several errors that should never happen:
.TP
\fIfatal: cannot stat input file\fB
.TP
\fIfatal: cannot stat output file\fB
.TP
\fIfatal: cannot prepare input\fB
.TP
\fIfatal: cannot prepare output\fB
.TP
\fIfatal: can't find filter process\fB
.TP
\fIfatal: cannot restat input file\fB
.TP
\fIfatal: cannot restat output file\fB
.SH MACHINES
\fIfilterfile\fB
has been tested
on an Astronautics ZS-2
running ZSUnix.
.SH FILES
None.
.SH BUGS
None known.
.SH RESTRICTIONS
\fIfilterfile\fB
tries its best to detect when a file has been moved,
so that it won't delete the wrong file or change the times of
the wrong file. It also tries to detect when the input file
has several links, in which case it does not even try to delete
the file. Unfortunately, there is a very short period of time
between these tests and the actual operations, so
\fIfilterfile\fB
could enter a (non-looping) race condition and act incorrectly.
There is no way to avoid this race with available versions of UNIX.
.PP
In other words, if you move the input file out of the way and give
a different file the same name, the moment before
\fIfilterfile\fB
removes that filename,
you deserve what you get.
.SH VERSION
filterfile version 1.201, dated October 28, 1989.
.SH AUTHOR
Copyright 1989, Daniel J. Bernstein.
.SH "SEE ALSO"
apply(1),
xargs(1)
