#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#ifdef	DBM
#include <dbm.h>
#endif
#ifdef	NDBM
#include <ndbm.h>
#endif
#include <stdio.h>

/*
	filescan file summer and scanner.
	Copyright (C), Marcus J. Ranum, 1989. All rights reserved
	This code may be freely distributed as long as this header
	remains intact. No warranties are expressed or implied as
	to the suitability of this software for any purpose at all.
*/

/*
 *	$Log:	filescan.c,v $
 * Revision 1.1  89/09/13  14:26:27  mjr
 * Initial revision
 * 
 * 
*/

#ifndef	lint
static	char	*rcsid[] = "$Header: filescan.c,v 1.1 89/09/13 14:26:27 mjr Rel $";
#endif


extern	datum	fetch();
extern	char	*rindex();
extern	char	*getpass();
extern	char	*sprintf();

static	void		warn();

int	docheckin = 0;
FILE	*inf = { stdin };
FILE	*outf = { stdout };
int	updflg = 0;
int	sumflg = 0;
#ifdef	NDBM
DBM	*dbf;				/* icky global, I know */
extern	DBM	*dbm_open();
#endif

struct	secrec	{
	struct	stat	s;		/* stat info */
	int		sum;		/* actual sum */
	char		sumf;		/* checksum is present */
};


main(ac,av)
int	ac;
char	**av;
{
#ifdef	DBM
	int	doinit = 0;
#endif
	char	buf[BUFSIZ];
	char	*dbfile = NULL;
	int	aflg = 0;
	int	wflg = 0;
	int	errcnt = 0;
	int	warcnt = 0;

	while(*++av) {
		if(**av == '-') {
			switch(*(*av + 1)) {
			case 'a':	/* append to output */
				aflg++;
				break;

			case 's':	/* perform checksum on store */
				sumflg++;
				break;

			case 'u':	/* update changes in database */
				updflg++;
				break;

			case 'w':	/* exit status is # of warnings */
				wflg++;
				break;

			case 'c':	/* perform check in */
				docheckin++;
				break;
	
#ifdef	DBM
			case 'C':	/* initialize and truncate database */
				doinit++;
				break;
#endif

			case 'o':	/* output from check */
				if((outf = fopen(*++av,aflg?"a":"w")) == NULL) {
					perror(*av);
					exit(1);
				}
				break;

			case 'i':	/* input to check or store */
				if((inf = fopen(*++av,"r")) == NULL) {
					perror(*av);
					exit(1);
				}
				break;

			case 'd':	/* database name */
				dbfile = *++av;
				break;

			default:
 				exit(usage());
			}
		}

	}

	if(dbfile == NULL) {
		(void)fprintf(stderr,"can't initialize without datbase file name\n");
		exit(usage());
	}


#ifdef	DBM
	/* create new database files, since DBM is not smart enough to */
	if(doinit) {
		int	wfd;

		(void)sprintf(buf,"%s.dir",dbfile);
		if((wfd = open(buf,O_RDWR|O_TRUNC|O_CREAT,0600)) < 0) {
			(void)fprintf(stderr,"cannot create ");
			perror(buf);
			exit(1);
		}
		(void)close(wfd);
		(void)sprintf(buf,"%s.pag",dbfile);
		if((wfd = open(buf,O_RDWR|O_TRUNC|O_CREAT,0600)) < 0) {
			(void)fprintf(stderr,"cannot create ");
			perror(buf);
			exit(1);
		}
		(void)close(wfd);
	}
#endif


#ifdef	DBM
	/* open data files. DBM is global, so what the hey */
	if (dbminit(dbfile) < 0) {
		(void)fprintf(stderr,"cannot open database %s\n",dbfile);
		exit(1);
	}
#endif

#ifdef	NDBM
	if((dbf = dbm_open(dbfile,O_RDWR|O_CREAT,0600)) == NULL) {
		(void)fprintf(stderr,"cannot open database %s\n",dbfile);
		exit(1);
	}
#endif


	/* main loop. read input and either store it or check it */
	while(fgets(buf,BUFSIZ,inf) != NULL) {
		char	*p;

		/* drop the newline */
		if((p = rindex(buf,'\n')) != NULL)
			*p = '\0';

		if(docheckin)
			errcnt += scan_store(buf,0);
		else
			errcnt += scan_check(buf,&warcnt);
	}

	/* exit with different values depending on request */
#ifdef	DBM
	(void)dbmclose();
#endif
#ifdef	NDBM
	(void)dbm_close(dbf);
#endif
	exit(wflg ? warcnt : errcnt);
}

scan_store(fil,spec)
char	*fil;
char	spec;	/* override - make sure checksum is done for update */
{
	struct	secrec	sbuf;
	datum	key;
	datum	content;

	if(stat(fil,&sbuf.s)) {
		warn("cannot stat",fil);
		return(1);
	}

	if(sumflg || spec) {
		sbuf.sum = sumit(fil);
		sbuf.sumf = 1;
	} else
		sbuf.sumf = 0;

	key.dsize = strlen(fil);
	key.dptr = fil;
	content.dsize = sizeof(sbuf);
	content.dptr = (char *)&sbuf;

#ifdef	DBM
	if(store(key, content)) {
		warn("cannot store",fil);
		return(1);
	}
#endif
#ifdef	NDBM
	if(dbm_store(dbf,key, content,DBM_REPLACE)) {
		warn("cannot store",fil);
		return(1);
	}
#endif
	return(0);
}

scan_check(fil,warnings)
char	*fil;
int	*warnings;
{
	struct	secrec	sptr;
	struct	secrec	sbuf;
	datum	key;
	datum	content;
	int	state = 0;

	if(stat(fil,&sbuf.s)) {
		warn("cannot stat",fil);
		*warnings++;
		return(1);
	}

	key.dptr = fil;
	key.dsize = strlen(fil);

#ifdef	DBM
	content = fetch(key);
#endif
#ifdef	NDBM
	content = dbm_fetch(dbf,key);
#endif

	/* i suppose that not being in the database is an error, */
	/* not a security violation, in as many words */
	if (content.dptr == 0) {
		warn("no entry in database",fil);

		/* update changes */
		if(updflg) {
			/* a checksum will be done only if sumflg is set */
			(void)scan_store(fil,0);
		}
		return(1);
	}

	(void)bcopy(content.dptr,(char *)&sptr,sizeof(sptr));

	/* check what we deem important */
	if(sptr.sumf != 0) {
		sbuf.sum = sumit(fil);
		if(sptr.sum != sbuf.sum) {
			warn("checksum does not match",fil);
			state++;
		}
	}
	if(sptr.s.st_size != sbuf.s.st_size) {
		warn("file size has changed",fil);
		state++;
	}
	if(sptr.s.st_uid != sbuf.s.st_uid) {
		warn("owner uid has changed",fil);
		state++;
	}
	if(sptr.s.st_uid != sbuf.s.st_uid) {
		warn("owner gid has changed",fil);
		state++;
	}
	if(sptr.s.st_mode != sbuf.s.st_mode) {
		warn("permissions have changed",fil);
		state++;
	}
	if(sptr.s.st_mtime != sbuf.s.st_mtime) {
		warn("modification time has changed",fil);
		state++;
	}
	if(sptr.s.st_ctime != sbuf.s.st_ctime) {
		warn("creation time has changed",fil);
		state++;
	}

	/* update changes */
	if(updflg && state != 0)
		/* checksum will be done if sumflg or the file flag is set */
		(void)scan_store(fil,sptr.sumf);

	return(state);
}

usage()
{
	(void)fprintf(stderr,"usage:\n");
	(void)fprintf(stderr,"filescan -d database [-a (append to log)] [-s (perform checksums)]\n");
#ifdef	NDBM
	(void)fprintf(stderr,"\t[-w (exit with warnings)] [-c (load database)]\n");
#endif
#ifdef	DBM
	(void)fprintf(stderr,"\t[-w (exit with warnings)] [-c (load database)] [-C (create database)]\n");
#endif
	(void)fprintf(stderr,"\t[-i filename (read list from file)] [-o filename (log file)]\n");
	(void)fprintf(stderr,"\t[-u (update any changes found)]\n");
	return(1);
}

static	void
warn(s1,s2)
char	*s1;
char	*s2;
{
	extern	int	errno;
	extern	char	*sys_errlist[];

	if(errno) 
		(void)fprintf(outf,"%s:%s(%s)\n",s2,s1,sys_errlist[errno]);
	else
		(void)fprintf(outf,"%s:%s\n",s2,s1);
}


sumit(fil)
char	*fil;
{
	int	sum = 0;
	int	fd;
	int	cnt;
	char	buf[BUFSIZ];

	if((fd = open(fil,O_RDONLY)) < 0) {
		warn("cannot read for sum",fil);
	} else {
		while((cnt = read(fd,buf,BUFSIZ)) > 0)
			sum += in_cksum((u_short *)buf,cnt);
		(void)close(fd);
	}
	return(sum);
}
