/*
*
* fastsort - sort a file in place - fast!
*
* Written 03/01/89 by Edwin R. Carp
*
* Copyright 1989 by Edwin R. Carp
*
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include "sizefile.fun"

main(argc, argv)
int argc;
char **argv;
{
   char *array, *test, line[1024], *malloc();
   int i, j, ctr=0, len, greatest=0, strcmp();
   long size;
   FILE *in;

   if(argc < 2)
   {
      puts("usage: fastsort files...\n");
      exit(1);
   }
   for(i=1; i<argc; i++)
   {
      if((size=sizefile(argv[i])) < 1)
      {
         perror(argv[i]);
         continue;
      }
      if((char *)NULL == (test=(char *)malloc(sizeof(char) * size)))
      {
         printf("Can't sort %s in place - not enough memory!\n", argv[i]);
         continue;
      }
      free(test);
      if((in=fopen(argv[i], "r+")) == (FILE *)NULL)
         perror(argv[i]);
      else
      {
         printf("%s: READING - Pass 1\r", argv[i]);
         fflush(stdout);
         while(fgets(line, 1022, in) != (char *)NULL)
         {
            len = strlen(line);
            if(len > greatest) greatest = len;
            if(*(line+len-1) != '\n')
            {
               printf("\nline longer than 1024 characters - sort aborted!\n");
               exit(1);
            }
            ctr++;
         }
         greatest++;
         printf("\nAllocating ");
         array = malloc(sizeof(char) * ctr * greatest);
         printf("%ld bytes\n",
             (long)sizeof(char)*(long)ctr*(long)greatest);
         if(array == (char *)NULL)
         {
            printf("Can't sort %s in place - not enough memory!\n",
                argv[i]);
            exit(1);
         }
         fseek(in, 0L, 0); /* rewind it */
         printf("%s: READING %d records - Pass 2\r", argv[i], ctr);
         fflush(stdout);
         for(j=0; j<ctr; j++)
         {
            if((char *)NULL == fgets(array+(j*greatest), greatest, in))
            {
               ctr = j;
               break;
            }
         }
         printf("%s: SORTING                         \r", argv[i]);
         fflush(stdout);
         qsort(array, (unsigned)ctr, greatest, strcmp);
         printf("%s: WRITING\r", argv[i]);
         fflush(stdout);
         fseek(in, 0L, 0); /* rewind it */
         for(j=1; j<NSIG; j++)
            signal(j, SIG_IGN); /* ignore all sigs while writing */
         for(j=0; j<ctr; j++)
            fprintf(in, "%s", array+(j*greatest));
         printf("%s: DONE        \n", argv[i]);
         free(array);
         fclose(in);
         ctr = 0;
      }
   }
   exit(0);
}
