.TH D 1 "9 June 1988"
.SH NAME
D - A Directory Display Utility
.SH SYNOPSIS

D is invoked by a command line of the following form:

.ce
d [-options ...] [file ...] ...

where the options specify the format of
the output.

Options (case is not significant) are:

.nf
  -1  Output in one column
  -a  Display all files (including hidden ones)
  -d  Omit directory names from display
  -H  Print this help message
  -s  Suppress display of total file count and size

.fi
.SH DESCRIPTION

D displays a sorted listing of files.  This listing takes
two basic forms (commands are on lines beginning with a $):
  
(1) short form (less than or equal to SHORTLIMIT files in listing) -

.ne 5
.nf
$ d d*
 d                        32768 rwx
 d.c                       9411 rw-

2 Files, 42179 Bytes
.fi
  
(2) long form (more than SHORTLIMIT files in listing), with the sort
down the columns -

.ne 6
.nf
$ d
 d                        32768 rwx |  prform.l                  7715 rw-
 d.c                       9411 rw- |  xdir_orig.c               1802 rw-
 prform.c                 13680 rw- |  xdir_very_old.c          12452 rw-
  
6 Files, 77828 Bytes
.fi

If the listing includes directory names, these
names are prefixed with a / and sorted after the files:

.ne 13
.nf
$ d -a ~
 .cshrc                    1362 rwx |  .rootmenu                  404 rw-
 .defaults                  561 rw- |  .suntools                  464 rw-
 .history                   264 rw- | /benchmark_results          512 rwx
 .indent.pro                 20 rw- | /bin                        512 rwx
 .kermrc                     50 rw- | /components                2048 rwx
 .kermrc_ttyb               279 rw- | /diagrams                   512 rwx
 .login                     835 rw- | /upload                      24 rwx
 .logout                     83 rw- | /upload1                    512 rwx
 .mailrc                    499 rwx | /work                       512 rwx
 .prrc                       38 rw- | /xmc                        512 rwx
  
20 Files, 10003 Bytes
.fi

One major distinguishing feature of D is that D presents
the rwx permissions from the point of view of the user running the
program.  If a file is owned by the user, the user rwx permissions
are shown; if the file is not owned by the user but owned by someone
in the user's group, the group rwx permissions are shown; and if the
file is owned by someone outside the user's group, the world rwx
permissions are shown.
  
.SH INSTALLATION

One of the following symbols must be
defined in the compiler command line:

.ne 4
.nf
	BSD    - any flavor of BSD UNIX
	POSIX  - standard POSIX (IEEE Std 1003.1,
                   April 1986), untested
	SYSVR2 - Release 2 of UNIX SYSTEM V
	SYSVR3 - Release 3 of UNIX SYSTEM V
.fi

Example:
.nf
	cc -o d -DBSD d.c
.fi
  
.SH BUGS

The POSIX installation option has not been tested, but is believed
to be correct.

.SH AUTHOR

D Version 1.x (Beta Test) was written by Richard Conn.

D Version 2.0 was created from 1.x by Richard Conn.

Special thanks to Frank Wancho for providing the SYSTEM V
code specifics and checking the program out under several SYSTEM V
machines.  Thanks also to Frank for his review effort and constructive
comments.

