.\"
.\"	$Id: cvs.man,v 1.5 89/11/20 00:11:16 berliner Exp $
.\"
.TH CVS L "20 July 1989"
.\" Full space in nroff; half space in troff
.de SP
.if n .sp
.if t .sp .5
..
.SH "NAME"
cvs \- Concurrent Versions System
.SH "SYNOPSIS"
.B cvs
[
.I cvs_options
]
.I cvs_command
[
.I command_options
] [
.I command_args
]
.SH "DESCRIPTION"
.IX "revision control system" "\fLcvs\fR"
.IX  cvs  ""  "\fLcvs\fP \(em concurrent versions system"
.IX  "concurrent versions system \(em \fLcvs\fP"
.IX  "release control system"  "cvs command"  ""  "\fLcvs\fP \(em concurrent versions system"
.IX  "source control system"  "cvs command"  ""  "\fLcvs\fP \(em concurrent versions system"
.IX  revisions  "cvs command"  ""  "\fLcvs\fP \(em source control"
.B cvs
is a front end to the
.BR rcs (l)
revision control system which extends
the notion of revision control from a collection of files in a single
directory to a hierarchical collection of directories consisting of
revision controlled files.
These directories and files can be combined together to form a software
release.
.B cvs
provides the functions necessary to manage these software releases and to
control the concurrent editing of source files among multiple software
developers.
.LP
The following list summarizes some of the strong points of
.BR cvs :
.TP
\(bu
Only a single copy of the master sources exist.
This copy is called the source ``repository'' and, through administrative
actions, contains all the information to extract previous software releases
at any time based on either a symbolic revision tag, or a date in the past.
.TP
\(bu
Individual software developers check out private copies of the sources into
their personal work space.
These private sources can be edited at any time and checked back into the
source repository as a permanent change.
.B cvs
takes special care to ensure that a file is up-to-date with the current
revision in the source repository before allowing it to be added as a
permanent change.
.TP
\(bu
There is a facility for software developers to bring their private copies
of the sources up-to-date with the currently checked in revisions, while at
the same time preserving any modifications that have been made to their
private sources.
This allows multiple developers to be concurrently working on the same
source files without regard for what the other guy is doing.
.SP
Note that this is the biggest change from the way most other revision
control systems, like
.SM RCS
or
.SM SCCS
work, which allow only one developer to ever be changing a file, since the
file must be checked out as ``locked'' for the exclusive use of that person.
.B cvs
instead never applies an
.SM RCS
lock to a checked out file until the moment before it is to be checked back
in as a permanent change.
Concurrency checks are performed on the soon-to-be checked in file and the
file must be up-to-date before it can be made permanent.
In this way,
.B cvs
allows individuals the freedom to change any file at will, and provides the
tools necessary to point out, if not resolve, any conflicts that may be
generated by allowing this extra, and necessary, freedom.
.TP
\(bu
.B cvs
has direct support for tracking source releases from third-party vendors.
The
.BR checkin (l)
program is used to initially setup the source repository.
The branch support of
.SM RCS
is used to build the vendor release as a branch off the main (local)
.SM RCS
trunk.
Once this is done, developers can check out files and make local changes to
the vendor's source distribution.
The act of checking in a local change to a vendor's source distribution
moves the
.SM RCS
branch from tracking the third-party vendor's release to the main (local)
RCS trunk so that
the local version of the file is used forever more.
.SP
When a new version of the vendor's source distribution (or even a minor
version consisting of a small subset of files) arrives, the
.B checkin
program is used again to add the new vendor release to the already existing
source repository.
For files that have not been changed locally, the new file from the
vendor becomes the current revision.
For files that have been modified locally,
.B checkin
warns that the file must be merged manually with the new vendor release.
The
.B join
command of
.B cvs
is a useful tool that aids this manual merge process (see below).
.TP
\(bu
A vendor release or a local release can be given a symbolic tag name that
is stored directly in the
.SM RCS
files.
This tag can be used at any time in the future to get an exact copy of any
previous release.
With equal ease, one can also extract an exact copy of the source files as
of any arbitrary date in the past as well.
.TP
\(bu
All changes that are made to the source repository are carefully logged in
a file, notesfile, or news database, which can be used to produce release
notices.
.B cvs
can be configured to send log updates through one or more filter programs,
based on a regular expression match on the directory that is being changed.
This allows multiple related or unrelated projects to exist within a single
.B cvs
source repository tree, with each different project sending their checkin
reports to a unique log device for the project.
.TP
\(bu
There is support for a simple, yet powerful, ``module'' database.
This database can be used to apply names to collections of directories and
files as a matter of convenience when checking out smaller pieces of a
larger software distribution.
This allows one to checkout the ``diff'' program, for example, without
ever requiring the knowledge that the sources to ``diff'' actually reside
in the ``bin/diff'' directory.
.SP
The module database also has limited support for an aliasing capability.
This is useful for programs that share sources from completely disjoint
directories.
The aliasing feature can also be used to limit a named release to a certain
collection of directories and files, to only work with pieces of the source
found in the entire source repository.
.TP
\(bu
There is direct support for determining which files have changed since a
previous release, or from a particular date.
As well,
.B cvs
can create a
.BR patch (l)
format output file which can be used to bring a previously released
software distribution current with the newest release.
One can create a patch file between two tagged revisions, between a
revision and some date in the past, between two dates, or between a date or
revision and the current ``head'' revision.
.LP
The remainder of this manual page will document how all these actions can
be done using the
.B cvs
program.
.SH "OPTIONS"
.B cvs
accepts a number of options that override the current setting of the
recognized environment variables.
.TP
.B \-r
Checks out files read-only.
Same effect as if the
.SM CVSREAD
environment variable is set.
.TP
.B \-w
Checks out files read-write (default).
Overrides the setting of the
.SM CVSREAD
environment variable.
.TP
.B \-v
Outputs version and copyright information for
.BR cvs ,
then exits.
.TP
\fB-d\fP \fICVS_root_directory\fP
Use
.I CVS_root_directory
as the root directory pathname of the master
.SM RCS
source repository.
Overrides the setting of the
.SM CVSROOT
environment variable.
.TP
\fB-b\fP \fIbindir\fP
Use
.I bindir
as the directory to find
.SM RCS
programs within.
Overrides the setting of the
.SM RCSBIN
environment variable.
.TP
\fB-e\fP \fIeditor\fP
Use
.I editor
for editing revision log information.
Overrides the setting of the
.SM EDITOR
environment variable.
.TP
.B \-H
Displays usage information about the specified
.I cvs_command
without actually executing said command.
.SH "USAGE"
A
.I cvs_command
must be specified to
.B cvs
which drives the specific release control function that is performed.
Each
.B cvs
command accepts options and arguments unique to the command.
The usage statements for each command can be displayed by specifying the
.B \-H
option to the command.
.LP
The available commands are listed below along with a description of their
function.
Command options unique to the command are described in this section with
the command description.
Common command options are described fully in the following section.
.TP
\fBcheckout\fP [\fB-Qqlfnp\fP] [\fB-c\fP] [\fB-r\fP \fItag\fP|\fB-D\fP \fIdate_spec\fP] \fImodules\fP...
Checks out the source files defined by
.IR modules .
This command is used to get a private copy of the current sources that can
be edited and processed by most of the other
.B cvs
commands.
.B checkout
must be done before many of the other
.B cvs
commands are used, since most of them operate on checked out sources.
.SP
Depending on the
.I modules
specified,
.B checkout
may recursively create directories and populate them with the appropriate
source files.
These source files can then be edited at any time (regardless of whether
other software developers are editing their private copies of the sources),
updated to include new changes checked into the source repository, or
committed as a permanent change to the
.SM RCS
repository.
.SP
Note that
.B checkout
is used to create directories.
The top-level directory created is always added to the working directory
where
.B checkout
is invoked, and usually has the same name as the specified
.IR module .
In the case of a
.I module
alias, the created sub-directory may have a different name, but you can be
sure that it will be a sub-directory, and that
.B checkout
will show the relative path leading to each file as it is extracted into
your private work area, unless the
.B \-Q
option is specified.
.SP
Running
.B checkout
on a directory that was already built by
.B checkout
is also OK.
This has the same effect as specifying the
.B \-d
option to the
.B update
command described below.
.SP
The
.B \-c
option ``cat''s the module file, sorted, to the standard output, and does
not cause any files or directories to be checked out.
.SP
.B co
can be specified instead of
.B checkout
to save some typing.
See the
.SM MODULES
section below for a complete description of modules.
.TP
\fBupdate\fP [\fB-Qqlfp\fP] [\fB-d\fP] [\fB-r\fP \fItag\fP|\fB-D\fP \fIdate_spec\fP] \fIfiles...\fP
After
.B checkout
is run, directories and files have been extracted from the source
repository for your personal editing.
At any time that is convenient in your development process, the
.B update
command can be run
.I "from within the directory that contains the checked out sources"
to bring those sources current with any revisions that have been checked
into the source repository since they were last checked out or
.BR update d.
.SP
Normally,
.B update
brings the current directory up-to-date, then descends any sub-directories,
bringing them up-to-date as well.
This can be overridden by specifying a list of files that should only be
updated, or by using the
.B \-l
option which causes
.B update
to only process the current directory, ignoring any sub-directories.
.SP
If any special options were initially specified to
.B checkout
when the source were initially checked out, these exact options should be
specified to
.B update
as well to keep the sources consistent with the way they were originally
checked out.
For example, checking out sources by specifying the ``\fB-r V1_0\fP''
option will check out the revisions associated with the
.B V1_0
release tag.
A subsequent
.B update
that does \fInot\fP specify this exact
.B \-r
option as well will revert to updating the sources with the current
revisions as stored in the source repository, rather than those revisions
associated with the
.B V1_0
release.
.SP
For a complete description of the algorithm that
.B update
uses to bring your source up-to-date, refer to the
.SM "\fBCONFLICT RESOLUTION\fP"
section below.
.TP
\fBcommit\fP [\fB-fn\fP] [-a] [\fB-m\fP '\fIlog_message\fP'] [\fB-r\fP \fIrevision\fP] [\fIfiles...\fP]
At any point, changes that you have made to your private copies of the
sources may be
.BR commit ted
to the source repository as a permanent change.
.B commit
does not do a recursive
.BR commit ,
so each individual directory must be checked in separately, even if the
changes were related.
.SP
.B commit
verifies that the selected files are up-to-date with the current revisions
in the source repository and will abort without committing if any of the
specified files must be made current first with the
.B update
command.
With the
.B \-a
option, all relevant files of the current directory are examined.
.B commit
is careful to only check in those files that have really changed.
Note that
.B commit
does not
.B update
the out-of-date files for you, but rather leaves that for you to do when
the time is right.
.SP
An
.SM RCS
identification string ($\&Id\&) must exist in the modified files that are
to be checked in.
If the identification string cannot be found in any of the files,
.B commit
will prompt you for verification before proceeding.
This prompt is bypassed if the
.B \-f
option has been specified.
.SP
When all is well, an editor is invoked for the purpose of entering a log
message that will be written to one or more logging programs and placed in the
.SM RCS
source repository file.
The log message may be specified on the command line with the
.B \-m
option, thus suppressing the editor invocation.
.SP
.B ci
can be specified instead of
.B commit
to save some typing.
.TP
\fBdiff\fP [\fIrcsdiff_options\fP] [\fIfiles...\fP]
Your checked out files can be diffed against the original revisions they
were based upon with the
.B diff
command.
See
.BR rcsdiff (l)
for a list of accepted options.
If no files are specified,
.B diff
will only ``diff'' those files in the current directory that
are different than the checked out revision (i.e. ones that
.I you
have changed), or that are different than a specified revision.
If files are specified, only those files are diffed.
.SP
Two revisions may be specified as well.
In which case your private sources are not diffed at all.
Instead, the two revisions specified are diffed.
.TP
\fBlog\fP [\fIrlog_options\fP] [\fIfiles...\fP]
To display revision log information equivalent to the
.BR rlog (l)
program, the
.B log
command is used.
See
.BR rlog (l)
for a list of accepted options.
If no files are specified,
.B log
will run an
.B rlog
(with the arguments asa specified)
on every file under
.B cvs
control in the current directory.
If files are specified, the log information of only those files is displayed.
.TP
\fBstatus\fP [\fIfiles...\fP]
Displays three lines of information for each of its argument files, one for
the user file (line 1), one for the newest
.SM RCS
file showing the current ``head'' revision number (line 3),
and one for the
.SM RCS
file both derive from showing the date it was last updated (line 2).
.TP
\fBadd\fP [\fB-m\fP '\fImessage\fP'] \fIfiles...\fP
To permanently create a new file or directory in the
.SM RCS
source repository, the
.B add
command is used.
The files or directories specified to
.B add
must already exist in the current directory (which must have been created
with the
.B checkout
command).
For adding a whole new directory hierarchy to the source repository
that was received from a third-party vendor, see the
.BR checkin (l)
program for how to do this.
.SP
If the argument refers to an immediate sub-directory, the directory is
created at the correct place in the
.SM RCS
source repository and the necessary
.B cvs
administration files are created within the argument directory.
It is not considered an error if the
.SM RCS
source repository directory already exists.
Thus, to add a directory to your private sources that was created after you
had done your
.B checkout
of the sources, you can do the following:
.SP
.in +1i
.ft B
.nf
example% mkdir new_directory
example% cvs add new_directory
example% cvs update new_directory
.fi
.ft P
.in -1i
.SP
For each added file, a description of the file's purpose is read from the
terminal in
.SM RCS
fashion, unless the
.B \-m
option is specified, in which case the argument
.I message
is used instead.
This description will become a permanent part of the created
.SM RCS
file.
.SP
The added files are not placed in the
.SM RCS
source repository until they are
.BR commit ted
as a permanent change.
Doing an
.B add
on a file that has been removed with the
.B remove
command will resurrect the file, unless it has already been 
.BR commit ted.
.TP
\fBremove\fP \fIfiles...\fP
Marks the specified files as removed on purpose from the current directory
in the source repository.
The specified files must no longer exist in the current directory when the
.B remove
command is issued.
The files are not actually removed until they are
.BR commit ted,
at which point their respective
.SM RCS
files in the source depository are
.I moved
into the
.I Attic
directory within the source repository.
To restore a committed removed file to the present version requires an
administrator to physically
.I move
the
.SM RCS
file out of the
.I Attic
and back into its parent directory.
.TP
\fBjoin\fP [\fB-Qqf\fP] [\fB-r\fP \fItag\fP|\fB-D\fP \fIdate_spec\fP] \fIfiles...\fP
The intended purpose of the
.B join
command is to perform the logical merge of a new vendor release installed
with the
.BR checkin (l)
command with locally modified files from a previous vendor release.
The
.B checkin
program will inform you that a vendor file has been locally modified and it
is up to
.I you
to resolve the two branches of development (local and vendor) into a
unified revision that will be
.BR commit ted
as a permanent change to the source repository on the main (local) trunk.
The
.B join
command will usually be used with the
.B \-r
option to specify the vendor tag that is to be merged with the local
changes.
This merge is handled by
.SM RCS
and the resultant file is placed in the current directory (within your
private work space) and any conflicts during the merge are displayed.
.SP
After correcting any conflicts during the merge,
.B commit
the joined file as usual with a modified file, and the result (with a bit
of work, perhaps) should be a working combination of the local changes and
the vendor changes.
.LP
The following commands do their work entirely within the
.SM RCS
source repository and, as such, do not require that a
.B checkout
be done first.
These commands are usually of interest only to the person responsible for
the release procedures of a software package.
See the
.SM "\fBMODULE SUPPORT\fP"
section below for a full description of what a
.I module
is.
.TP
\fBpatch\fP [\fB-Qqlf\fP] [\fB-s\fP|\fB-t\fP] [\fB-r\fP \fItag\fP|\fB-D\fP \fIdate_spec\fP [\fB-r\fP \fItag\fP|\fB-D\fP \fIdate_spec\fP]] \fImodules...\fP
Builds a Larry Wall format
.BR patch (l)
file between two releases that can be fed directly into the
.B patch
program to bring an old release up-to-date with the new release.
The diff output is sent to the standard output device.
Note that any combination of one or two revisions or dates may be specified.
If only one revision or date is specified, the
.B patch
is made between that revision or date and the current ``head'' revisions in
the
.SM RCS
file.
.SP
Note that if the software release that is being
.BR patch ed
is contained in more than one directory, then it may be necessary to
specify the
.B \-p
option to the
.BR patch (l)
command when patching the old sources, so that
.BR patch (l)
is able to find the files that are located in other directories.
.SP
If the
.B \-s
option is specified, a patch file is not produced.
Instead, a description of the changed or added files between the two
releases is sent to the standard output device.
This is useful for finding out, for example, which files have changed
between two dates or revisions.
.SP
If the
.B \-t
option is specified, a diff of the top two revisions is sent to the
standard output device.
This is most useful for seeing what the last change to a file was.
.TP
\fBtag\fP [\fB-Qqlfn\fP] [\fB-d\fP] [\fB-r\fP \fItag\fP|\fB-D\fP \fIdate_spec\fP] \fIsymbolic_tag\fP \fImodules...\fP
Sources in the repository can have a symbolic tag associated with them.
This allows one to ``snapshot'' the current sources when the software
freeze date of a project arrives, and as bugs are fixed after the freeze
date, only those changed sources that are to be part of the release need be
re-tagged.
.SP
The symbolic tags are meant to permanently record which revisions of which
files were used in creating a software distribution.
The functionality provided with the
.B checkout
and
.B update
commands allow one to extract an exact copy of this release at any time in
the future, regardless of whether files have been
.BR add ed
or
.BR remove d
since the release was
.BR tag ged.
So in general, these symbolic names of software distributions should not be
removed, but the
.B \-d
option is provided as a means to remove completely obsolete symbolic names
if necessary (as might be the case for an Alpha release, say).
It is also possible to only tag files that already contain a certain tag.
This method would be used to rename a tag \(em tag only the files with the
old tag, then delete the old tag leaving the new tag which would tag the
exact same files as the old tag.
.SH "COMMAND OPTIONS"
The following options are common to more than one of the
.B cvs
commands, and are explained in detail here once, for brevity.
.TP
.B \-Q
Causes the command to be
.I really
quiet.
.TP
.B \-q
Causes the command to be somewhat quiet.
.TP
.B \-l
Causes the command to not be recursive.
Only the specified directory will be processed.
.TP
.B \-f
Forces the specified tag to match.
Normally, when a tag is specified with the
.B \-r
option and the
.SM RCS
file does not contain the tag, the ``head'' revision for the
.SM RCS
file is returned.
When the
.B \-f
option is specified, any
.SM RCS
file that does not contain the specified tag is ignored.
This is useful for extracting an exact copy of a previously tagged release.
.TP
.B \-n
Causes the command
.I not
to run any
.BR checkout / commit / tag
program as specified in the modules database.
.TP
.B \-p
On
.BR checkout " or " update ,
prune directories that are empty after being updated.
This is useful for extracting an exact copy of a previously release,
especially when combined with the
.B \-f
option.
.TP
\fB-r\fP \fItag\fP
Causes the command to use the revision specified by the
.I tag
argument instead of the usual ``head'' revision.
The
.I tag
can be either a symbolic or numeric tag, in
.SM RCS
fashion,
except in the case of the
.B commit
command, in which case the
.I tag
must be a numeric one.
Specifying the
.B \-q
option along with the
.B \-r
option is often useful, to suppress the warning messages when the
.SM RCS
file does not contain the specified tag.
.TP
\fB-D\fP \fIdate_spec\fP
Causes the command to use the revision that was checked in at or before the
specified
.I date_spec
argument.
The
.I date_spec
is a single argument, free form date description specifying a date in the
past.
This option implies the
.B \-f
option.
See the
.SM "\fBEXAMPLES\fP"
section for useful examples of how the
.B \-D
option can be used.
.SH "CONFLICT RESOLUTION"
The algorithm used by
.BR checkout " and " update
is described in this section.
The output generated, unless the
.B \-Q
option is specified, consists of the following lines to describe exactly
how your private sources are being brought up-to-date with the
.SM RCS
source repository.
.TP
\fBU\fP \fIfile\fP
The specified file was copied directly out of its respective
.SM RCS
file from the source repository.
This is done because the condition of your user file matches one of the
following:
.in 1.5i
.ti -.5i
\(bu	The user file did not exist in your private sources, whether it was
because you removed it, or because someone added it to the source repository.
.ti -.5i
\(bu	The file did exist, but you did not change it and a different
revision was matched in the
.SM RCS
file, be it by the default ``head'' match, or via the
.B \-r
or
.B \-D
options.
.TP
\fBM\fP \fIfile\fP
The specified file has been modified locally by you.
Use the
.B diff
command to see the actual changes that you have made.
.TP
\fBA\fP \fIfile\fP
The specified file has been added to your private copy of the sources, and
will be added to the
.SM RCS
source repository when the file is
.BR commit ted.
This is a reminder to you that the file needs to be committed.
.TP
\fBR\fP \fIfile\fP
The specified file has been removed from your private copy of the sources, and
will be removed from the
.SM RCS
source repository when the file is
.BR commit ted.
This is a reminder to you that the file needs to be committed.
.TP
\fBC\fP \fIfiles\fP
The specified file was modified locally by you, and while doing the
.BR update ,
it was determined that a later revision had been checked into the respective
.SM RCS
file.
As a result,
.B cvs
performs an
.BR rcsmerge (l),
which combines the changes made to the
.SM RCS
file with the changes that you have made to your version of the file.
If there were any lines in conflict during the merge (i.e. the other
developer changed the same line that you have changed), then the
.B C
is displayed to show that the file must be manually corrected.
.SP
This merge process delimits the lines in conflict using lines beginning with
``>>>>>>>'' and ``<<<<<<<'', so it is easy to find the conflicts within
your merged file.
Note that your original, modified file is preserved in a backup file within
the same directory that the file existed.
The backup file has the form ``\fB.#\fP\fIfile\fP\fB.\fP\fIversion\fP'',
where the
.I version
is the
.SM RCS
revision that your modified file was based upon.
Note that some systems automatically purge files that begin with
.B .#
if they have not been accessed in roughly three days.
Thus, if you intend to keep a copy of your original file, I strongly
suggest that it be renamed.
.SP
If the merge process proceeded without any conflicts, an
.B M
is displayed instead of a
.BR C .
It is still a wise idea to
.BR diff (1)
the original version before the merge, contained in the backup file, with
the merged version to verify that the merged changes make sense with your
changes.
.SH "MODULE SUPPORT"
The
.BR checkout ", " patch ", and " tag
commands all accept
.I module
names as arguments.
The module database is stored as an
.BR ndbm (3)
format database within the
.SM CVSROOT.adm
directory of your
.SM CVSROOT
source repository.
The remainder of this section considers how the
.B checkout
command operates on the modules database.
The operations for the other commands that use the database are similar,
except that they do not create any files or directories in your work space, as
.B checkout
does.
.LP
The above commands search the module database for each module argument.
If the module database does not exist, or if the argument does not have a
matching key in the module database, the argument is processed as follows:
.TP
1.
The value of the
.SM CVSROOT
environment variable is prepended to the argument to form a full path name.
.TP
2.
If the full path name does not exist, either as a directory or as a file
with an
.SM RCS
.B ,v
extension, the argument module cannot be resolved and the command
continues, processing any remaining argument modules.
.TP
3.
If the full path name refers to a directory, the directories leading up to
the directory are created, starting from the current working directory, and
the directory is populated with the correct files, ready for your editing
satisfaction.
If available, and the
.B \-l
option was not specified, sub-directories are created and populated as
well, until the entire directory hierarchy of the specified module argument
is reconstructed in your work space.
.TP
4.
If the full path name, combined with an
.SM RCS
.B ,v
suffix exists, only that file is extracted.
The directories leading up to where the argument module resides are
created, if necessary, and the leaf directory is populated with the single
source file.
.LP
It should be clear from reading the above algorithm that the module
database is not required to extract or process whole directory hierarchies,
or even individual files.
However, the addition of the module database allows a high degree of
flexibility to be added to the structure or naming of pieces of software
within the
.SM CVSROOT
source hierarchy.
The easiest way to demonstrate the usefulness of the module database is by
example.
And so, one follows:
.LP
.RS
.ne 42
.nf
#
# Sample CVS Modules file
#
# Three different line formats are valid:
#	key     -a    aliases...
#	key [options] directory
#	key [options] directory files...
#
# Where "options" are composed of:
#	-i prog		Run "prog" on checkin of files
#	-o prog		Run "prog" on "checkout" of files
#	-t prog		Run "prog" on tagging of files
#

# Convenient aliases
world		-a .

# CVSROOT.adm support
CVSROOT	-i /usr/local/bin/mkmodules CVSROOT.adm
CVSROOT.adm	-i /usr/local/bin/mkmodules CVSROOT.adm
modules		-i /usr/local/bin/mkmodules CVSROOT.adm modules
loginfo		-i /usr/local/bin/mkmodules CVSROOT.adm loginfo

# The "sys" entry exists only to make symbolic links after checkout
sys		-o sys/tools/make_links sys

# Sub-directories of "bin"
awk		bin/awk
csh		bin/csh
diff		bin/diff
make		bin/make
sed		bin/sed
sh		bin/sh

# Programs that live in "bin"
cat		bin Makefile cat.c
chgrp		bin Makefile chgrp.c
chmod		bin Makefile chmod.c
cmp		bin Makefile cmp.c
cp		bin Makefile cp.c
date		bin Makefile date.c
dd		bin Makefile dd.c
.fi
.RE
.LP
The format of the
.I modules
file is also described in the above example.
The
.B \-a
option in the database indicates that the key is an alias, and that the
right-hand side of the alias is to be interpreted by the command
.I exactly
as if it had been specified as arguments on the command line for the command.
The
.B \-o
option indicates that the specified program is to be run on
.BR checkout .
The key for the entry is passed as the sole argument to the program.
The
.B \-i
option indicates that the specified program is to be run on
.BR commit .
The full pathname of the respective source repository directory
is passed as the sole argument to the program.
The
.B \-t
option indicates that the specified program is to be run on
.BR tag .
The key for the entry is passed as the sole argument to the program.
.LP
As an example, the command
.SP
.in +1i
.ft B
.nf
example% cvs checkout awk
.fi
.ft P
.in -1i
.SP
will create the ``awk'' directory in your current working directory, if
necessary, and populate it with the current revisions of the
files in the ``\c 
.SM $CVSROOT\c
/bin/awk'' directory.
The command
.SP
.in +1i
.ft B
.nf
example% cvs checkout date
.fi
.ft P
.in -1i
.SP
will create the ``date'' directory and populate with exactly the two files
``Makefile'' and ``date.c'' from the ``\c
.SM $CVSROOT\c
/bin/awk'' directory.
.SH "VENDOR BRANCH SUPPORT"
The branch support of
.SM RCS
is used to provide a convenient method of tracking the changes
made to a vendor's source distribution.
When a source distribution is received from a vendor, the first step is to
run the
.BR checkin (l)
program to place the vendor's files under
.SM CVS
control.
.BR checkin (l)
arranges that the
.SM RCS
files produced from the vendor's source distribution are initially setup to
track the 1.1.1 branch of the
.SM RCS
file.
When a
.B commit
is done to one of these files, making permanent some local change, the
.SM RCS
file is changed to track the normal ``trunk'' branch, continuing the local
changes to the vendor's sources.
.LP
When a new version of the vendor's source distribution is received,
.B checkin
is used again to add the new files to
.SM CVS.
.B checkin
again adds the files to the (now already existing) 1.1.1 branch of the
.SM RCS
file.
This time, however,
.B checkin
issues a warning when a new version of a locally modified file is updated
by the vendor's source distribution.
It is your responsibility to then use the
.B join
command of
.B cvs
to merge the vendor's changes with your local changes.
See the description of the
.B join
command above.
.LP
The
.B \-r
and
.B \-D
options of the
.B checkout
and
.B update
commands work ``as expected'' with the vendor branch support.
In particular, the
.B \-D
option to check out based on a date in the past follows the current default
branch to find a match for the specified date.
If a match cannot be found on the default branch, the 1.1.1 vendor
branch is searched.
This allows checking out based on a date to work regardless of when
local changes are made to the file.
.SH "LOGGING SUPPORT"
When
.BR commit ting
a change to the source repository, a configurable logging support file,
.IR loginfo ,
is consulted in the $\c
.SM CVSROOT\c
/\c
.SM CVSROOT.adm
directory.
An example of the file is as follows:
.LP
.RS
.ne 22
.nf
# The "loginfo" file is used to control where "cvs commit"
# log information is sent.  The first entry on a line is a
# regular expression which is tested against the directory
# that the change is being made to, relative to the
# $CVSROOT.  If a match is found, then the remainder of the
# line is a filter program that should expect log information
# on its standard input.
# 
# The filter program may use one and only one % modifier (ala
# printf).  If %s is specified in the filter program, a brief
# title is included (enclosed in single quotes) showing the
# modified file names.
# 
# If the repository name does not match any of the regular
# expressions in this file, the "DEFAULT" line is used, if it
# is specified.
# 
DEFAULT	/usr/local/bin/nfpipe -t %s utils.updates
^diag		/usr/local/bin/nfpipe -t %s diag.updates
^local		/usr/local/bin/nfpipe -t %s local.updates
^perf		/usr/local/bin/nfpipe -t %s perf.updates
^sys		/usr/local/bin/nfpipe -t %s kernel.updates
.fi
.RE
.LP
In addition, ``ALL'' can be specified as a special regular expression which
always matches, but does not change the behaviour of when the ``DEFAULT''
branch is taken.
All matches for the regular expression are executed.
This logging feature allows for multiple groups and logging programs to
share a single
.SM CVS
source repository.
.SH "EXAMPLES"
Using the example
.I modules
and
.I loginfo
files shown above, this section shows some sample commands and describes
their functions.
.SP
.in +1i
.ft B
.nf
example% cvs checkout csh
example% cd csh
example% make
.fi
.ft P
.in -1i
.SP
This command retrieves the current revision of the ``csh'' sources and
places them within the ``csh'' directory.
The ``make'' command within that directory will then build the ``csh''
executable.
.SP
.in +1i
.ft B
.nf
example% cvs checkout -rSunOS csh
example% cd csh
example% make
.fi
.ft P
.in -1i
.SP
These commands get the current SunOS revision of ``csh'' and builds the
executable.
.SP
.in +1i
.ft B
.nf
example% cvs checkout date
example% cd date
example% make date
.fi
.ft P
.in -1i
.SP
These commands checkout the current revision of the ``date'' command, along
with the Makefile that is required to build the ``date'' executable.
The ``make'' command includes the target ``date'', since this Makefile is
used to build much more than just ``date'' by default.
.SP
.in +1i
.ft B
.nf
example% cvs checkout -q sys
.fi
.ft P
.in -1i
.SP
Gets a copy of the current kernel sources, including the entire kernel
directory hierarchy.
The
.B \-q
option suppresses the message displayed as each directory is descended.
.SP
.in +1i
.ft B
.nf
example% cvs checkout -p -q -f -rSunOS sys
.fi
.ft P
.in -1i
.SP
Gets an
.I exact
copy of the current revision SunOS kernel sources.
The
.B \-f
option forces only files that have the ``SunOS'' tag to be retrieved, not
including files locally added to the kernel sources.
The
.B \-p
option prunes empty directories, thereby not including directories that
have been locally added to the kernel source hierarchy.
.SP
.in +1i
.ft B
.nf
example% cvs checkout -p -D 'August 10, 1989 14:40' sys
.fi
.ft P
.in -1i
.SP
The exact copy of the kernel sources as of the specified date and time is
retrieved.
The date is a free-form strings, as specified in
.BR rcs (l).
.SP
.in +1i
.ft B
.nf
example% cvs diff -c
example% cvs commit -a -m 'fixed NULL pointer dereference'
.fi
.ft P
.in -1i
.SP
The
.B diff
command displays a context diff of all the changes that you have made to
the sources within the current directory.
Only those files thaty you have changed are displayed.
The
.B commit
command makes these changes permanent within the source repository so that
others can benefit from your fix.
.SP
.in +1i
.ft B
.nf
example% cvs diff -c -rSunOS file.c
example% cvs diff -c -r1.9 -r1.11 file.c
example% cvs diff -c -r1.22 file.c
.fi
.ft P
.in -1i
.SP
Examples of how the
.B diff
command can be used.
The first example displays the differences between the SunOS version of the
file and your checked out version.
The second example shows the differences between two specific revisions of
the
.SM RCS
file.
The final example diffs the currently checked out file against a specific
revision of the
.SM RCS
file.
.SP
.in +1i
.ft B
.nf
example% cvs tag PrismaOS1_0 csh
example% cvs tag PrismaOS1_0 bin
example% cvs tag test_kernel sys
example% cvs tag -d test_kernel sys
example% cvs tag -q -f -rSunOS SUNOS .
example% cvs tag -D 'June 30, 1989' JUNE_KERNEL sys
.fi
.ft P
.in -1i
.SP

.SH "FILES"
.TP
CVS.adm
A directory created by the
.B checkout
command within each directory that contains checked out source files.
This directory holds all the
.B cvs
administration files for an individual's private copy of the sources.
In general, these files should not be edited by hand.
.B cvs
will do that for you.
Be sure to
.I never
remove this directory if you have source files that have been modified and
need to be committed in the directory that the
CVS.adm
directory administrates.
The files contained in this directory are described below.
.TP
CVS.adm/Entries
Contains the list of files that have been checked out in the current
directory along with the revision number that each checked out file is
up-to-date with and a timestamp that is used to quickly determine if a file
has been possibly modified or not.
.TP
CVS.adm/Entries.Backup
A backup of the previous
CVS.adm/Entries
file, just in case of catastrophe.
.TP
CVS.adm/Entries.Static
The existence of this file tells
.B cvs
to only use the files contained in the
CVS.adm/Entries
file when generating the list of source files for this directory.
This allows selected files from a directory in the source repository to be
checked out and manipulated without requiring that the entire source
directory be used.
.TP
CVS.adm/Mod
After doing an
.B update
command, this file reflects the current list of modified source files for
the directory.
.TP
CVS.adm/Repository
Holds the pathname to the respective directory in the source repository
that these files refer to.
This is usually a relative pathname, with the value of the
.SM CVSROOT
environment tacked on the front to produce a full pathname.
If the pathname in the
CVS.adm/Repository
file is already a full pathname, the
.SM CVSROOT
value is not tacked on.
.TP
CVS.adm/Checkin.prog
Contains one line which specifies the program that is to be run when any
files in the current directory are checked in to the source repository with the
.B commit
command.
The particular use of this is to rebuild the ``modules'' database after a
new revision is checked in \(em see
.BR mkmodules (l).
.LP
The following files or directories are created directly in the source
repository directories as needed.
.TP
CVSROOT.adm
A directory that should exist in the top-most directory as defined by the
.SM CVSROOT
environment variable.
This directory contains administrations files that define the global
actions for the entire source repository beginning at
.SM CVSROOT .
The files used directly by
.B cvs
in this directory are described below, though you are free to add others as
you see fit.
.TP
CVSROOT.adm/modules,v
The
.SM RCS
file which defines the
.I modules
supported within this source repository.
The format is as specified in the
.SM "\fBMODULE SUPPORT\fP"
section above for more information.
.TP
CVSROOT.adm/loginfo,v
The
.SM RCS
file that contains the descriptions of which programs to pipe log messages
into when
.BR commit ting
files.
See the
.SM "\fBLOGGING SUPPORT\fP"
section above for more information.
.TP
Attic
When
.SM RCS
files are removed with the
.B remove
command, the actual
.SM RCS
file is moved into the Attic directory where it will remain until someone
uses the
.B add
command to restore it as a needed source file.
.TP
#cvs.lock
A lock directory created by
.B cvs
when doing sensitive changes to the
.SM RCS
source repository.
.TP
#cvs.tfl.\fIpid\fP
A lock file created just to test the waters of the
.SM RCS
source repository directory before committing files.
.TP
#cvs.rfl.\fIpid\fP
A read lock created when doing the
.B update
command.
A
.B commit
done by some other user will wait until all readers have finished using the
directory before proceeding.
.TP
#cvs.wfl.\fIpid\fP
A write lock created by
.B commit
to cause any other
.BR update s
in the same source repository directory to block until the commit has
completed.
.SH "ENVIRONMENT VARIABLES"
.TP
.SM CVSROOT
Must be set for most commands.
Should contain the full pathname to the root of the
.B cvs
source repository, that is, where the
.SM RCS
files are kept.
.TP
.SM CVSREAD
If this is set,
.B checkout
and
.B update
will try hard to make your private checked out sources read-only.
When this is not set, the default behaviour is to make read-write files.
.TP
.SM RCSBIN
Specifies the full pathname where to find
.SM RCS
programs, such as
.BR co (l)
and
.BR ci (l).
If not set, the default is
.BR /usr/local/bin .
.TP
.SM EDITOR
Specifies the editor to use when doing a
.BR commit .
If not set, the default editor used is
.BR /usr/ucb/vi .
.SH "AUTHORS"
.TP
Dick Grune
Original author of the
.B cvs
shell script version posted to
.B comp.sources.unix
in the volume6 release of December, 1986.
Credited with much of the
.B cvs
conflict resolution algorithms.
.TP
Brian Berliner
Coder and designer of the
.B cvs
program itself in April, 1989, based on the original work done by Dick.
.TP
Jeff Polk
Helped Brian with the design of the
.B cvs
module and vendor branch support and author of the
.BR checkin (l)
shell script.
.SH "SEE ALSO"
.BR checkin (l),
.BR ci (l),
.BR co (l),
.BR diff (1),
.BR grep (1),
.BR mkmodules (l),
.BR ndbm (3),
.BR patch (l),
.BR rcs (l),
.BR rcsdiff (l),
.BR rcsmerge (l),
.BR rlog (l),
.BR rm (1),
.BR sort (1).
.SH "BUGS"
