/*
 * The combine utility is a product of Harris, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy, modify, license or distribute the combine utility without charge.
 * 
 * THE COMBINE UTILITY IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
 * PRACTICE.
 * 
 * The combine utility is provided with no support and without any obligation
 * on the part of Harris, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * HARRIS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THE COMBINE
 * UTILITY OR ANY PART THEREOF.
 * 
 * In no event will Harris, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Harris has been advised of the possibility of such damages.
 * 
 * Harris Computer Systems Division
 * 2101 W Cypress Creek Rd
 * Fort Lauderdale, Florida 33309
 */
/*
 * Type extensions and abbreviations This creates the HOS environment. Such
 * things as bit_type remain unexported.
 */

#define uint   unsigned int

#define ABS(x)   ( (x) >= 0 ? (x) : -(x) )
#define MOD(x,y) ( (x) % (y) )
#define mod(x,y) MOD(x,y)

#define  min(_a,_b) ( (_a) < (_b) ? (_a) : (_b) )
#define  max(_a,_b) ( (_a) > (_b) ? (_a) : (_b) )

#define NULLC     '\0'
#define NEWLINE   '\n'
#define NULL_PTR  0

#define bool int
#define TRUE 1
#define FALSE 0
/* All of the following macros deal with a doubly-linked list (dll).
 *
 * A 'dll' is a doubly-linked list of nodes, where one endof the list is
 * designated the "head" and the other endis designated the "tail". A 'dll'
 * is composed of a head pointer, a tail pointer, and zero or more nodes
 * each containing pointers to the next and previous nodes in the 'dll'. The
 * head pointer points to the first node in the 'dll' which is linked
 * through the "next" pointer fields in the nodes. The tail pointer points
 * to the last node in the 'dll' which is linked through the "previous"
 * pointer fields in the nodes. Each list is terminated by a NULL_PTR. If
 * either the "head" pointer or the "tail" pointer is a NULL_PTR, then the
 * 'dll' is empty.
 *
 * All of the macros share the following parameter definitons.
 *
 * Parameter definitions:
 * ----------------------
 *
 * _head_ptr  (input) node_type *
 *           The head pointer of the 'dll'.
 *
 * _tail_ptr  (input) node_type *
 *           The tail pointer of the 'dll'.
 *
 * _node_ptr  (input) node_type *
 *           The variable which points to the node the insert into the
 *	     'dll' or the variable to receive a pointer to the node removed from the
 *           'dll'. If the 'dll' is empty, then this variable is NULL_PTR.
 *
 * _next_ptr  (input) field_name_in_nd
 *           The name of the next pointer field in the node structure.
 *
 * _prev_ptr  (input) field_name_in_nd
 *           The name of the previous pointer field in the node structure.
 */

/*
 *
 *   deq_head_dll -- Remove a node from the front of a 'dll'.
 *
 */

#define deq_head_dll( _head_ptr, _tail_ptr, _node_ptr, _next_ptr, _prev_ptr ) \
 \
   (_node_ptr) = (_head_ptr) ; \
   if ( (_node_ptr) != NULL_PTR ) { \
      (_head_ptr) = (_node_ptr) -> _next_ptr ; \
      if ( (_head_ptr) == NULL_PTR ) { \
	 (_tail_ptr) = NULL_PTR ; \
      } else { \
	 (_head_ptr) -> _prev_ptr = NULL_PTR ; \
      } ; \
   }

/*
 *
 *   deq_tail_dll -- Remove a node from the tail of a 'dll'.
 *
 */

#define deq_tail_dll( _head_ptr, _tail_ptr, _node_ptr, _next_ptr, _prev_ptr ) \
 \
   (_node_ptr) = (_tail_ptr) ; \
   if ( (_node_ptr) != NULL_PTR ) { \
      (_tail_ptr) = (_node_ptr) -> _prev_ptr ; \
      if ( (_tail_ptr) == NULL_PTR ) { \
	 (_head_ptr) = NULL_PTR ; \
      } else { \
	 (_tail_ptr) -> _next_ptr = NULL_PTR ; \
      } ; \
   }

/*
 *
 *   enq_head_dll -- Add a node to the head of an 'dll'.
 *
 */

#define enq_head_dll( _head_ptr, _tail_ptr, _node_ptr, _next_ptr, _prev_ptr ) \
 \
   (_node_ptr) -> _prev_ptr = NULL_PTR ; \
   if ( _head_ptr == NULL_PTR ) { \
      _tail_ptr = (_node_ptr) ; \
      (_node_ptr) -> _next_ptr = NULL_PTR ; \
   } else { \
      (_node_ptr) -> _next_ptr = (_head_ptr) ; \
      (_head_ptr) -> _prev_ptr = (_node_ptr) ; \
   } ; \
   (_head_ptr) = (_node_ptr)

/*
 *
 *   enq_tail_dll -- Add a node to the tail of a 'dll'.
 *
 */

#define enq_tail_dll( _head_ptr, _tail_ptr, _node_ptr, _next_ptr, _prev_ptr ) \
 \
   if ( (_head_ptr) == NULL_PTR ) { \
      (_head_ptr) = (_tail_ptr) = (_node_ptr) ; \
      (_node_ptr) -> _next_ptr  = (_node_ptr) -> _prev_ptr = NULL_PTR ; \
   } else { \
      (_tail_ptr) -> _next_ptr = (_node_ptr) ; \
      (_node_ptr) -> _prev_ptr = (_tail_ptr) ; \
      (_tail_ptr)              = (_node_ptr) ; \
      (_node_ptr) -> _next_ptr = NULL_PTR ; \
   }

/*
 *
 *   rem_dll -- Remove a node from anywhere in a 'dll'.
 *
 */

#define rem_dll( _head_ptr, _tail_ptr, _node_ptr, _next_ptr, _prev_ptr ) \
 \
   if ( (_node_ptr) -> _prev_ptr == NULL_PTR ) { \
      (_head_ptr) = (_node_ptr) -> _next_ptr ; \
   } else { \
      (_node_ptr) -> _prev_ptr -> _next_ptr = (_node_ptr) -> _next_ptr ; \
   } ; \
 \
   if ( (_node_ptr) -> _next_ptr == NULL_PTR ) { \
      (_tail_ptr) = (_node_ptr) -> _prev_ptr ; \
   } else { \
      (_node_ptr) -> _next_ptr -> _prev_ptr = (_node_ptr) -> _prev_ptr ; \
   }
