/*
 * The combine utility is a product of Harris, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy, modify, license or distribute the combine utility without charge.
 * 
 * THE COMBINE UTILITY IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
 * PRACTICE.
 * 
 * The combine utility is provided with no support and without any obligation
 * on the part of Harris, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * HARRIS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THE COMBINE
 * UTILITY OR ANY PART THEREOF.
 * 
 * In no event will Harris, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Harris has been advised of the possibility of such damages.
 * 
 * Harris Computer Systems Division
 * 2101 W Cypress Creek Rd
 * Fort Lauderdale, Florida 33309
 */
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include "util.h"
#include "os_dep.h"
#include <stdio.h>
#include <ctype.h>

/*
 * os_dep_file_pos -- Return current position in file
 *
 * This routine returns the current position in the file. The value
 * returned is suitable for passing to os_dep_file_seek and is suitable
 * for no other purpose.
 *
 * Return value:
 *   Current position in the file.
 */
rfa_type os_dep_file_pos (fp)
FILE * fp;
{

	return (ftell (fp));
}
/*
 * os_dep_file_read -- Read a record from a file.
 *
 * This routine reads a record from a file.
 *
 * Return value:
 *   SS_NORMAL      Operation performed as requested.
 *   SS_EOT         End of disk area reached
 *   SS_READ_ERR    Error on read operation.
 *   SS_SEEK_ERR    Seek error occured
 *
 */

STS_type os_dep_file_read (fp,
	buf_ptr,
	buf_len,
	ret_len_ptr)
FILE * fp;
char   *buf_ptr;
int     buf_len;

int    *ret_len_ptr;	/* output */
 			/* Returns the number of bytes read. */
 			/* A value of -1 indicates that an EOF record was read */

{
	char    c;
	char   *char_ptr;
	STS_type status;
	int     i;


	if (TRUE) {

		char_ptr = fgets (buf_ptr, buf_len + 2, fp);
		/* printf( "(%d:%d) %s", buf_len, strlen( buf_ptr), buf_ptr ) ;
		*/

		if (char_ptr == NULL) {
			return (SS_EOT);
		}

		i = strlen (buf_ptr) - 1;
		if (buf_ptr[i] != '\n') {
			i++;
			for (;;) {
				c = getc (fp);
				if (feof (fp)) {
				/* not (c==EOF) because of binary files */
					break;
				} else if (c == '\n') {
					break;
				}
			}
		}
		*ret_len_ptr = i;
		buf_ptr[i] = '\0';

	} else {

		status = read (fileno (fp), buf_ptr, buf_len);
		if (status == (-1)) {
			return (SS_READ_ERR);
		}

	}

	return (SS_NORMAL);

}

/*
 *
 * os_dep_file_seek -- Seek to record within file
 *
 * This routine seek to a particular record within a file.
 *
 * Return value:
 *   SS_NORMAL      Operation performed as requested.
 *   SS_SEEK_ERR    Error on seek operation.
 *
 */

STS_type os_dep_file_seek (fp, rfa)
FILE * fp;
rfa_type rfa;

{

	STS_type status;



	status = fseek (fp, rfa, 0);

	if (status == -1) {
		return (SS_SEEK_ERR);
	} else {
		return (SS_NORMAL);
	}

}
/*
 *
 * os_dep_file_write -- Write a record to a file.
 *
 * This routine writes a record to a file.
 *
 * Return value:
 *   SS_NORMAL      Operation performed as requested.
 *   SS_WRITE_ERR   Error on write operation.
 *
 */

STS_type os_dep_file_write (fp,
	buf_ptr,
	buf_len)
FILE * fp;
char   *buf_ptr;
int     buf_len;		/* buffer length in bytes */

{



	buf_ptr[buf_len] = '\0';
	fputs (buf_ptr, fp);
	fputc ('\n', fp);
	return (SS_NORMAL);

}
