/*
 * The combine utility is a product of Harris, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy, modify, license or distribute the combine utility without charge.
 * 
 * THE COMBINE UTILITY IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
 * PRACTICE.
 * 
 * The combine utility is provided with no support and without any obligation
 * on the part of Harris, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * HARRIS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THE COMBINE
 * UTILITY OR ANY PART THEREOF.
 * 
 * In no event will Harris, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Harris has been advised of the possibility of such damages.
 * 
 * Harris Computer Systems Division
 * 2101 W Cypress Creek Rd
 * Fort Lauderdale, Florida 33309
 */
#include <stdio.h>
#include <ctype.h>
#include "util.h"
#include "os_dep.h"
/*
 * main: Main program for the COMBINE2 utility
 *
 * The COMBINE2 utility converts the 'HED' output file of the COMBINE
 * utility to be a standard symbolic file.
 *
 * Return value:
 *      This procedure has no return value.
 */
void main (argc, argv)
int     argc;			/* command line argument count */

char  **argv;			/* command line arguments */

{

	int     buf_len;	/* Actual number of characters in buffer */

	bool delete;		/* TRUE if currently deleteing lines */

	int     file_count;	/* Number of file arguments */

	int     i;		/* Misc. variable */

	FILE * in_file;		/* input file */

#define LINE_LENGTH 512
	char    mbuffer[LINE_LENGTH];/* Line buffer */

	FILE * out_file;	/* Output file */

	int     status;		/* Misc. status */

	extern  void error ();
#ifndef VOS
	extern int      errno;
#endif



	/*
	 * Handle each command line argument.
	 */
	in_file = stdin;
	out_file = stdout;

	file_count = 0;

	for (i = 1; i < argc; ++i) {

		/*
		 * Handle options arguments.
		 */
		if (argv[i][0] == '-' && argv[i][1] != '\0') {

			sprintf (mbuffer,
				"Unrecognized option '%s' specified", argv[i]);
			error (mbuffer);

#ifdef VOS

		/*
		 * Handle redirections of 'stdin':
		 *
		 * This code won't get executed on a UNIX O.S. However, on
		 * VOS this code allows the same syntax to work.
		 */
		} else if (argv[i][0] == '<' && argv[i][1] != '\0') {
			in_file = fopen (&argv[i][1], "r");

			if (in_file == 0) {
				perror( &argv[i][1]);
				exit(2);
			}

		/*
		 * Handle redirections of 'stdout':
		 *
		 * This code won't get executed on a UNIX O.S. However, on VOS this
		 * code allows the same syntax to work.
		 */

		} else if (argv[i][0] == '>' && argv[i][1] != '\0') {
			out_file = fopen (&argv[i][1], "w");

			if (out_file == 0) {
				perror( &argv[i][1] );
				exit( 2);
			}
#endif

		/*
		 * Handle file arguments not preceeded by a specific
		 * option argument.
		 */
		} else {

			if (file_count >= 2) {
				error ("Too many files specified");
			}

			if (file_count == 0) {
				in_file = fopen (argv[i], "r");

				if (in_file == 0) {
					perror(argv[i]);
					exit( 2 );
				}

			} else {

				out_file = fopen (argv[i], "w");

				if (out_file == 0) {
					perror(argv[i]);
					exit(2);
				}

			}

			file_count++;
		}
	}

	/*
	 * Read the next line of the file.
	 */
#ifdef VOS
	out_file -> carriage_control = FALSE;
#endif

	delete = FALSE;

	for (;;) {

		status = os_dep_file_read (in_file, mbuffer, LINE_LENGTH,
			&buf_len);

		if (status != SS_NORMAL) {
			if (status == SS_EOT) {
				exit (0);
			} else {
				perror( "input file" ) ;
				exit( 2 );
			}
		}

		if (buf_len > 0 && mbuffer[0] == '~') {

			if (buf_len > 1) {

				if (mbuffer[1] == '~') {

					if (buf_len > 2) {
						if (mbuffer[2] == 'I') {
							continue;
						} else if (mbuffer[2] == 'D') {
							delete = TRUE;
							continue;
						}
					}

				} else if (mbuffer[1] == 'E') {
					delete = FALSE;
					continue;
				}

			}

		}

		if (!delete) {
			status = os_dep_file_write (out_file, mbuffer, buf_len);

			if (status != SS_NORMAL) {
#ifdef VOS
				sprintf (mbuffer,
					"Write error on output file: %d\n",
					status);
				error (mbuffer);
#else
				perror( "output file" ) ;
#endif
			}
		}

	}

}
/*
 * error: output fatal error message
 *
 * This routine outputs an error message and terminates.
 *
 * Return value:
 *      This procedure has no return value.
 */
void error (error_ptr)
char   *error_ptr;		/* input -- Record to output. */

{

	fprintf (stderr, "combine2: %s.\n", error_ptr);
	exit (2);

}
