/*
**  Copyright 1989 BBN Systems and Technologies Corporation.
**  All Rights Reserved.
**  This is free software, and may be distributed under the terms of the
**  GNU Public License; see the file COPYING for more details.
**
**  Header file for CODA server.
**  $Header: server.h,v 2.0 90/03/23 14:42:01 rsalz Exp $
*/
/* SUPPRESS 223 *//* Nested comment */
#include <stdio.h>
#include <sys/types.h>


/*
**  Constants, compilation control, et cetera.
*/

/* Assorted constants. */
#define TRUE		1		/* Any non-zero value		*/
#define FALSE		0		/* Must be zero			*/
#define BADPARSE	1		/* Returned by YACC; must be 1	*/
#define SIZE		256		/* String buffer size		*/
#define MAXPATH		1024		/* Maximum pathname length	*/
#define HOST_DELTA	10		/* Clump for growing host array	*/
#define CLASS_DELTA	10		/* Clump for class arrays	*/
#define ITEM_DELTA	50		/* Clump for those other things	*/
#define SCAN_PING	200		/* How often to say we're alive	*/
#define FASTDEPTH	6		/* How far before closedir()?	*/
#define FW_NOFURTHER	1		/* FileWalker, go no further	*/
#define FW_PROCEED	2		/* FileWalker, keep going	*/
#define FW_EXIT		3		/* FileWalker, exit and pop up	*/

/* Compile in RCS id strings? */
#ifndef	SABER
#define RCSID
#endif	/* SABER */

/* Give up after this many seconds of inactivity. */
#define TIMEOUT		(30 * 60)

/* Default name of the log file. */
#define LOGFILE		"/usr/spool/log/codalog"

/* Default name of the file to read. */
#define CONTROLFILE	"Codafile"

/* Name of the built-in class that contains all hosts except UnknownHost. */
#define ALL		"_ALL"

/* Default name if host name isn't found. */
#define GUESTHOST	"_ANYHOST"

/* Return type of a signal-handling function. */
typedef int		CATCHER;	/* .. */
/* typedef void		CATCHER;	/* .. */

/* Hide routines that can be hidden? */
#define STATIC		static		/* .. */
/*efine STATIC		/* NULL */	/* .. */

#define WHITE(c)	((c) == ' ' || (c) == '\t')

/* Shut up, okay? */
#ifdef	lint
#undef putc
#undef putchar
#undef ungetc
#undef RCSID
#endif	/* lint */

/* Memory allocation. */
#define NEW(T, c)		\
	((T *)malloc((unsigned int)(sizeof (T) * (c))))
#define GROW(p, T, c)		\
	((T *)realloc((char *)p, (unsigned int)(sizeof (T) * (c))))
#define COPY(p)			\
	strcpy(NEW(char, strlen(p) + 1), p)

/* Fast front-end for string comparison. */
#define EQ(p, q)		\
	((p) == (q) || ((p)[0] == (q)[0] && strcmp((p), (q)) == 0))



/*
**  List of server commands.
*/
typedef enum _COMMAND {
    CMDgoto,
    CMDhelp,
    CMDhost,
    CMDlist,
    CMDmesg,
    CMDquit,
    CMDread,
    CMDroot,
    CMDsend,
    CMDuser,
    CMD_time
} COMMAND;


/*
**  Is it, or is it not?
*/
typedef int	BOOL;


/*
**  A linked list of strings.
*/
typedef struct _STRLIST {
    struct _STRLIST	*Next;
    char		*Value;
} STRLIST;


/*
**  An exception is a pattern for either files or a directory that is
**  valid for a class of hosts.
*/
typedef struct _EXCEPTION {
    struct _EXCEPTION	*Next;
    STRLIST		*Value;
    BOOL		Directory;
    char		*Class;
} EXCEPTION;


/*
**  A directory list is a linked list of pathnames and their exceptions.
*/
typedef struct _DIRLIST {
    struct _DIRLIST	*Next;
    char		*Value;
    BOOL		Directory;
    EXCEPTION		*Exceptions;
} DIRLIST;


/*
**  A block has a name, whether it is part of the default list, a list of
**  files, and a class that it is valid for.
*/
typedef struct _BLOCK {
    struct _BLOCK	*Next;
    char		*Name;
    BOOL		Excluded;
    DIRLIST		*Directories;
    char		*Class;
} BLOCK;


/*
**  An item is something that can be sent to a client.  It has permissions,
**  a modification time, and might be a directory.
*/
typedef struct _ITEM {
    char		*Name;
    int			Uid;
    int			Gid;
    BOOL		Directory;
    long		Size;
    time_t		Time;
    int			Mode;
} ITEM;


/*
**  Data is declared everywhere, lives oncewhere.
*/
#ifdef	MAINLINE
#define EXTERN		/* NULL */
#else
#define EXTERN		extern
#endif	/* MAINLINE */

EXTERN BLOCK	BaseBlock;		/* Chain of known blocks	*/
EXTERN BOOL	AllowBinaries;		/* Don't check for a.out files?	*/
EXTERN BOOL	Rooted;			/* Can client set the root?	*/
extern char	UnknownHost[];		/* Name of the unknown host	*/
extern char	*LogFile;		/* Name of the log file		*/
EXTERN char	*TheHost;		/* Host that called us		*/
EXTERN char	*TheRoot;		/* Root for relative pathnames	*/
EXTERN int	HaveErrors;		/* Failed to parse Codafile?	*/
EXTERN ITEM	*BaseItem;		/* Array of things to send	*/
EXTERN int	NumItem;		/* Size of said array		*/

/* Our routines. */
BLOCK		*FindBlock();
ITEM		*FindItem();
char		*strerror();
int		HostIsInClass();
int		yyopen();
int		yyparse();
void		Ack();
void		AddClassesToClass();
void		AddHostToClass();
void		AddItemToList();
void		Data();
void		DefineBlock();
void		DefineHost();
void		ListFiles();
void		LogClose();
void		LogOpen();
void		LogReadfile();
void		LogSentItem();
void		LogText();
void		Message();
void		Nack();
void		ResetItem();
void		ResetStorage();
void		SendFile();
void		SortItem();
void		Uppercase();
void		yyclose();
void		yyerror();

/* From the C library. */
extern int	errno;
extern int	optind;
extern time_t	time();
extern char	*optarg;
extern char	*bsearch();
extern char	*crypt();
extern char	*getwd();
extern char	*malloc();
extern char	*realloc();
extern char	*sprintf();		/* Too painful, my ass		*/
extern char	*strcat();
extern char	*strchr();
extern char	*strcpy();
extern char	*strncpy();
extern char	*strrchr();
