/*
**  Copyright 1989 BBN Systems and Technologies Corporation.
**  All Rights Reserved.
**  This is free software, and may be distributed under the terms of the
**  GNU Public License; see the file COPYING for more details.
**
**  Client library routines for an ATT3B2 with Wollongong TCP.
**  Client library routines for an ATT6386 with Interlan V.3 TCP.
*/
#include "client.h"
#ifdef	ATT3B2
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/in.h>
#endif	/* ATT3B2 */
#ifdef	ATTI386
#include <sys/types.h>
#include <sys/in.h>
#include <sys/socket.h>
#endif	/* ATTI386 */
#include <netdb.h>
#include <termio.h>
#ifdef	RCSID
static char	 RCS[] =
	"$Header: libatt.c,v 2.0 90/03/23 14:41:38 rsalz Exp $";
#endif	/* RCSID */


STATIC int	 Channel;		/* Something to talk with	*/


#ifdef	ATTI386
/*
**  Stupid Interlan software.  Why does their library need this routine,
**  yet not provide it?
*/
#include "alloca.inc"
#endif	/* ATTI386 */

/*
**  Do the grundge work of getting us a socket.
*/
STATIC int
GetSocket(machine, port)
    char		 *machine;
    int			  port;
{
    struct hostent	 *gethostbyname();
    REGISTER int	  s;
    struct hostent	 *hp;
    struct sockaddr_in	  sin;

    /* Get the address of the server. */
    if ((hp = gethostbyname(machine)) == NULL) {
	(void)fprintf(stderr, "%s: Unknown host.\n", machine);
	return -1;
    }

    /* Set up the socket. */
    (void)memset((char *)&sin, '\0', sizeof sin);
    sin.sin_family = AF_INET;
    sin.sin_port = htons(port);

    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("socket");
	return -1;
    }

    (void)memcpy((char *)&sin.sin_addr, hp->h_addr, hp->h_length);
    if (connect(s, (struct sockaddr *)&sin, sizeof sin) < 0) {
	perror("connect");
	(void)close(s);
	return -1;
    }

    return s;
}


/*
**  Open connection to server, return FALSE on error.
*/
int
SRVopen(machine, port)
    char	*machine;
    int		 port;
{
#ifdef	ATT3B2
#ifdef	lint
    /* Stupid SCCS strings in TWG library... */
    S_netdb = S_netdb;
    S_socket = S_socket;
    S_in = S_in;
#endif	/* lint */
#endif	/* ATT3B2 */
    return (Channel = GetSocket(machine, port)) >= 0;
}


/*
**  Send a QUIT and shut down.
*/
void
SRVclose()
{
    SRVput("QUIT");
    (void)close(Channel);
}


/*
**  Send a line to the server.
*/
void
SRVput(p)
    char	*p;
{
    if (SRVtrace)
	(void)printf(">>>%s\n", p);
    (void)write(Channel, p, (unsigned int)strlen(p));
    (void)write(Channel, "\r\n", 2);
}


/*
**  Get a line of text from the server.  Strip end-of-line characters.
*/
int
SRVget(buff, size)
    char		*buff;
    int			 size;
{
    REGISTER char	*p;
    REGISTER char	*bend;
    REGISTER int	 c;

    for (bend = &buff[size - 1]; ; ) {
	for (p = buff; ((c = SRVcget()) != '\n'); ) {
	    if (c == EOF)
		return FALSE;
	    if (c != '\r' && p < bend)
		*p++ = c;
	}
	*p = '\0';
	if (SRVtrace)
	    (void)printf("<<<%s\n", buff);
	if (strncmp(buff, "INF ", 4))
	    return TRUE;
	(void)printf("Server message:\n\t%s\n", &buff[4]);
	(void)fflush(stdout);
    }
}


/*
**  Get a character from the server.
*/
int
SRVcget()
{
    static char	 buff[1024];
    static int	 count;
    static int	 max;

    if (count == max) {
	while ((max = read(Channel, buff, sizeof buff)) == 0)
	    ;
	if (max < 0)
	    return EOF;
	if (max > sizeof buff)
	    (void)abort();
	count = 0;
    }
    return buff[count++];
}


/*
**  Get a password, without echoing it.
*/
void
GetPassword(buff, size)
    char		*buff;
    int			 size;
{
    struct termio	 Modes;
    char		*p;
    int			 ok;
    int			 flags;

    if (ok = ioctl(fileno(stdin), TCGETA, &Modes) >= 0) {
	flags = Modes.c_lflag;
	Modes.c_lflag &= ~(ECHO | ECHOE | ECHONL);
	(void)ioctl(fileno(stdin), TCSETA, &Modes);
    }

    if (fgets(buff, size, stdin) == NULL)
	Fatal("No password!?");
    if (p = strchr(buff, '\n'))
	*p = '\0';

    if (ok) {
	Modes.c_lflag = flags;
	(void)ioctl(fileno(stdin), TCSETA, &Modes);
	(void)printf("\n");
    }
}
