/*
**  Copyright 1989 BBN Systems and Technologies Corporation.
**  All Rights Reserved.
**  This is free software, and may be distributed under the terms of the
**  GNU Public License; see the file COPYING for more details.
**
**  Lexical analyzer for CODA server.
*/
%{
/* SUPPRESS 11 in yylook *//* Pointer subtraction */
/* SUPPRESS 14 on yycrank *//* Storing a bad pointer */
/* SUPPRESS 15 on yyt *//* Copying a bad pointer */
/* SUPPRESS 16 on yycrank *//* Initializing bad pointer */
/* SUPPRESS 18 in yylook *//* Comparing bad pointer */
/* SUPPRESS 287 on ncform_sccsid *//* Unused static variable */
/* SUPPRESS 288 on yyfussy *//* Unused label */
#include "server.h"
#include <ctype.h>
#include "gram.h"
#ifdef	RCSID
static char RCS[] =
	"$Header: lex.l,v 2.0 90/03/23 14:41:33 rsalz Exp $";
#endif	/* RCSID */


/* Key-value pair. */
typedef struct _PAIR {
    char	*name;
    int		value;
} PAIR;

/* List of the keywords. */
STATIC PAIR	Keywords[] = {
    {	"binaries",		BINARIES		},
    {	"class",		CLASS			},
    {	"define",		DEFINE			},
    {	"directory",		DIRECTORY		},
    {	"except",		EXCEPT			},
    {	"host",			HOST			},
    {	"only_explicitly",	ONLY_EXPLICITLY		},
    {	"root",			ROOT			},
    {	"rooted",		ROOTED			},
    {	NULL,			0			}
};

STATIC FILE	*F;			/* Input stream for LEX		*/

#undef input
#undef unput
%}

%%

[a-z_]+		{
		    /* A simple ID or keyword. */
		    register PAIR	*p;

		    for (p = Keywords; p->name; p++)
			if (EQ(p->name, yytext))
			    return p->value;
		    yylval.String = COPY(yytext);
		    return ID;
		    /* NOTREACHED */
		}

[a-zA-Z0-9./_]+	{
		    /* Most common filenames. */
		    yylval.String = COPY(yytext);
		    return ID;
		    /* NOTREACHED */
		}

[{},;:=]	{
		    /* Random special character. */
		    return *yytext;
		    /* NOTREACHED */
		}

[ \n\t\f]		{
		    /* Tasty whitespace. */
#ifdef	lint
		    /* I am compulsive about lint natterings, and probably
		     * know too much about the innards of LEX... */
		    yyin = yyin;
		    yytchar = yytchar;
		    yyoutput(yyinput());
		    yyunput(yyinput());
		    REJECT;
#endif	/* lint */
		}

\"[^"]*		{
		    /* Quoted string. */
		    int		c;

		    /* See the Lex paper in Volume 2A or PS1:16
		     * for details on this code. */
		    if (yytext[yyleng - 1] == '\\')
			yymore();
		    else {
			if ((c = input()) == '"') {
			    yylval.String = COPY(&yytext[1]);
			    return ID;
			}
			unput(c);
			yyerror("Bad string");
		    }
		}

#.*		{
		    /* Comment. */
		}


.		{
		    yyerror("Bad character");
		}
%%


/*
**  We found an error while parsing the file, report it.
*/
void
yyerror(text)
    char	*text;
{
    char	buff[SIZE];

    /* Truncate string to fit. */
    if (strlen(yytext) > SIZE / 2)
	(void)strcpy(&yytext[SIZE / 2], "...");
    (void)sprintf(buff, "ERROR %s near line %d (\"%s\").",
		    text, yylineno, yytext);
    Message(buff);
    HaveErrors = TRUE;
}


/*
**  Turn a string into all uppercase.
*/
void
Uppercase(p)
    register char	*p;
{
    for ( ; *p; p++)
	if (isascii(*p) && islower(*p))
	    *p = toupper(*p);
}



/*
**  Called by lex at end-of-stream.  Return one if no more input.
*/
STATIC int
yywrap()
{
    return 1;
}


/*
**  Our input routine.
*/
STATIC int
input()
{
    int		c;

    switch (c = getc(F)) {
    case EOF:
	return 0;
    case '\n':
	yylineno++;
	break;
    }
    return c;
}


/*
**  Our pushback routine.  If you have an input(), you gotta have an unput().
*/
STATIC int
unput(c)
    int		c;
{
    if (c == '\n')
	yylineno--;
    (void)ungetc(c, F);
}


/*
**  Open file for LEX input.
*/
int
yyopen(Checking, name)
    BOOL	Checking;
    char	*name;
{
    /* Open file.  The '-' is only when checking. */
    if (Checking && EQ(name, "-"))
	F = stdin;
    else if ((F = fopen(name, "r")) == NULL)
	return FALSE;

    /* Reset our state. */
    yylineno = 1;
    HaveErrors = FALSE;

    /* This is black magic to reset LEX, you might need it, might not.
     * Why isn't there a yyreset()?
    yysptr = yysbuf;
     */

    return TRUE;
}

void
yyclose()
{
    if (F) {
	(void)fclose(F);
	F = NULL;
    }
}
