/*
**  Copyright 1989 BBN Systems and Technologies Corporation.
**  All Rights Reserved.
**  This is free software, and may be distributed under the terms of the
**  GNU Public License; see the file COPYING for more details.
**
**  Header file for CODA clients.
**  $Header: client.h,v 2.0 90/03/23 14:41:08 rsalz Exp $
*/
/* SUPPRESS 223 *//* Nested comment */
#include <stdio.h>

#ifdef	XENIX
/* Stupid, just plain stupid... */
#undef	NULL
#define NULL		0
#endif	/* XENIX */

/*
**  Constants, compilation control, et cetera.
*/

/* Assorted constants. */
#define TRUE		1		/* Any non-zero value		*/
#define FALSE		0		/* Must be zero			*/
#define NOBODY		-2		/* NFS's idea of root		*/
#define PORTNUMBER	1999		/* Port to contact server on	*/
#define SIZE		256		/* String buffer size		*/
#define LINES_DELTA	50		/* Growth clump of line array	*/

/*
**  Set our exit codes; tell stupid VMS to shut up.  This goes away
**  when ANSI C comes along.
*/
#ifndef	VMS
#define CODA_INIT	"%s/.codarc"	/* Argument to %s is $HOME	*/
#define EXITOK		0
#define EXITERR		1
#else
#define CODA_INIT	"SYS$LOGIN:CODA.DAT"
#define EXITOK		0x10000001
#define EXITERR		0x10000002
#endif	/* VMS */

/* Comile in RCS id strings? */
#ifndef	SABER
#define RCSID
#endif	/* SABER */

/* Hide routines that can be hidden? */
#define STATIC		static		/* .. */
/*efine STATIC		/* NULL */	/* .. */

/* Trust register allocations? */
#define REGISTER	register	/* .. */
/*efine REGISTER	/* NULL */	/* .. */

/* Shut up, okay? */
#ifdef	lint
#undef putc
#undef putchar
#undef RCSID
#endif	/* lint */

/* Memory allocation. */
#define NEW(T, c)		\
	((T *)malloc((unsigned int)(sizeof (T) * (c))))
#define GROW(p, T, c)		\
	((T *)realloc((char *)p, (unsigned int)(sizeof (T) * (c))))
#define COPY(p)			\
	strcpy(NEW(char, strlen(p) + 1), p)

#define WHITE(c)		((c) == ' ' || c == '\t')

typedef int		BOOL;



/*
**  Data is declared everywhere, lives oncewhere.
*/
#ifdef	MAINLINE
#define EXTERN		/* NULL */
#else
#define EXTERN		extern
#endif	/* MAINLINE */

EXTERN int	SRVtrace;		/* Trace server IO?		*/

void	Fatal();
void	GetPassword();
int	SRVcget();
int	SRVget();
int	SRVopen();
void	SRVclose();
void	SRVput();

/* From the C library. */
extern int	errno;
extern int	optind;
extern char	*optarg;

extern long	atol();
extern char	*getenv();
extern char	*malloc();
extern char	*mktemp();
extern char	*realloc();
extern char	*strchr();
extern char	*strrchr();
extern char	*strcpy();

#ifdef	BSD
extern char	*sprintf();		/* Too painful, my ass		*/
#endif	/* BSD */

#ifdef	ATTsysv
extern void	exit();
extern void	perror();
extern char	*memset();
extern char	*memcpy();
#endif	/* ATTsysv */
