/*
**  This file is in the public domain.
**
**  This is a hacked-over and reformatted version of the public domain
**  alloca routine written by Doug Gwyn <gwyn@brl.mil> for which I am
**  very grateful.
*/
#ifdef	RCSID
static char RCS2[] =
	"$Header: alloca.inc,v 2.0 90/03/23 14:41:01 rsalz Exp $";
#endif	/* RCSID */


#define ALIGN_SIZE	(sizeof (double))

typedef union _HEADER {
    char	align[ALIGN_SIZE];
    struct {
	union _HEADER	*Next;
	char		*Depth;
    }		h;
} HEADER;


/*
**  Recurse once and compare the address of local variables to see
**  which way the stack grows.
*/
static int
FindDirection()
{
    static char	*addr;
    auto char	dummy;

    if (addr == NULL) {
	addr = &dummy;
	return FindDirection();
    }
    return &dummy > addr ? 1 : -1;
}


char *
alloca(size)
    unsigned int	size;
{
    static HEADER	*AllocationList;
    static int		Direction;
    register char	*Depth;
    register HEADER	*hp;
    register HEADER	*Next;
    auto char		probe;

    if (Direction == 0)
	Direction = FindDirection();

    /* Reclaim garbage, which is defined as all alloca()'d storage
     * that was allocated deeper in the stack than we are now. */
    for (Depth = &probe, hp = AllocationList; hp; )
	if (Direction > 0 && hp->h.Depth > Depth
	 || Direction < 0 && hp->h.Depth < Depth) {
	    Next = hp->h.Next;
	    free((char *)hp);
	    hp = Next;
	}
	else
	    break;
    AllocationList = hp;

    if (size == 0
     || (hp = (HEADER *)malloc(sizeof (HEADER) + size)) == NULL)
	return NULL;

    hp->h.Next = AllocationList;
    hp->h.Depth = Depth;
    AllocationList = hp;
    return (char *)(hp + 1);
}
