/*
**  Copyright 1989 BBN Systems and Technologies Corporation.
**  All Rights Reserved.
**  This is free software, and may be distributed under the terms of the
**  GNU Public License; see the file COPYING for more details.
**
**  Logging routines for CODA server.
*/
#include "server.h"
#include <time.h>
#ifdef	RCSID
static char RCS[] =
	"$Header: log.c,v 2.0 90/03/23 14:41:50 rsalz Exp $";
#endif	/* RCSID */


STATIC int	 PID;			/* Our process ID		*/
STATIC int	 Sequence;		/* Log message sequence number	*/
STATIC char	*LogTerm = "\n";	/* Message terminator		*/
STATIC FILE	*Log;			/* Logfile stream		*/


STATIC char *
TimeString()
{
    time_t	 now;
    char	*p;

    (void)time(&now);
    p = ctime(&now);
    /* Kill the newline, skip the day. */
    p[24] = '\0';
    return p + 4;
}


void
LogOpen()
{
    PID = getpid();
    Sequence = 0;

    /* Open a log file somewhere. */
    if (EQ(LogFile, "-"))
	Log = stdout;
    else if ((Log = fopen(LogFile, "a")) == NULL) {
	if (Log = fopen("/dev/console", "w"))
	    LogTerm = "\r\n";
	else if ((Log = fopen("/dev/null", "w")) == NULL) {
	    perror("Can't open any logfiles");
	    abort();
	}
    }

    (void)fprintf(Log, "%d %d %s StartedWith %s%s",
		    PID, Sequence++, TimeString(),
		    TheHost,
		    LogTerm);
    (void)fflush(Log);
}


void
LogClose(p)
    char	*p;
{
    (void)fprintf(Log, "%d %d %s Exit %s%s",
		    PID, Sequence++, TimeString(),
		    p,
		    LogTerm);
    (void)fflush(Log);
}


void
LogText(p)
    char	*p;
{
    (void)fprintf(Log, "%d %d %s Message %s%s",
		    PID, Sequence++, TimeString(),
		    p,
		    LogTerm);
    (void)fflush(Log);
}


void
LogReadfile(p)
    char	*p;
{
    char	 buff[SIZE * 2];

    (void)fprintf(Log, "%d %d %s Readfile %s %s%s",
		    PID, Sequence++, TimeString(),
		    p, getwd(buff),
		    LogTerm);
    (void)fflush(Log);
}


#ifdef	VERBOSE_LOG
void
LogSentItem(I)
    ITEM	*I;
{
    (void)fprintf(Log, "%d %d %s Sentitem %s%s%s",
		    PID, Sequence++, TimeString(),
		    I->Name[0] == '/' ? "" : TheRoot,
		    I->Name,
		    LogTerm);
    (void)fflush(Log);
}
#endif	/* VERBOSE_LOG */
