/*
**  Copyright 1989 BBN Systems and Technologies Corporation.
**  All Rights Reserved.
**  This is free software, and may be distributed under the terms of the
**  GNU Public License; see the file COPYING for more details.
**
**  Client library routines for XENIX with Excelan TCP.
*/
#include "client.h"
#include <sys/types.h>
#include <sgtty.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef	RCSID
static char	 RCS[] =
	"$Header: libxen.c,v 2.0 90/03/23 14:41:47 rsalz Exp $";
#endif	/* RCSID */


STATIC FILE	*WriteStream;		/* Something to write to	*/
STATIC FILE	*ReadStream;		/* Something to read from	*/


/*
**  Make a directory.
*/
int
mkdir(dir, mode)
    char	*dir;
    int		 mode;
{
    char	buff[SIZE];

    (void)sprintf(buff, "exec mkdir %s\n", dir);
    if (system(buff))
	return -1;
    (void)sprintf(buff, "exec chmod %d %s", mode, dir);
    return system(buff) ? -1 : 0;
}


/*
**  Rename a file.
*/
int
rename(from, to)
    char	*from;
    char	*to;
{
    (void)unlink(to);
    return link(from, to) < 0 ? -1 : unlink(from);
}


/*
**  Do the grundge work of getting us a socket.
*/
STATIC int
GetSocket(machine, port)
    char		 *machine;
    int			  port;
{
    REGISTER int	  s;
    struct hostent	 *hp;
    struct sockaddr_in	  sin;

    /* Set up the socket. */
    (void)memset((char *)&sin, '\0', sizeof sin);
    sin.sin_family = AF_INET;
    sin.sin_port = htons(port);
    if ((s = socket(SOCK_STREAM, (struct sockproto *)NULL, &sin, 0)) < 0) {
	experror("socket");
	return -1;
    }

    /* Get the address of the server. */
    if ((hp = gethostbyname(machine)) == NULL) {
	(void)fprintf(stderr, "%s: Unknown host.\n", machine);
	return -1;
    }
    (void)memcpy((char *)&sin.sin_addr, hp->h_addr, hp->h_length);

    /* Connect to the server. */
    if (connect(s, (struct sockaddr *)&sin) < 0) {
	experror("connect");
	(void)close(s);
	return -1;
    }

    return s;
}


/*
**  Open connection to server, return FALSE on error.
*/
int
SRVopen(machine, port)
    char	*machine;
    int		 port;
{
    int		 i;

    if ((i = GetSocket(machine, port)) < 0)
	return FALSE;

    if ((ReadStream = fdopen(i, "r")) == NULL) {
	perror("OpenServerChannel: fdopen #1");
	return FALSE;
    }

    if ((i = dup(i)) < 0) {
	perror("OpenServerChannel: dup");
	return FALSE;
    }
    if ((WriteStream = fdopen(i, "w")) == NULL) {
	perror("OpenServerChannel: fdopen #2");
	(void)fclose(ReadStream);
	return FALSE;
    }
    return TRUE;
}


/*
**  Send a QUIT and shut down.
*/
void
SRVclose()
{
    if (WriteStream == NULL || ReadStream == NULL)
	return;

    SRVput("QUIT");
    (void)fclose(WriteStream);
    (void)fclose(ReadStream);
}


/*
**  Send a line to the server.
*/
void
SRVput(p)
    char	*p;
{
    if (SRVtrace)
	(void)printf(">>>%s\n", p);
    (void)fprintf(WriteStream, "%s\r\n", p);
    (void)fflush(WriteStream);
}


/*
**  Get a line of text from the server.  Strip end-of-line characters.
*/
int
SRVget(buff, size)
    char		*buff;
    int			 size;
{
    REGISTER char	*p;

    while (fgets(buff, size, ReadStream)) {
	if ((p = strchr(buff, '\r')) || (p = strchr(buff, '\n')))
	    *p = '\0';
	if (SRVtrace)
	    (void)printf("<<<%s\n", buff);
	if (strncmp(buff, "INF ", 4))
	    return TRUE;
	(void)printf("Server message:\n\t%s\n", &buff[4]);
	(void)fflush(stdout);
    }
    return FALSE;
}


/*
**  Get a character from the server.
*/
int
SRVcget()
{
    return getc(ReadStream);
}


/*
**  Get a password, without echoing it.
*/
void
GetPassword(buff, size)
    char		*buff;
    int			 size;
{
    struct sgttyb	 Modes;
    char		*p;
    int			 ok;
    int			 flags;

    if (ok = ioctl(fileno(stdin), TIOCGETP, &Modes) >= 0) {
	flags = Modes.sg_flags;
	Modes.sg_flags &= ~ECHO;
	(void)ioctl(fileno(stdin), TIOCSETP, &Modes);
    }

    if (fgets(buff, size, stdin) == NULL)
	Fatal("No password!?");
    if (p = strchr(buff, '\n'))
	*p = '\0';

    if (ok) {
	Modes.sg_flags = flags;
	(void)ioctl(fileno(stdin), TIOCSETP, &Modes);
	(void)printf("\n");
    }
}
