/*
**  Copyright 1989 BBN Systems and Technologies Corporation.
**  All Rights Reserved.
**  This is free software, and may be distributed under the terms of the
**  GNU Public License; see the file COPYING for more details.
**
**  Client library routines for BSD-derived systems.
*/
#include "client.h"
#include <sys/types.h>
#include <sgtty.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef	RCSID
static char	 RCS[] =
	"$Header: libbsd.c,v 2.0 90/03/23 14:41:41 rsalz Exp $";
#endif	/* RCSID */


STATIC FILE	*WriteStream;		/* Something to write to	*/
STATIC FILE	*ReadStream;		/* Something to read from	*/


/*
**  Do the grundge work of getting us a socket.  Thanks to the NNTP folks
**  for the trick of using h_addr to see if we're running with a 4.3
**  multiple address netdb, or a 4.2 single address netdb.
*/
STATIC int
GetSocket(machine, port)
    char		 *machine;
    int			  port;
{
    struct hostent	 *gethostbyname();
#ifdef	h_addr
    REGISTER char	**addr;
#endif	/* h_addr */
    REGISTER int	  s;
    struct hostent	 *hp;
    struct sockaddr_in	  sin;

    /* Get the address of the server. */
    if ((hp = gethostbyname(machine)) == NULL) {
	(void)fprintf(stderr, "%s: Unknown host.\n", machine);
	return -1;
    }

    /* Set up the socket. */
    bzero((char *)&sin, sizeof sin);
    sin.sin_family = AF_INET;
    sin.sin_port = htons((unsigned short)port);

#ifdef	h_addr
    /* get a socket and initiate connection -- use multiple addresses */
    for (addr = hp->h_addr_list; addr && *addr; addr++) {
	if ((s = socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0) {
	    perror("socket");
	    return -1;
	}
	    
	bcopy(*addr, (char *)&sin.sin_addr, hp->h_length);
	if (connect(s, (struct sockaddr *)&sin, sizeof sin) == 0)
	    break;
	(void)close(s);
    }
    if (addr == NULL || *addr == '\0') {
	perror("no connection possible");
	return -1;
    }
#else
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("socket");
	return -1;
    }

    bcopy(hp->h_addr, (char *)&sin.sin_addr, hp->h_length);
    if (connect(s, (struct sockaddr *)&sin, sizeof sin) < 0) {
	perror("connect");
	(void)close(s);
	return -1;
    }
#endif	/* h_addr */

    return s;
}


/*
**  Open connection to server, return FALSE on error.
*/
int
SRVopen(machine, port)
    char	*machine;
    int		 port;
{
    int		 i;

    if ((i = GetSocket(machine, port)) < 0)
	return FALSE;

    if ((ReadStream = fdopen(i, "r")) == NULL) {
	perror("OpenServerChannel: fdopen #1");
	return FALSE;
    }

    if ((i = dup(i)) < 0) {
	perror("OpenServerChannel: dup");
	return FALSE;
    }
    if ((WriteStream = fdopen(i, "w")) == NULL) {
	perror("OpenServerChannel: fdopen #2");
	(void)fclose(ReadStream);
	return FALSE;
    }
    return TRUE;
}


/*
**  Send a QUIT and shut down.
*/
void
SRVclose()
{
    if (WriteStream == NULL || ReadStream == NULL)
	return;

    SRVput("QUIT");
    (void)fclose(WriteStream);
    (void)fclose(ReadStream);
}


/*
**  Send a line to the server.
*/
void
SRVput(p)
    char	*p;
{
    if (SRVtrace)
	(void)printf(">>>%s\n", p);
    (void)fprintf(WriteStream, "%s\r\n", p);
    (void)fflush(WriteStream);
}


/*
**  Get a line of text from the server.  Strip end-of-line characters.
*/
int
SRVget(buff, size)
    char		*buff;
    int			 size;
{
    REGISTER char	*p;

    while (fgets(buff, size, ReadStream)) {
	if ((p = strchr(buff, '\r')) || (p = strchr(buff, '\n')))
	    *p = '\0';
	if (SRVtrace)
	    (void)printf("<<<%s\n", buff);
	if (strncmp(buff, "INF ", 4))
	    return TRUE;
	(void)printf("Server message:\n\t%s\n", &buff[4]);
	(void)fflush(stdout);
    }
    return FALSE;
}


/*
**  Get a character from the server.
*/
int
SRVcget()
{
    return getc(ReadStream);
}


/*
**  Get a password, without echoing it.
*/
void
GetPassword(buff, size)
    char		*buff;
    int			 size;
{
    struct sgttyb	 Modes;
    char		*p;
    int			 ok;
    int			 flags;

    if (ok = ioctl(fileno(stdin), TIOCGETP, &Modes) >= 0) {
	flags = Modes.sg_flags;
	Modes.sg_flags &= ~ECHO;
	(void)ioctl(fileno(stdin), TIOCSETP, &Modes);
    }

    if (fgets(buff, size, stdin) == NULL)
	Fatal("No password!?");
    if (p = strchr(buff, '\n'))
	*p = '\0';

    if (ok) {
	Modes.sg_flags = flags;
	(void)ioctl(fileno(stdin), TIOCSETP, &Modes);
	(void)printf("\n");
    }
}
