/*
**  Copyright 1989 BBN Systems and Technologies Corporation.
**  All Rights Reserved.
**  This is free software, and may be distributed under the terms of the
**  GNU Public License; see the file COPYING for more details.
**
**  Control file parser for CODA server.
*/
%{
/* SUPPRESS 287 on yaccpar_sccsid *//* Unused static variable */
/* SUPPRESS 288 on yyerrlab *//* Unused label */
#include "server.h"
#ifdef	RCSID
static char RCS[] =
	"$Header: gram.y,v 2.0 90/03/23 14:41:27 rsalz Exp $";
#endif	/* RCSID */
%}

%union {
    BOOL	Boolean;
    char	*String;
    STRLIST	*Slist;
    EXCEPTION	*Elist;
    DIRLIST	*Flist;
};

%token	BINARIES CLASS DEFINE DIRECTORY EXCEPT HOST ID ONLY_EXPLICITLY
%token	ROOT ROOTED

%type	<Boolean>	opt_dir opt_exp
%type	<String>	ID
%type	<Elist>		elist
%type	<Flist>		flist
%type	<Slist>		slist

%%

file	: line
	| line file
	;

line	: DEFINE ROOT '=' ID ';' { 
	    if (TheRoot)
		free(TheRoot);
	    TheRoot = $4;
	}
	| DEFINE BINARIES '=' ID ';' {
	    AllowBinaries = $4[0] == 'Y' || $4[0] == 'y';
	}
	| DEFINE ROOTED '=' ID ';' {
	    Rooted = $4[0] == 'Y' || $4[0] == 'y';
	}
	| CLASS ID '=' slist ';' {
	    AddClassesToClass($2, $4);
	}
	| HOST ID '=' ID ';' {
	    Uppercase($2);
	    DefineHost($2, $4);
	}
	| opt_exp ID ':' ID '{' flist '}' {
	    BLOCK	*B;

	    if (FindBlock($2) != NULL)
		yyerror("Block redefined");
	    else {
		B = NEW(BLOCK, 1);
		B->Excluded = $1;
		B->Name = $2;
		B->Class = $4;
		B->Directories = $6;
		B->Next = BaseBlock.Next;
		BaseBlock.Next = B;
	    }
	}
	| error ';' {
#ifdef	lint
	    /* I am compulsive about lint, and probably know too much
	     * about the way Yacc works... */
	    YYERROR;
#endif	/* lint */
	}
	;

opt_exp	: ONLY_EXPLICITLY {
	    $$ = TRUE;
	}
	| /* NULL */ {
	    $$ = FALSE;
	}
	;

flist	: /* NULL */ {
	    $$ = NULL;
	}
	| opt_dir ID elist flist {
	    $$ = NEW(DIRLIST, 1);
	    $$->Directory = $1;
	    $$->Value = $2;
	    $$->Exceptions = $3;
	    $$->Next = $4;
	}
	;

opt_dir	: DIRECTORY {
	    $$ = TRUE;
	}
	| /* NULL */ {
	    $$ = FALSE;
	}
	;

elist	: /* NULL */ {
	    $$ = NULL;
	}
	| EXCEPT opt_dir ID slist ';' elist {
	    STRLIST	*S;

	    /* Make sure the user isn't confused. */
	    for (S = $4; S; S = S->Next)
		if (*S->Value != '^' && strchr(S->Value, '/'))
		    yyerror("Illegal character (\"/\") in exception");

	    $$ = NEW(EXCEPTION, 1);
	    $$->Directory = $2;
	    $$->Class = $3;
	    $$->Value = $4;
	    $$->Next = $6;
	}
	;

slist	: ID {
	    $$ = NEW(STRLIST, 1);
	    $$->Value = $1;
	    $$->Next = NULL;
	}
	| ID ',' slist {
	    $$ = NEW(STRLIST, 1);
	    $$->Value = $1;
	    $$->Next = $3;
	}
	;

%%
