#ifndef lint
static char *sccsid = "@(#)chtim.c	1.2 (Don Gworek) 8/10/85";
#endif

/* 
 * chtim [-sR] [-p proto-file] [-am "date" or seconds] files ... 
 *
 * Change or report file time stamps
 *
 * -s report in shell script/archive format
 * -R recursive for directories
 * -p put the proto-file's time stamps on the following files
 * -a set access time stamp
 * -m set modification time stamp
 *
 * Default: report time stamps for the files
 *
 * unctime() routines borrowed from Berkeley dump(8)
 * Recusion based on Berkeley 4.3 chmod(1) and ls(1)
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/dir.h>

#define TRUE 1
#define FALSE 0
#define ARGVAL() (*++(*argv) || (--argc && *++argv))

int     scriptf = FALSE;
int     Recursf = FALSE;
int     protof = FALSE;
int     accessf = FALSE;
int     modif = FALSE;

int     status = 0;
int     argc;
char  **argv;
long    now;
char    nowyear[5];
char	command[1024];

struct tm  *localtime ();
struct timeval  newtime[2];
struct stat stbuf;

static char months[12][4] = {
    "jan", "feb", "mar", "apr", "may", "jun",
    "jul", "aug", "sep", "oct", "nov", "dec"
};

main (ARGC, ARGV)
int     ARGC;
char   *ARGV[];
{
    char   *s;
    argc = ARGC;
    argv = ARGV;
    (void) strcpy (command, *argv);
    (void) time (&now);
    s = (char *) ctime (&now);
    (void) sprintf (nowyear, "%.4s", (s + 20));
    newtime[0].tv_sec = newtime[1].tv_sec = 0;
    getoptions ();
    if (argc <= 0)
	usage ();
    for (; --argc >= 0; argv++)
	chtim (*argv);
    exit (status);
}

getoptions () {
    while (--argc > 0)
	if (**(++argv) != '-')
	    return;
	else
	    switch (*++(*argv)) {
		case '\0': 
		    return;
		case 'p': 
		    if (!ARGVAL ())
			usage ();
		    if (stat (*argv, &stbuf) == -1) {
			perror (*argv);
			exit (1);
		    }
		    newtime[0].tv_sec = stbuf.st_atime;
		    newtime[1].tv_sec = stbuf.st_mtime;
		    protof = TRUE;
		    break;
		case 'a': 
		    extract_time (0);
		    break;
		case 'm': 
		    extract_time (1);
		    break;
		default: 
		    for (; **argv != '\0'; *(*argv)++)
			switch (**argv) {
			    case 's': 
				scriptf = TRUE;
				break;
			    case 'R': 
				Recursf = TRUE;
				break;
			    default: 
				usage ();
			}
	    }
}

extract_time (option)
int     option;
{
    int     a, m;
    a = m = FALSE;
    for (;; *++(*argv))
	switch (**argv) {
	    case '\0': 
		if (--argc && *++argv)
		    goto set;
		else
		    usage ();
		break;
	    case 'a': 
		a = accessf = TRUE;
		break;
	    case 'm': 
		m = modif = TRUE;
		break;
	    default: 
		goto set;
	}
set: 
    if (!isdigit (**argv)) {
	if ((newtime[option].tv_sec = unctime (*argv)) < 0)
	    usage ();
    }
    else
	newtime[option].tv_sec = atol (*argv);
    if (a)
	newtime[0].tv_sec = newtime[option].tv_sec;
    if (m)
	newtime[1].tv_sec = newtime[option].tv_sec;
}

chtim (fname)
char   *fname;
{
    struct stat stb;
    if (stat (fname, &stb) == -1) {
	perror (fname);
	status++;
	return;
    }
    if (Recursf && stb.st_mode & S_IFDIR)
	status += chtimr (fname);
    if (newtime[0].tv_sec || newtime[1].tv_sec) {
	if (accessf && !modif)
	    newtime[1].tv_sec = stb.st_mtime;/* preserve m value */
	else
	    if (modif && !accessf)
		newtime[0].tv_sec = stb.st_atime;/* preserve a value */

	if (utimes (fname, newtime) != 0) {
	    status++;
	    perror (fname);
	}
    }
    else
	if (scriptf) {
	    if (stb.st_atime == stb.st_mtime)
		printf ("%s -am %d", command,  stb.st_atime);
	    else
		printf ("%s -a %d -m %d", command,  stb.st_atime, stb.st_mtime);
	    printf (" %s\n", fname);
	}
	else {
	    printf ("%s\n", fname);
	    print_time ("a", stb.st_atime);
	    print_time ("m", stb.st_mtime);
	    print_time ("c", stb.st_ctime);
	}
}

chtimr (dir)
char   *dir;
{
    register    DIR * dirp;
    register struct direct *dp;
    char    dirfile[1024];
    if ((dirp = opendir (dir)) == NULL) {
	perror (dir);
	return (1);
    }
    dp = readdir (dirp);
    dp = readdir (dirp);	/* read "." and ".." */
    for (dp = readdir (dirp); dp != NULL; dp = readdir (dirp)) {
	(void) sprintf (dirfile, "%s/%s", dir, dp -> d_name);
	chtim (dirfile);
    }
    closedir (dirp);
    return (0);
}

print_time (label, t)
char   *label;
long    t;
{
    char   *s;
    s = (char *) ctime (&t);
    if (strncmp ((s + 20), nowyear, 4))
	printf ("\t%s %-13.12s%-5.4s(%d)\n", label, (s + 4), (s + 20), t);
    else
	printf ("\t%s %-18.15s(%d)\n", label, (s + 4), t);
}

char   *
        substring (str, substr)
char   *str, *substr;
{
    while (isspace (*str) && (*str != '\0'))
	str++;
    while (!isspace (*str) && (*str != '\0'))
	*substr++ = *str++;
    *substr = '\0';
    return (str);
}

/*
 * Convert a date to seconds since Jan 1, 1970.  If an error, return -1.
 */
time_t
unctime (str)
char   *str;
{
    struct tm   tm;
    time_t emitl ();
    char   *s, word[30], *substring ();
    if (strlen (str) >= 30)
	return (-1);

    str = substring (str, word);/* extract month number */
    if ((tm.tm_mon = get_month (word)) < 0)
	return (-1);

    str = substring (str, word);/* extract day */
    tm.tm_mday = atoi (word);

    str = substring (str, word);/* extract time */
    tm.tm_hour = atoi (word);
    for (s = word; (*s != '\0') && (*s != ':'); s++);
    if (*s == ':')
	tm.tm_min = atoi (++s);
    else
	return (-1);		/* mistake in format */
    for (; (*s != '\0') && (*s != ':'); s++);
    if (*s == ':')
	tm.tm_sec = atoi (++s);
    else
	tm.tm_sec = 0;		/* assume zero */

    str = substring (str, word);/* if no year given, */
    if (*word)			/* assume this year. */
	tm.tm_year = atoi (word) - 1900;
    else
	tm.tm_year = atoi (nowyear) - 1900;

    return (emitl (&tm));
}

get_month (str)
char   *str;
{
    int     i;
    char   *strp;
    int     uclc_diff = 'a' - 'A';
    for (strp = str; !isspace (*strp) && *strp != '\0'; strp++)
	if (isupper (*strp))
	    *strp += uclc_diff;
    for (i = 0; i < 12; i++)
	if (!strncmp (months[i], str, 3))
	    return (i);
    return (-1);
}

/*
 * Routine to convert a localtime(3) format date back into
 * a system format date.
 *
 *	Use a binary search.
 */
time_t
emitl (dp)
struct tm  *dp;
{
    time_t conv;
    register int    i, bit;
    struct tm   dcopy;

    dcopy = *dp;
    dp = &dcopy;
    conv = 0;
    for (i = 30; i >= 0; i--) {
	bit = 1 << i;
	conv |= bit;
	if (dcmp (localtime (&conv), dp) > 0)
	    conv &= ~bit;
    }
    return (conv);
}

/*
 * Compare two localtime dates, return result.
 */
#define DECIDE(a) \
if (dp -> a > dp2 -> a) \
	return (1); \
if (dp -> a < dp2 -> a) \
	return (-1)

static
dcmp (dp, dp2)
register struct tm *dp, *dp2;
{
    DECIDE (tm_year);
    DECIDE (tm_mon);
    DECIDE (tm_mday);
    DECIDE (tm_hour);
    DECIDE (tm_min);
    DECIDE (tm_sec);
    return (0);
}

usage () {
    fprintf (stderr, "Usage: %s [-sR] [-p proto-file]", command);
    fprintf (stderr, " [-am \"date\" or seconds] files ...\n");
    exit (1);
}
