#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/dir.h>
#include	<sys/stat.h>
#include	<sys/file.h>

char	*name;

main( argc, argv )
int	argc;
char	**argv;
{

	char	*dir;
	char	*path;
	char	cwd[MAXNAMLEN+1];
	char*	getcwd();
	char*	rindex();
	int	err_count;

	name = argv[0];
	cwd[MAXNAMLEN] = '\0';
	if( !getwd( cwd ) ) {
		fprintf( stderr, "%s:unable to get current working directory, %s", name, cwd );
		exit( 1 );
	}
	for( argc--, argv++, err_count = 0; argc; argc--, argv++ ) {
		if( chdir( argv[0] ) == -1 ) {
			fprintf( stderr, "%s:unable to chdir to %s\n", name, dir );
			perror( "" );
			err_count++;
		}
		if( (dir = rindex( argv[0], '/' )) ) {
			*dir++ = '\0';
			path = argv[0];
		} else {
			dir = argv[0];
			path = ".";
		}
		err_count += check_link( dir, path );
		if( chdir( cwd ) == -1 ) {
			fprintf( stderr, "%s:unable to chdir to %s\n", name, cwd );
			perror( "" );
			exit( 2 );
		}
	}
	exit( err_count );
}

check_link( top, path )
char	*top;
char	*path;
{

	DIR	*dptr;
	DIR*	opendir();
	char	cwd[MAXNAMLEN+1];
	char	link_name[MAXNAMLEN+1];
	char*	sprintf();
	extern	char	*name;
	int	err_count;
	int	link_size;
	off_t	offset;
	off_t	telldir();
	struct	direct	*dent;
	struct	direct*	readdir();
	struct	stat	stat;

	(void) sprintf( cwd, "%s/%s", path, top );
	if( !(dptr = opendir( "." )) ) {
		fprintf( stderr, "%s:unable to open directory %s", name, cwd );
		perror( "" );
		return 1;
	}
	if( !readdir( dptr )  || !readdir( dptr ) ) {
		fprintf( stderr, "%s:unable to read '.' or '..' in %s\n",
				  name, cwd );
		perror( "" );
		(void) closedir( dptr );
		return 1;
	}
	err_count = 0;
	link_name[MAXNAMLEN] = '\0';
	while( (dent = readdir( dptr )) ) {
		if( lstat( dent->d_name, &stat ) == -1 ) {
			fprintf( stderr, "%s:unable to lstat %s/%s", name, cwd, dent->d_name );
			perror( "" );
			err_count++;
			continue;
		}
		switch( stat.st_mode & S_IFMT ) {
		case	S_IFDIR:
			if( (offset = telldir( dptr )) == -1 ) {
				fprintf( stderr, "%s:unable to telldir on %s\n", cwd );
				perror( "" );
				err_count++;
				continue;
			}
			(void) closedir( dptr );
			if( chdir( dent->d_name ) == -1 ) {
				fprintf( stderr, "%s:unable to chdir to %s/%s", name, cwd, dent->d_name );
				perror( "" );
				return ++err_count;
			}
			err_count += check_link( dent->d_name, cwd );
			if( chdir( ".." ) == -1 && chdir( cwd ) == -1 ) {
				fprintf( stderr, "%s:unable to chdir up to %s", name, cwd);
				return ++err_count;
			}
			if( !(dptr = opendir( "." )) ) {
				fprintf( stderr, "%s:unable to reopendir %s", name, cwd );
				perror( "" );
				return ++err_count;
			}
			seekdir( dptr, offset, 0 );
			break;
		case	S_IFLNK:
			if( (link_size = readlink( dent->d_name, link_name, MAXNAMLEN )) == -1 ) {
				fprintf( stderr, "%s:unable to readlink on %s/%s", cwd, dent->d_name );
				perror( "" );
				err_count++;
				continue;
			}
			link_name[link_size] = '\0';
			if( access( link_name, F_OK ) == -1 ) {
				printf( "%s/%s %s\n", cwd, dent->d_name, link_name );
				err_count++;
			}
			break;
		default:
			break;
		}
	}
	(void) closedir( dptr );
	return err_count;
}
