.TH capp local
.DA Jan 5 1986
.SH NAME
capp \- cut and paste processor
.SH ORIGIN
Metasystems
.SH SYNOPSIS
.ft B
capp [-s \fIchar\fB] [-c \fIchar\fB] [-e \fIchar\fB] [-p \fIchar\fB]
.ft
.SH DESCRIPTION
Capp is a cut and paste processor (hence the name) inspired by 
.I m4
divert/undivert macros. Capp is intended for major text re-organization
in files. Of course, capp is only useful if your favorite editor is not
well equipped to handle such re-organization in a coherent manner. 
.PP
Unlike
.I m4
or
.I sed,
capp makes two passes. During the first pass, standard input is read and the
text between
.B %Cn
(where 
.B n
is an cut index between 0-9) and
.B %E
is saved and removed from input. Thus processed, input is saved in a temporary
file.  
.PP
During the second pass, temporary file is read, and all occurences of
.B %Pn
is replaced with the contents of the cut section
.B n. 
the second pass enables any text to be moved to somewhere 
.I in front
of the location from where it was cut.
.PP
The cut sections remain intact until capp is finished, thus
the same cut may be pasted to several different places. At the end of
processing, all unprocessed cut sections are pasted at the end of the output
in sequence. All output is written on the standard output.
.SH OPTIONS
.PP
The options and their effects are as follows:
.de OP
.TP 6
.B \\-\\$1 \\fI\\$2\\fR
..
.OP s char
changes the 
.B start
character to something other than
.B %.
This character must appear in the first column in the file.
.OP c char
changes the
.B cut
character to something other than
.B C.
.OP e char
changes the
.B end
character to something other than
.B E.
.OP p char
changes the 
.B paste
character to something other than
.B P.
.SH NOTES
.B %C0
is the same as 
.B %E. 
Also, if the cut section number less than 0, or greater
than 9, it is essentially a bitbucket cut.
.SH AUTHOR
Ozan S. Yigit (oz)
.SH SEE ALSO
m4(1).
.SH BUGS
Capp works in a line-oriented mode, thus it is impossible to
cut and paste arbitrary chunks of text from within lines.
.PP
Maximum input line size is 512 bytes.
.PP
Capp is probably redundant in any system that can run a version
of EMACS, or any such editor with powerful multi-buffer cut/paste
or yank/pop operations.
.PP
Capp can only handle standard input. Perhaps multiple file handling
may be a useful addition.
