/***************************************************************************

Version History:

Ver.No	Comment							By
===========================================================================
1.0 	first version (seems to to things right)   		andy@mssx

I declare this program as freeware, i.e. you may duplicate it, give it
to your friends, and transfer it to any machine you like, as long as
you do not change or delete the build in copyright message.

	Andreas Pleschutznig
	Teichhofweg 2
	8044 Graz
	Austria 

Comments and bug reports to:
	andy@mssx	(mcvax!tuvie!mssx!andy)


*****************************************************************************/


#include <curses.h>
#include <fcntl.h>
#include <signal.h>

#define	BELL	0x07
#define ASCX	63
#define ASCY	6
#define HEXY	6
#define HEXX	12

int     path;                   /* path to file to patch */
long	filpos;			/* position in file */
char	secbuf[256];		/* sector read buffer */

int     donix();                /* default signal handling routine */
char	filename[60];
int	length;			/* length of read sector */

main(argc,argv)
int argc;
char *argv[];

{
	if (argc != 2) {
		fprintf(stderr,"Usage: %s filename\n",argv[0]);
		exit(1);
		}
	if (( path = open(argv[1],O_RDWR)) == -1) {
		fprintf(stderr,"%s: Can't open '%s'\n",argv[0],argv[1]);
		exit(1);
		}
	sprintf(filename,"%s",argv[1]);
	initscr();
	refresh();
	signal(SIGINT,donix);
	signal(SIGQUIT,donix);
	cbreak();                       /* set single char input */
	noecho();
	keypad(stdscr,TRUE);
	filpos = 0;			/* set global position to 0 */
	length = 0;
	command();
	endwin();
	close(path);
}

command()

{
	int inval;

	header("PATCH Version 1.0",filename,"(C) 1988 MSS Graz");
	inval = 0;
	while ((inval != 'q') && (inval != 'Q')) {
		move(2,0);
		mvprintw(2,0,"COMMAND : ");
		refresh();
		inval = getch();
		switch (inval) {
			case 'q':
			case 'Q':
				break;
			case 'h':
			case 'H':
			case '?':
				help();
				break;
			case 'f':
			case 'F':
				find_string();
				dump();
				break;
			case '+':
			case 'n':
			case 'N':
				filpos += 256;
				dump();
				break;
			case '-':
			case 'p':
			case 'P':
				filpos -= 256;
				if (filpos < 0)
					filpos = 0;
				dump();
				break;
			case 'D':
			case 'd':
				dump();
				break;
			case 's':
			case 'S':
				set();
				dump();
				break;
			case 'e':
				edit_ascii();
				break;
			case 'E':
				edit_hex();
				break;
			case 'w':
			case 'W':
				wrsec();
				break;
			default:
				werr("Invalid Command !");
			}
		}

}

edit_ascii()
{
	int inval = 0;
	int cury,curx;

	if (length == 0)
		length = dump();
	move(2,0);
	clrtoeol();
	printw("End editing with CNTRL-C");
	curx = cury = 0;
	while (inval != 0x03) {
		move(ASCY+cury,ASCX+curx);
		refresh();
		inval = getch();
		switch (inval) {
			case KEY_UP:
				if (cury)
					cury--;
				else
					beep();
				break;
			case KEY_DOWN:
				if (cury < 15)
					cury++;
				else
					beep();
				break;
			case KEY_RIGHT:
				if (curx < 15)
					curx++;
				else
					beep();
				break;
			case KEY_LEFT:
				if (curx)
					curx--;
				else
					beep();
				break;
			default:
				if ((inval >= 0x20) && (inval <= 0x7e)) {
					secbuf[cury*16+curx] =inval;
					curx++;
					if (curx > 15) {
						curx=0;
						cury++;
						}
					if (cury > 15)
						cury = 0;
					disp(length);
					}
				break;
			}
		}
	move(2,0);
	clrtoeol();
}

gethex(cury,curx)
int	cury,curx;
{
	int val;
	int inlen;
	int value;

	inlen = 0;
	while (inlen < 2) {
		val = getch();
		if (val > 255) 
			return(val);
		if (val < '0')
			return(-1);
		if (val > '9') val &= ~0x20;
		if (((val >= '0') && (val <='9')) || 
		    ((val >= 'A') && (val <= 'F'))) {
			if (val <= '9')
				val -= '0';
			else
				val = val - 'A' + 0x0a;
			switch (inlen) {
				case 0:
					value = val << 4;
					secbuf[cury*16+curx] = value;
					disp(length);
					move(HEXY+cury,HEXX+curx*3+1);
					refresh();
					break;
				case 1:
					value += val ;
					break;
				}
			inlen++;
			}
		}
	return(value);
}

edit_hex()
{
	int inval = 0;
	int cury,curx;

	if (length == 0)
		length = dump();
	move(2,0);
	clrtoeol();
	printw("End editing with CNTRL-C");
	curx = cury = 0;
	while (inval != -1) {
		move(HEXY+cury,HEXX+curx*3);
		refresh();
		inval = gethex(cury,curx);
		switch (inval) {
			case KEY_UP:
				if (cury)
					cury--;
				else
					beep();
				break;
			case KEY_DOWN:
				if (cury < 15)
					cury++;
				else
					beep();
				break;
			case KEY_RIGHT:
				if (curx < 15)
					curx++;
				else
					beep();
				break;
			case KEY_LEFT:
				if (curx)
					curx--;
				else
					beep();
				break;
			default:
				if ((inval >= 0x00) && (inval <= 0xff)) {
					secbuf[cury*16+curx] =inval;
					curx++;
					if (curx > 15) {
						curx=0;
						cury++;
						}
					if (cury > 15)
						cury = 0;
					disp(length);
					}
				break;
			}
		}
	move(2,0);
	clrtoeol();
}

find_string()

{
	int 	stlen;
	char 	string[60];
	int	found;
	int 	searchpos;

	move(2,0);
	clrtoeol();
	printw("String to search : ");
	refresh();
	echo();
	getstr(string);
	noecho();
	move(2,0);
	clrtoeol();
	printw("Searching for '%s'",string);
	found = 0;
	searchpos = 0;
	stlen = strlen(string);
	while (found == 0) {
		while ((256 - searchpos) >= stlen) {
			if (testchar(secbuf+searchpos,string,stlen))
				searchpos++;
			else {
				filpos += searchpos;
				found = 1;
				break;
				}
			}
		if (found == 0) {
			filpos += searchpos;
			searchpos = 0;
			}
		if (rdsec() == 0) {
			found = 1;	
			}
		refresh();
		}
	move (2,0);
	clrtoeol();
}

testchar(buffer,string,length)
char	*buffer;
char	*string;
int	length;
{
	register int i;
	
	i = 0;
	while ( i < length) {
		if (buffer[i] != string[i])
			break;
		i++;
		}
	if ( i == length)
		return(0);
	return(1);
}

set()

{
	echo();
	move(2,0);
	clrtoeol();
	printw("New File Position : ");
	refresh();
	scanw("%lx",&filpos);
	move(2,0);
	clrtoeol();
	noecho();
}

disp(length)
int	length;
{
	int	i,j;

	j = 0;
	mvprintw(4,0," ADDRESS    00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F      ASCII");
	mvprintw(5,0,"===============================================================================");
	for ( i = 0; i < 16; i++) {
		mvprintw(ASCY+i,0,"%08lX",filpos+i*16+j);
		for (j = 0; j < 16; j++) {
			if (( i*16 + j ) >= length) {
				clrtoeol();
				goto Disp1;
				}
			mvprintw(ASCY+i,HEXX+j*3,"%02X",secbuf[i*16+j] & 0xFF);
			}
Disp1:
		for (j = 0; j < 16; j++) {
			if (( i*16 + j ) >= length) {
				clrtobot();
				goto Disp2;
				}
			if (secbuf[i*16+j] >= ' ')
				mvprintw(ASCY+i,ASCX+j,"%c",secbuf[i*16+j]);
			else
				mvprintw(ASCY+i,ASCX+j,".");
			}
		}
Disp2:
	refresh();
}


dump()

{
	int	i,j;

	length = rdsec();
	disp(length);
	return(length);
}

rdsec()

{
	mvprintw(2,55,"Rel. Position : %08lX",filpos);
	lseek(path,filpos,0);
	length = read(path,secbuf,256);
	return(length);
}

wrsec()
{
	lseek(path,filpos,0);
	write(path,secbuf,length);
}

help()

{
	WINDOW	*win;

	win = newwin(0,0,0,0);
	wclear(win);
	mvwprintw(win,3,10,"Valid Commands are :");
	mvwprintw(win,5,15,"D - Dump one page from current file position");
	mvwprintw(win,6,15,"S - Set current file pointer");
	mvwprintw(win,7,15,"F - Find string in file (beginning from curr. position)");
	mvwprintw(win,8,15,"H - Find hex string in file (beginnig from current position)");
	mvwprintw(win,9,15,"+ - Display next sector");
	mvwprintw(win,10,15,"N - Display next sector");
	mvwprintw(win,11,15,"- - Display previous sector");
	mvwprintw(win,12,15,"P - Display previous sector");
	mvwprintw(win,19,15,"Q - Quit Program");
	mvwprintw(win,13,15,"e - Edit ASCII portion of file");
	mvwprintw(win,14,15,"E - Edit binary portion of file");
	mvwprintw(win,15,15,"W - Write modified sector back to disk");
	mvwprintw(win,20,20,"Continue with any char.");
	wrefresh(win);
	getch();
	delwin(win);
	touchwin(stdscr);
	refresh();
}

werr(errstr)
char    *errstr;

{
	beep();
	move(LINES-1,0);
	printw("%s",errstr);
	refresh();
	sleep(2);
	move(LINES-1,0);
	clrtoeol();
	refresh();
}

	

header(left,mid,right)
char    *left;
char    *mid;
char    *right;

{
	mvprintw(0,0,"%s",left);
	mvprintw(0,79-strlen(right),"%s",right);
	mvprintw(0,40-strlen(mid)/2,"%s",mid);
}

donix(sig)
int sig;

{
	signal(sig,donix);
}
