/*
 * body [-s number] [-e number] [-n number] [-{lwc}] [-d n] file . . .
 *
 * -s number		starting unit for printout default = 1
 * -e number		ending unit for printout default = end of file
 * -n number		number of units to print default = 10 units
 * -l			units = line (\n)
 * -w			units = word (nonwhite space)
 * -c			units = characters
 *
 * Can specify only one of -e or -n.
 * If file is not specified, standard input is used.
 * Author: Martin Fouts (fouts@ames-nas)
 */

#include <stdio.h>
#include "body.h"

extern int errno;
int debug;

main(argc,argv)
int argc;
char *argv[];
{
    int sflag,		/* -s present (start) */
        eflag,		/* -e present (end) */
	nflag,		/* -n present (number) */
	dflag,		/* -d present (debug) */
	lwcflag,	/* -l, -w, or -c present (units) */
	start,		/* Place to start output */
	end,		/* Place to end output */
	number,		/* number of units to output */
	nfiles;		/* Number of file entries */
    int i;		/* Good ole' I */
    char **files;	/* Array of file entries */

/*
 * Set the defaults and scan the argument list
 * Then check for errors not noticed by scanargs:
 *   -e and -n both specified
 *   start < 0
 *   end < start
 */
    start = DE_FIRST;
    number = DE_NUMB;
    end = DE_LAST;

    if (scanargs(argc,argv,
        "% s%-start!n e%-end!n n%-number!n lwc%- d%-debug!n filename%*s",
    		&sflag, &start, &eflag, &end, &nflag, &number,
		&lwcflag, &dflag, &debug, &nfiles, &files) == 0) {
        exit(1);
	/* NOT REACHED */
		}

    IFDEBUG(D_ARGS) {
    (void) fprintf(stderr,"sflag = %d, start = %d\n", sflag, start);
    (void) fprintf(stderr,"eflag = %d, end = %d\n", eflag, end);
    (void) fprintf(stderr,"nflag = %d, number = %d\n", nflag, number);
    (void) fprintf(stderr,"dflag = %d, debug = %d\n", dflag, debug);
    (void) fprintf(stderr,"lwcflag = %d\n",lwcflag);
    (void) fprintf(stderr,"nfiles = %d\n", nfiles);
    for (i = 0; i < nfiles; i++)
        (void) fprintf(stderr,"File(%d) = %s\n", i, files[i]);
    }

    if (eflag & nflag) {
	(void) fprintf(stderr,"Only one of -e or -n.\n");
	exit(1);
	/* NOT REACHED */
    }

    if ((eflag != 1) && (nflag == 1))	/* If -n and -s, calculate end */
           end = start + number - 1;

    if (start < 1) {
	(void) fprintf(stderr,"Starting point outside of file.\n");
	exit(1);
	/* NOT REACHED */
    }

    if ((end != DE_LAST) && (start > end)) {
	(void) fprintf(stderr,"Start after end.\n");
	exit(1);
	/* NOT REACHED */
    }

    if (end == DE_LAST)
        number = DE_LAST;
    else
        number = end - start + 1;

/*
 * Print each of the files specified, using pfile
 */
    if (nfiles == 0) {		/* no files, use stdin */
        IFDEBUG(D_LIST)
	    (void) fprintf(stderr,"%s %d %d %d\n", "stdin",
	            start, number, lwcflag);
	(void) pfile(DE_FILE, start, number, lwcflag);
    } else {
        for (i = 0; i < nfiles; i++) { /* Once for each file */
	    IFDEBUG(D_LIST)
                (void) fprintf(stderr,"%s %d %d %d\n",
		       files[i], start, number, lwcflag);
	    pfile(files[i], start, number, lwcflag);
	}
    }
}
